/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.latch;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.cluster.ClusterNode;
import com.atlassian.stash.internal.hazelcast.NodeIdMemberSelector;
import com.atlassian.stash.internal.maintenance.latch.Latch;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.maintenance.latch.LatchableService;
import com.atlassian.stash.internal.maintenance.latch.ResultCollectingExecutionCallback;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.spring.context.SpringAware;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class ClusterableLatch
implements Latch {
    private static final Logger log = LoggerFactory.getLogger(ClusterableLatch.class);
    private final Set<String> drainedMembers;
    private volatile boolean acquired;
    private volatile boolean drained;
    private volatile boolean drainedLocally;
    private volatile String id;
    private volatile boolean unlatched;
    protected final Cluster cluster;
    protected final IExecutorService executor;
    protected final String latchServiceBeanName;
    protected final LatchMode mode;
    protected final Object lock;

    protected ClusterableLatch(LatchMode mode, Cluster cluster, IExecutorService executor, String latchServiceBeanName) {
        this.cluster = cluster;
        this.executor = executor;
        this.latchServiceBeanName = latchServiceBeanName;
        this.mode = mode;
        this.drainedMembers = new CopyOnWriteArraySet<String>();
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(@Nullable String latchId) {
        Collection<Member> remoteMembers;
        if (this.acquired && this.id != null && this.id.equals(latchId)) {
            return;
        }
        Preconditions.checkState((!this.acquired ? 1 : 0) != 0, (Object)"Latch has already been acquired");
        String newId = latchId == null ? UUID.randomUUID().toString() : latchId;
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.acquired ? 1 : 0) != 0, (Object)"Latch has already been acquired");
            this.acquireLocally();
            this.id = newId;
            this.acquired = true;
        }
        if (this.mode == LatchMode.CLUSTER && latchId == null && !(remoteMembers = this.getRemoteMembers()).isEmpty()) {
            AcquireCallback callback = new AcquireCallback();
            this.executor.submitToMembers((Callable)new AcquireLatchTask(this.latchServiceBeanName, newId), remoteMembers, (MultiExecutionCallback)callback);
            try {
                callback.await(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while waiting for latch to be acquired in the cluster");
            }
            if (callback.getLatchedMembers().size() != remoteMembers.size()) {
                this.unlatchLocally();
                this.unlatchOrPassivateNodes(callback.getLatchedMembers());
                throw new IllegalStateException("Failed to acquire the latch on all nodes in the cluster");
            }
        }
    }

    public boolean drain(long timeout, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkState((boolean)this.acquired, (Object)"Latch has not been acquired yet");
        if (this.unlatched) {
            log.debug("This latch is no longer active");
            return false;
        }
        if (this.drained) {
            return true;
        }
        if (this.mode == LatchMode.LOCAL) {
            this.drained |= this.doDrainLocally(timeout, timeUnit);
        } else {
            Collection<Member> nonDrained = this.getNonDrainedMembers();
            if (!nonDrained.isEmpty()) {
                DrainCallback callback = new DrainCallback();
                this.executor.submitToMembers((Callable)new DrainTask(this.latchServiceBeanName, this.id, timeout, timeUnit), nonDrained, (MultiExecutionCallback)callback);
                try {
                    callback.await(500L + timeUnit.toMillis(timeout), TimeUnit.MILLISECONDS);
                    this.drained = callback.isDrained();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return this.drained;
    }

    @Nonnull
    public LatchMode getMode() {
        return this.mode;
    }

    public void onNodeJoined(ClusterNode node) {
        if (this.acquired && !this.unlatched) {
            this.executor.submitToMembers((Callable)new AcquireLatchTask(this.latchServiceBeanName, this.id), (MemberSelector)new NodeIdMemberSelector(node.getId()));
        }
    }

    public void unlatch() {
        Preconditions.checkState((!this.unlatched ? 1 : 0) != 0, (Object)"This latch is no longer active");
        if (this.mode == LatchMode.LOCAL) {
            this.doUnlatchLocally();
        } else {
            this.unlatchOrPassivateNodes(null);
        }
    }

    protected abstract void acquireLocally();

    protected abstract boolean drainLocally(long var1, @Nonnull TimeUnit var3);

    protected abstract void unlatchLocally();

    private boolean doDrainLocally(long timeout, TimeUnit timeUnit) {
        if (!this.drainedLocally) {
            this.drainedLocally |= this.drainLocally(timeout, timeUnit);
        }
        return this.drainedLocally;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnlatchLocally() {
        if (this.unlatched) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.unlatched) {
                return;
            }
            this.unlatchLocally();
            this.unlatched = true;
        }
    }

    private Collection<Member> getNonDrainedMembers() {
        return Chainable.chain((Iterable)this.cluster.getMembers()).filter((Predicate)new Predicate<Member>(){

            public boolean apply(Member member) {
                return !ClusterableLatch.this.drainedMembers.contains(member.getUuid());
            }
        }).toList();
    }

    private Collection<Member> getRemoteMembers() {
        return Chainable.chain((Iterable)this.cluster.getMembers()).filter((Predicate)new Predicate<Member>(){

            public boolean apply(Member member) {
                return !member.localMember();
            }
        }).toList();
    }

    private void unlatchOrPassivateNodes(Collection<Member> members) {
        if (members != null && members.isEmpty()) {
            return;
        }
        UnlatchCallback callback = new UnlatchCallback();
        UnlatchTask unlatchTask = new UnlatchTask(this.latchServiceBeanName, this.id);
        if (members != null) {
            this.executor.submitToMembers((Runnable)unlatchTask, members, (MultiExecutionCallback)callback);
        } else {
            this.executor.submitToAllMembers((Runnable)unlatchTask, (MultiExecutionCallback)callback);
        }
        try {
            callback.await(1L, TimeUnit.MINUTES);
            if (callback.isSuccess()) {
                log.debug("Cluster unlatch completed successfully");
            } else {
                log.warn("Failed to unlatch some cluster members: {}", callback.errorMembers);
                this.executor.executeOnMembers((Runnable)new UnlatchFailedJohnsonTask(), callback.errorMembers);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while waiting for latch to be released on other cluster nodes. Not all nodes may have unlatched", (Throwable)e);
        }
    }

    private static class UnlatchFailedJohnsonTask
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String UNLATCH_FAILED_EVENT_TYPE = "unlatch-failed";
        private static final String UNLATCH_FAILED_EVENT_LEVEL = "error";

        private UnlatchFailedJohnsonTask() {
        }

        @Override
        public void run() {
            Event event = new Event(EventType.get((String)UNLATCH_FAILED_EVENT_TYPE), "Failed to unlatch this cluster node", EventLevel.get((String)UNLATCH_FAILED_EVENT_LEVEL));
            Johnson.getEventContainer().addEvent(event);
        }
    }

    @SpringAware
    protected static abstract class ClusterableLatchTask
    implements Serializable {
        protected final String beanName;
        protected final String latchId;
        protected transient LatchableService service;
        protected transient ClusterableLatch latch;

        protected ClusterableLatchTask(String beanName, String latchId) {
            this.beanName = (String)Preconditions.checkNotNull((Object)beanName, (Object)"beanName");
            this.latchId = (String)Preconditions.checkNotNull((Object)latchId, (Object)"latchId");
        }

        @Autowired
        public void setApplicationContext(ApplicationContext applicationContext) {
            try {
                this.service = (LatchableService)applicationContext.getBean(this.beanName, LatchableService.class);
                Latch l = this.service.getCurrentLatch();
                if (l != null) {
                    Preconditions.checkState((boolean)(l instanceof ClusterableLatch), (String)"Latch %s is not a ClusterableLatch", (Object[])new Object[]{l});
                    this.latch = (ClusterableLatch)l;
                    Preconditions.checkState((boolean)Objects.equals(this.latchId, this.latch.id), (String)"An unexpected latch was found. Expected %s, found %s", (Object[])new Object[]{this.latchId, this.latch.id});
                }
            }
            catch (BeansException e) {
                log.error("Latchable service '{}' not found - cannot drain the cluster latch", (Object)this.beanName, (Object)e);
                throw new IllegalStateException(e);
            }
        }
    }

    private static class UnlatchTask
    extends ClusterableLatchTask
    implements Runnable {
        private static final long serialVersionUID = 1L;

        public UnlatchTask(String latchServiceBeanName, String latchId) {
            super(latchServiceBeanName, latchId);
        }

        @Override
        public void run() {
            Preconditions.checkState((this.latch != null ? 1 : 0) != 0, (String)"Latch for %s was not injected", (Object[])new Object[]{this.beanName});
            Preconditions.checkState((boolean)this.latchId.equals(this.latch.id), (String)"Unexpected latch for %s: expected latch ID %s but got %s", (Object[])new Object[]{this.beanName, this.latchId, this.latch.id});
            this.latch.doUnlatchLocally();
        }
    }

    private static class UnlatchCallback
    extends ResultCollectingExecutionCallback<Void> {
        protected final Set<Member> errorMembers = new CopyOnWriteArraySet<Member>();

        private UnlatchCallback() {
        }

        @Override
        protected void onError(Member member, Throwable throwable) {
            this.errorMembers.add(member);
        }
    }

    private static class DrainTask
    extends ClusterableLatchTask
    implements Callable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final long timeoutMs;

        public DrainTask(String latchServiceBeanName, String latchId, long timeout, TimeUnit timeUnit) {
            super(latchServiceBeanName, latchId);
            this.timeoutMs = timeUnit.toMillis(timeout);
        }

        @Override
        public Boolean call() throws Exception {
            Preconditions.checkState((this.latch != null ? 1 : 0) != 0, (String)"Latch for %s was not injected", (Object[])new Object[]{this.beanName});
            Preconditions.checkState((boolean)this.latchId.equals(this.latch.id), (String)"Unexpected latch for %s: expected latch ID %s but got %s", (Object[])new Object[]{this.beanName, this.latchId, this.latch.id});
            return this.latch.doDrainLocally(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private class DrainCallback
    extends ResultCollectingExecutionCallback<Boolean> {
        private final AtomicBoolean drained = new AtomicBoolean(true);

        private DrainCallback() {
        }

        public boolean isDrained() {
            return this.drained.get();
        }

        @Override
        protected void onError(Member member, Throwable throwable) {
            this.drained.set(false);
        }

        @Override
        protected void onSuccess(Member member, Boolean value) {
            if (Boolean.TRUE.equals(value)) {
                ClusterableLatch.this.drainedMembers.add(member.getUuid());
                log.debug("Node {} drained successfully", (Object)member.getUuid());
            } else {
                this.drained.set(false);
                log.debug("Node {} did not drain: {}", (Object)member.getUuid(), (Object)(value != null ? value.toString() : ""));
            }
        }
    }

    private static class AcquireLatchTask
    extends ClusterableLatchTask
    implements Callable<Void> {
        private final String latchId;

        private AcquireLatchTask(String latchableServiceBeanName, String latchId) {
            super(latchableServiceBeanName, latchId);
            this.latchId = latchId;
        }

        @Override
        public Void call() throws Exception {
            Preconditions.checkState((this.service != null ? 1 : 0) != 0, (String)"LatchableService %s was not injected", (Object[])new Object[]{this.beanName});
            this.service.acquireLatch(LatchMode.CLUSTER, this.latchId);
            return null;
        }
    }

    private static class AcquireCallback
    extends ResultCollectingExecutionCallback<Object> {
        private final Set<Member> latchedMembers = new CopyOnWriteArraySet<Member>();

        private AcquireCallback() {
        }

        public Set<Member> getLatchedMembers() {
            return ImmutableSet.copyOf(this.latchedMembers);
        }

        @Override
        protected void onSuccess(Member member, Object value) {
            this.latchedMembers.add(member);
        }
    }
}

