/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupClientProgressCallback;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupClientPlaceholderStep
extends AbstractMaintenanceTask
implements BackupClientProgressCallback {
    protected static final Logger log = LoggerFactory.getLogger(BackupClientPlaceholderStep.class);
    private final CountDownLatch latch;
    private final I18nService i18nService;
    private volatile int percentage;

    public BackupClientPlaceholderStep(I18nService i18nService) {
        this.i18nService = i18nService;
        this.latch = new CountDownLatch(1);
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("stash.backup.home.dir", new Object[0]), this.percentage);
    }

    public void run() {
        try {
            log.debug("Waiting for client backup progress to reach 100. Current progress: {}", (Object)this.percentage);
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.latch.countDown();
    }

    @Override
    public void onProgressUpdate(int percentage) {
        Preconditions.checkArgument((percentage >= 0 && percentage <= 100 ? 1 : 0) != 0, (Object)"percentage must between 0 and 100");
        Preconditions.checkArgument((percentage >= this.percentage ? 1 : 0) != 0, (Object)String.format("percentage must not decrease (previous value: %d)", percentage));
        log.debug("New progress update from backup client: {}", (Object)percentage);
        this.percentage = Math.min(100, percentage);
        if (percentage == 100) {
            this.latch.countDown();
        }
    }
}

