/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.AbstractLatchAndDrainTask;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.migration.MigrationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class LatchAndDrainDatabaseStep
extends AbstractLatchAndDrainTask<DatabaseLatch> {
    @Autowired
    public LatchAndDrainDatabaseStep(I18nService i18nService, DatabaseManager databaseManager, LatchMode latchMode, @Value(value="${backup.drain.database.timeout}") int drainTimeout) {
        super(i18nService, databaseManager, latchMode, drainTimeout);
    }

    @Override
    protected String getMessage() {
        return this.i18nService.getMessage("stash.migration.closingConnections", new Object[0]);
    }

    @Override
    protected String getResourceName() {
        return "DataSource";
    }

    @Override
    protected ServiceException newDrainFailedException() {
        throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.drain.failed", new Object[0]));
    }
}

