/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.RepositoryPushEvent;
import com.atlassian.stash.hook.HookResponse;
import com.atlassian.stash.hook.PostReceiveHook;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepositoryPushActivity;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class PushPostReceiveHook
implements PostReceiveHook {
    private static final Logger log = LoggerFactory.getLogger(PushPostReceiveHook.class);
    private final RepositoryActivityDao activityDao;
    private final StashAuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final TransactionTemplate transactionTemplate;

    public PushPostReceiveHook(RepositoryActivityDao activityDao, StashAuthenticationContext authenticationContext, EventPublisher eventPublisher, PlatformTransactionManager transactionManager) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    public void onReceive(@Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges, @Nonnull HookResponse response) {
        if (refChanges.isEmpty()) {
            log.debug("{}: post-receive was invoked with no RefChanges", (Object)repository);
            return;
        }
        this.addActivity(repository, refChanges);
        this.publishEvent(repository, refChanges);
    }

    private void addActivity(Repository repository, Collection<RefChange> refChanges) {
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            log.warn("{}: The following ref changes were pushed anonymously:{}", (Object)repository, this.formatRefChanges(refChanges));
            return;
        }
        final InternalRepositoryPushActivity activity = ((InternalRepositoryPushActivity.Builder)((InternalRepositoryPushActivity.Builder)new InternalRepositoryPushActivity.Builder(InternalConverter.convertToInternalRepository((Repository)repository)).createdDate(new Date())).refChanges(refChanges).user(InternalConverter.convertToInternalUser((StashUser)user))).build();
        if (activity.getRefChanges().isEmpty()) {
            log.warn("{}: {} pushed {} ref(s) but no activity could be created because the RefChanges were invalid", new Object[]{repository, user.getName(), refChanges.size()});
            return;
        }
        try {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    PushPostReceiveHook.this.activityDao.create((Object)activity);
                }
            });
        }
        catch (RuntimeException e) {
            log.error("{}: A RepositoryPushActivity could not be created for the following ref changes:{}", new Object[]{repository, this.formatRefChanges(refChanges), e});
        }
    }

    private Object formatRefChanges(final Collection<RefChange> refChanges) {
        return new Object(){

            public String toString() {
                StringBuilder builder = new StringBuilder();
                for (RefChange refChange : refChanges) {
                    builder.append("\n- ").append(refChange.getRefId()).append(": ").append(refChange.getFromHash()).append(" -> ").append(refChange.getToHash()).append(" (").append(refChange.getType()).append(")");
                }
                return builder.toString();
            }
        };
    }

    private void publishEvent(Repository repository, Collection<RefChange> refChanges) {
        this.eventPublisher.publish((Object)new RepositoryPushEvent((Object)this, repository, refChanges));
    }
}

