/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.event.api.EventListener;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.Product;
import com.atlassian.stash.event.LicenseChangedEvent;
import com.atlassian.stash.internal.home.HomeLock;
import com.atlassian.stash.internal.home.HomeLockAcquirer;
import com.atlassian.stash.internal.license.LicenseHelper;
import java.io.File;
import javax.servlet.ServletContext;

public class SharedHomeLockAcquirer
extends HomeLockAcquirer {
    private final LicenseHelper licenseHelper;
    private final ServletContext servletContext;

    public SharedHomeLockAcquirer(File homeDir, LicenseHelper licenseHelper, ServletContext servletContext) {
        super(homeDir);
        this.licenseHelper = licenseHelper;
        this.servletContext = servletContext;
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        if (this.isReLockRequired()) {
            this.unlock();
            try {
                this.lock();
            }
            catch (Exception e) {
                Johnson.getEventContainer((ServletContext)this.servletContext).addEvent(new Event(EventType.get((String)"node-passivated"), String.format("Failed to re-lock shared home directory '%1$s' after changing the license. Please restart %2$s to correct this.", this.homeDir.getAbsolutePath(), Product.NAME), e.getMessage(), EventLevel.get((String)"error")));
                log.error("Failed to modify shared home lock", (Throwable)e);
            }
        }
    }

    protected String getFailedMessage(HomeLock lock) {
        if (lock.isShared()) {
            return String.format("Unable to create and acquire shared lock file '%3$s' for %1$s shared home directory '%2$s'.\n\nPlease ensure that the user running %1$s has permission to write to this directory and that file locking is enabled for your network file system.\n\nIf this is already the case, please check the logs for more information.", Product.NAME, this.homeDir.getAbsolutePath(), lock);
        }
        return super.getFailedMessage(lock);
    }

    protected String getLockDeniedMessage(HomeLock lock) {
        if (lock.isShared()) {
            return String.format("Shared home directory '%2$s' is already locked by a non-clustered instance of %1$s.\n\nPlease stop the other instance of %1$s and restart this instance.\n\nIf you are absolutely certain that no other instance of %1$s is running, please remove the lock file '%3$s' and restart this instance.", Product.NAME, this.homeDir.getAbsolutePath(), lock);
        }
        return super.getLockDeniedMessage(lock);
    }

    protected HomeLock createHomeLock(File homeDir) {
        return new HomeLock(homeDir, this.isSharedLockRequired());
    }

    protected boolean isReLockRequired(HomeLock currentLock) {
        return super.isReLockRequired(currentLock) || currentLock.isShared() ^ this.isSharedLockRequired();
    }

    private boolean isSharedLockRequired() {
        return this.licenseHelper.isClusteringEnabled(false);
    }
}

