/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.history;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.commit.CommitService;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.ChangesRequest;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.ChangesetsBetweenRequest;
import com.atlassian.stash.content.DetailedChangeset;
import com.atlassian.stash.content.DetailedChangesetsRequest;
import com.atlassian.stash.history.HistoryService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=HistoryService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="historyService")
public class HistoryServiceImpl
implements HistoryService {
    private final CommitService commitService;

    @Autowired
    public HistoryServiceImpl(CommitService commitService) {
        this.commitService = commitService;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Page<Change> getChanges(@Nonnull Repository repository, @Nonnull String changesetId, String parentId, @Nonnull PageRequest pageRequest) {
        ChangesRequest request = new ChangesRequest.Builder(repository, changesetId).sinceId(parentId).build();
        return this.getChanges(request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<Change> getChanges(@Nonnull ChangesRequest request, @Nonnull PageRequest pageRequest) {
        return this.commitService.getChanges(request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId) {
        return this.commitService.getChangeset(repository, changesetId);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path) {
        return this.commitService.getChangeset(repository, changesetId, path);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable Collection<String> attributesToLoad) {
        return this.commitService.getChangeset(repository, changesetId, attributesToLoad);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path, @Nullable Collection<String> attributesToLoad) {
        return this.commitService.getChangeset(repository, changesetId, path, attributesToLoad);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Page<Changeset> getChangesets(@Nonnull Repository repository, @Nullable String changesetId, @Nullable String path, @Nonnull PageRequest pageRequest) {
        return this.commitService.getChangesets(repository, changesetId, path, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Page<Changeset> getChangesets(@Nonnull Repository repository, @Nullable String changesetId, @Nullable String path, @Nullable Collection<String> attributesToLoad, @Nonnull PageRequest pageRequest) {
        return this.commitService.getChangesets(repository, changesetId, path, attributesToLoad, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public Page<Changeset> getChangesetsBetween(@Nonnull ChangesetsBetweenRequest request, @Nonnull PageRequest pageRequest) {
        return this.commitService.getChangesetsBetween(request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<DetailedChangeset> getDetailedChangesets(DetailedChangesetsRequest request, PageRequest pageRequest) {
        return this.commitService.getDetailedChangesets(request, pageRequest);
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void streamChanges(@Nonnull ChangesRequest request, @Nonnull ChangeCallback callback) {
        this.commitService.streamChanges(request, callback);
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public void streamChangesetsBetween(@Nonnull ChangesetsBetweenRequest request, @Nonnull ChangesetCallback callback) {
        this.commitService.streamChangesetsBetween(request, callback);
    }
}

