/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.hazelcast.serialization.OsgiSafe;
import com.atlassian.stash.internal.concurrent.BucketKey;
import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.InternalConcurrencyService;
import com.atlassian.stash.internal.concurrent.TaskBucket;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spring.context.SpringAware;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SpringAware
class SubmitTaskToBucketProcessor<T extends Serializable>
implements EntryProcessor<BucketKey, TaskBucket<OsgiSafe<T>>>,
DataSerializable {
    private static final Logger log = LoggerFactory.getLogger(SubmitTaskToBucketProcessor.class);
    private long delayMillis;
    private String executorName;
    private InternalBucketedExecutor<T> executor;
    private OsgiSafe<T> task;

    public SubmitTaskToBucketProcessor() {
    }

    public SubmitTaskToBucketProcessor(String executorName, OsgiSafe<T> task, long delay, TimeUnit timeUnit, InternalBucketedExecutor<T> executor) {
        this.delayMillis = timeUnit.toMillis(delay);
        this.executorName = executorName;
        this.executor = executor;
        this.task = task;
    }

    public EntryBackupProcessor<BucketKey, TaskBucket<OsgiSafe<T>>> getBackupProcessor() {
        return new BackupProcessor(this.task);
    }

    public Object process(Map.Entry<BucketKey, TaskBucket<OsgiSafe<T>>> entry) {
        TaskBucket<Object> bucket = entry.getValue();
        if (bucket == null) {
            bucket = new TaskBucket();
        }
        bucket.add(this.task);
        entry.setValue(bucket);
        if (this.executor == null) {
            log.error("Could not schedule processing of bucket {} for executor {}. Executor has not been initialized!", (Object)entry.getKey().getBucketId(), (Object)this.executorName);
        } else {
            this.executor.scheduleLocally(entry.getKey().getBucketId(), this.delayMillis, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.delayMillis = in.readLong();
        this.executorName = in.readUTF();
        this.task = (OsgiSafe)in.readObject();
    }

    @Resource
    public void setConcurrencyService(InternalConcurrencyService concurrencyService) {
        this.executor = concurrencyService.getBucketedExecutor(this.executorName);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.delayMillis);
        out.writeUTF(this.executorName);
        out.writeObject(this.task);
    }

    private static class BackupProcessor<T>
    implements EntryBackupProcessor<BucketKey, TaskBucket<OsgiSafe<T>>>,
    DataSerializable {
        private OsgiSafe<T> task;

        private BackupProcessor() {
        }

        private BackupProcessor(OsgiSafe<T> task) {
            this.task = task;
        }

        public void processBackup(Map.Entry<BucketKey, TaskBucket<OsgiSafe<T>>> entry) {
            TaskBucket<Object> bucket = entry.getValue();
            if (bucket == null) {
                bucket = new TaskBucket();
            }
            bucket.add(this.task);
            entry.setValue(bucket);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.task = (OsgiSafe)in.readObject();
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.task);
        }
    }
}

