/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.hazelcast.serialization.OsgiSafe;
import com.atlassian.stash.concurrent.BucketedExecutorSettings;
import com.atlassian.stash.concurrent.ConcurrencyPolicy;
import com.atlassian.stash.internal.concurrent.BucketKey;
import com.atlassian.stash.internal.concurrent.ClaimTasksFromBucketProcessor;
import com.atlassian.stash.internal.concurrent.FinishProcessingBucketProcessor;
import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.SubmitTaskToBucketProcessor;
import com.atlassian.stash.internal.concurrent.TaskBucket;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.concurrent.ExecutorUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastBucketedExecutor<T extends Serializable>
implements InternalBucketedExecutor<T> {
    private static Logger log = LoggerFactory.getLogger(HazelcastBucketedExecutor.class);
    private final IMap<BucketKey, TaskBucket<OsgiSafe<T>>> bucketMap;
    private final ScheduledThreadPoolExecutor executor;
    private final String name;
    private final BucketedExecutorSettings<T> settings;
    private final Function<OsgiSafe<T>, T> unwrapFunction;

    public HazelcastBucketedExecutor(String name, BucketedExecutorSettings<T> settings, HazelcastInstance hazelcast, ThreadFactory threadFactory) {
        this.name = name;
        this.settings = settings;
        this.bucketMap = hazelcast.getMap("bucketed.executor.tasks");
        this.executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        this.unwrapFunction = new Function<OsgiSafe<T>, T>(){

            public T apply(OsgiSafe<T> wrapper) {
                return (Serializable)wrapper.getValue();
            }
        };
        this.updateClusterSize(hazelcast.getCluster().getMembers().size());
    }

    public void schedule(@Nonnull T task, long delay, @Nonnull TimeUnit timeUnit) {
        String bucketId = (String)this.settings.getBucketIdExtractor().apply(task);
        this.bucketMap.submitToKey((Object)new BucketKey(this.name, bucketId), new SubmitTaskToBucketProcessor(this.name, new OsgiSafe(task), delay, timeUnit, this));
    }

    public void scheduleLocally(@Nonnull String bucketId, long delay, @Nonnull TimeUnit timeUnit) {
        BucketProcessingBootstrapper bootstrapper = new BucketProcessingBootstrapper(new BucketKey(this.name, bucketId));
        if (delay <= 0L) {
            this.executor.submit(bootstrapper);
        } else {
            this.executor.schedule(bootstrapper, delay, timeUnit);
        }
    }

    public void shutdown() {
        ExecutorUtils.shutdown((ExecutorService)this.executor, (Logger)log);
    }

    public void submit(@Nonnull T task) {
        this.schedule(task, 0L, TimeUnit.SECONDS);
    }

    public void updateClusterSize(int nodeCount) {
        int poolSize = this.getPoolSize(nodeCount);
        this.executor.setCorePoolSize(poolSize);
        this.executor.setMaximumPoolSize(poolSize);
    }

    private int getPoolSize(int numberOfNodes) {
        if (this.settings.getMaxConcurrencyPolicy() == ConcurrencyPolicy.PER_NODE) {
            return this.settings.getMaxConcurrency();
        }
        return (int)Math.ceil((double)this.settings.getMaxConcurrency() / (1.0 * (double)numberOfNodes));
    }

    private class BucketProcessingBootstrapper
    implements Runnable {
        private final BucketKey bucketKey;
        private int attempt = 1;

        private BucketProcessingBootstrapper(BucketKey bucketKey) {
            this.bucketKey = bucketKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List toBeProcessed = (List)HazelcastBucketedExecutor.this.bucketMap.executeOnKey((Object)this.bucketKey, new ClaimTasksFromBucketProcessor(HazelcastBucketedExecutor.this.settings.getBatchSize()));
            if (toBeProcessed == null) {
                HazelcastBucketedExecutor.this.executor.schedule(this, 1L, TimeUnit.SECONDS);
                return;
            }
            if (toBeProcessed.isEmpty()) {
                return;
            }
            try {
                log.trace("Processing bucket '{}' of executor '{}'. Attempt {} of {}", new Object[]{this.bucketKey, HazelcastBucketedExecutor.this.name, this.attempt, HazelcastBucketedExecutor.this.settings.getMaxAttempts()});
                HazelcastBucketedExecutor.this.settings.getProcessor().process(this.bucketKey.getBucketId(), Chainable.chain((Iterable)toBeProcessed).transform(HazelcastBucketedExecutor.this.unwrapFunction).filter(Predicates.notNull()).toList());
                log.trace("Completed processing bucket '{}' of executor '{}'", (Object)this.bucketKey, (Object)HazelcastBucketedExecutor.this.name);
                toBeProcessed = null;
            }
            catch (Error e) {
                log.error("Attempt {} of {} at processing bucket '{}' for executor '{}' caused an error. Processing will not be reattempted", new Object[]{this.attempt, HazelcastBucketedExecutor.this.settings.getMaxAttempts(), this.bucketKey, HazelcastBucketedExecutor.this.name, e});
                toBeProcessed = null;
                throw e;
            }
            catch (Exception e) {
                if (this.attempt < HazelcastBucketedExecutor.this.settings.getMaxAttempts()) {
                    log.info("Attempt {} of {} at processing bucket '{}' for executor '{}' failed: '{}'", new Object[]{this.attempt, HazelcastBucketedExecutor.this.settings.getMaxAttempts(), this.bucketKey, HazelcastBucketedExecutor.this.name, e.getMessage()});
                    log.debug("Exception:", (Throwable)e);
                    ++this.attempt;
                } else {
                    log.error("Attempt {} of {} at processing bucket '{}' for executor '{}' failed: ", new Object[]{this.attempt, HazelcastBucketedExecutor.this.settings.getMaxAttempts(), this.bucketKey, HazelcastBucketedExecutor.this.name, e});
                    toBeProcessed = null;
                }
            }
            finally {
                HazelcastBucketedExecutor.this.bucketMap.executeOnKey((Object)this.bucketKey, new FinishProcessingBucketProcessor(toBeProcessed));
                if (toBeProcessed != null) {
                    HazelcastBucketedExecutor.this.executor.schedule(this, 1L, TimeUnit.SECONDS);
                }
            }
        }
    }
}

