/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.compare;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.compare.CompareDiffRequest;
import com.atlassian.stash.compare.CompareRequest;
import com.atlassian.stash.compare.CompareService;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.content.DiffContentFilter;
import com.atlassian.stash.internal.content.DiffContentCallbackFilter;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.compare.CompareChangeCommandParameters;
import com.atlassian.stash.scm.compare.CompareDiffCommandParameters;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=CompareService.class)
@Service(value="compareService")
public class DefaultCompareService
extends AbstractScmService
implements CompareService {
    @Autowired
    public DefaultCompareService(ScmService scmService) {
        super(scmService);
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.fromRef.repository) and isRepositoryAccessible(#request.toRef.repository)")
    public void streamChanges(@Nonnull CompareRequest request, @Nonnull ChangeCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        this.scmService.getCompareCommandFactory(request).changes(((CompareChangeCommandParameters.Builder)new CompareChangeCommandParameters.Builder().maxChanges(this.maxChanges)).build(), callback).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.fromRef.repository) and isRepositoryAccessible(#request.toRef.repository)")
    public void streamChangesets(@Nonnull CompareRequest request, @Nonnull ChangesetCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        this.scmService.getCompareCommandFactory(request).commits(callback).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.fromRef.repository) and isRepositoryAccessible(#request.toRef.repository)")
    public void streamDiff(@Nonnull CompareDiffRequest request, @Nonnull DiffContentCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)request, (Object)"callback");
        this.scmService.getCompareCommandFactory(this.asCompare(request)).diff(((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)new CompareDiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths((Iterable)request.getPaths())).whitespace(request.getWhitespace())).build(), DiffContentCallbackFilter.filter((DiffContentCallback)callback, (DiffContentFilter)request.getFilter())).call();
    }

    private CompareRequest asCompare(CompareDiffRequest request) {
        return new CompareRequest.Builder(request).build();
    }
}

