/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.stash.commit.graph.CommitGraphNode;
import com.atlassian.stash.commit.graph.SimpleCommitGraphNode;
import com.atlassian.stash.commit.graph.TraversalCallback;
import com.atlassian.stash.commit.graph.TraversalContext;
import com.atlassian.stash.commit.graph.TraversalStatus;
import com.atlassian.stash.commit.graph.TraversalSummary;
import com.atlassian.stash.content.InternalMinimalChangeset;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphUtils;
import com.atlassian.stash.scm.CommandResult;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CachedCommitGraphOutputStream
extends OutputStream {
    private static final int COMMIT_ID_LENGTH = 20;
    private static final TraversalContext NOOP_TRAVERSAL_CONTEXT = new TraversalContext.Builder().build();
    private static final TraversalSummary TRAVERSAL_SUMMARY_SUCCESS = new TraversalSummary.Builder(CommandResult.SUCCEEDED).build();
    private static final TraversalSummary TRAVERSAL_SUMMARY_FAILURE = new TraversalSummary.Builder(CommandResult.FAILED).build();
    private final byte[] buffer = new byte[20];
    private final TraversalCallback callback;
    private State state;
    private int position;
    private MinimalChangeset commit;
    private List<MinimalChangeset> parentCommits;
    private int parentCount;
    private boolean closed;

    public CachedCommitGraphOutputStream(TraversalCallback callback) {
        this.callback = callback;
        this.state = State.INITIALISED;
        this.closed = false;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new CachedCommitGraphOutputStreamIOException("Stream is closed.");
        }
        if (this.position > 20) {
            throw new IOException(String.format("Error reading the index (position = %s, buffer = %s)", this.position, Bytes.asList((byte[])this.buffer)));
        }
        this.buffer[this.position++] = (byte)b;
        switch (this.state) {
            case INITIALISED: {
                this.init();
                break;
            }
            case READING_COMMIT_ID: {
                this.readCommitId();
                break;
            }
            case READING_PARENT_COUNT: {
                this.readParentCount();
                break;
            }
            case READING_PARENT_COMMIT_IDS: {
                this.readParentCommitIds();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        TraversalSummary traversalSummary = TRAVERSAL_SUMMARY_SUCCESS;
        try {
            switch (this.state) {
                case INITIALISED: {
                    return;
                }
                case READING_COMMIT_ID: {
                    if (this.position <= 0) return;
                    traversalSummary = TRAVERSAL_SUMMARY_FAILURE;
                    throw new IOException(String.format("Incomplete commit id (position = %d) ", this.position));
                }
                case READING_PARENT_COUNT: {
                    traversalSummary = TRAVERSAL_SUMMARY_FAILURE;
                    throw new IOException("Missing parent commit count");
                }
                case READING_PARENT_COMMIT_IDS: {
                    traversalSummary = TRAVERSAL_SUMMARY_FAILURE;
                    throw new IOException(String.format("Incomplete parent commit list (position = %d, parents = %d)", this.position, this.parentCommits.size()));
                }
            }
            return;
        }
        finally {
            this.callback.onEnd(traversalSummary);
        }
    }

    private void doCallbackOnNode(CommitGraphNode commitGraphNode) {
        TraversalStatus traversalStatus = this.callback.onNode(commitGraphNode);
        if (traversalStatus == TraversalStatus.FINISH) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected IO exception.", e);
            }
        }
    }

    private boolean hasCompleteCommitId() {
        return this.position == 20;
    }

    private void init() {
        this.callback.onStart(NOOP_TRAVERSAL_CONTEXT);
        this.state = State.READING_COMMIT_ID;
    }

    private void readCommitId() throws IOException {
        if (this.hasCompleteCommitId()) {
            this.commit = this.readCommitId(this.buffer);
            this.parentCount = 0;
            this.position = 0;
            this.state = State.READING_PARENT_COUNT;
        }
    }

    private MinimalChangeset readCommitId(byte[] buffer) throws IOException {
        return new InternalMinimalChangeset(CachedCommitGraphUtils.getByteArrayAsCommitId(buffer));
    }

    private void readParentCount() {
        int readPosition = this.position - 1;
        byte read = this.buffer[readPosition];
        if (CachedCommitGraphUtils.isLastByteInCountArray(read)) {
            this.parentCount = CachedCommitGraphUtils.getByteArrayAsCount(this.buffer, 0, this.position);
            this.position = 0;
            if (this.parentCount == 0) {
                SimpleCommitGraphNode commitGraphNode = new SimpleCommitGraphNode.Builder().commit(this.commit).build();
                this.state = State.READING_COMMIT_ID;
                this.doCallbackOnNode((CommitGraphNode)commitGraphNode);
            } else {
                this.parentCommits = new ArrayList<MinimalChangeset>(this.parentCount);
                this.state = State.READING_PARENT_COMMIT_IDS;
            }
        }
    }

    private void readParentCommitIds() throws IOException {
        if (this.hasCompleteCommitId()) {
            this.parentCommits.add(this.readCommitId(this.buffer));
            this.position = 0;
            if (this.parentCommits.size() == this.parentCount) {
                SimpleCommitGraphNode commitGraphNode = new SimpleCommitGraphNode.Builder().commit(this.commit).parents(this.parentCommits).build();
                this.parentCommits = null;
                this.state = State.READING_COMMIT_ID;
                this.doCallbackOnNode((CommitGraphNode)commitGraphNode);
            }
        }
    }

    private static enum State {
        INITIALISED,
        READING_COMMIT_ID,
        READING_PARENT_COUNT,
        READING_PARENT_COMMIT_IDS;

    }

    public static class CachedCommitGraphOutputStreamIOException
    extends IOException {
        public CachedCommitGraphOutputStreamIOException(String message) {
            super(message);
        }
    }
}

