/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.avatar.AvatarRequest;
import com.atlassian.stash.avatar.AvatarService;
import com.atlassian.stash.avatar.AvatarStoreException;
import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.avatar.SimpleAvatarSupplier;
import com.atlassian.stash.event.ProjectDeletedEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarSource;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.request.RequestLocalCache;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectVisitor;
import com.atlassian.stash.request.RequestContext;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=AvatarService.class)
@Service(value="avatarService")
@Transactional(propagation=Propagation.SUPPORTS)
public class ConfigurableAvatarService
extends AbstractService
implements InternalAvatarService {
    public static final String DEFAULT_SOURCE = "default";
    public static final String DISABLED_SOURCE = "disabled";
    private static final String CACHE_NAME = InternalAvatarService.class.getName();
    private static final Pattern PATTERN_DATA_URI = Pattern.compile("data:([^;]+);base64,([A-Za-z0-9+/]+)=*$");
    private static final Logger log = LoggerFactory.getLogger(ConfigurableAvatarService.class);
    private final CachedReference<AvatarSource> activeSource;
    private final RequestLocalCache<AvatarKey, String> avatarCache;
    private final AvatarSource defaultSource;
    private final AvatarSource disabledSource;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final InternalApplicationPropertiesService propertiesService;
    private final AvatarRepository repository;

    @Autowired
    public ConfigurableAvatarService(I18nService i18nService, NavBuilder navBuilder, InternalApplicationPropertiesService propertiesService, AvatarRepository repository, CacheFactory cacheFactory, @Qualifier(value="urlAvatarSource") AvatarSource defaultSource, @Qualifier(value="webResourceAvatarSource") AvatarSource disabledSource, RequestContext requestContext) {
        this.defaultSource = defaultSource;
        this.disabledSource = disabledSource;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.repository = repository;
        this.activeSource = this.createCachedReference(cacheFactory);
        this.avatarCache = new RequestLocalCache(requestContext);
    }

    @Nonnull
    @Unsecured(value="Creating a supplier from a data URI requires no specific permission")
    public AvatarSupplier createSupplierFromDataUri(@Nonnull String uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        uri = uri.replaceAll("\\s", "").replace('-', '+').replace('_', '/');
        Matcher matcher = PATTERN_DATA_URI.matcher(uri);
        if (!matcher.matches()) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("stash.service.avatar.invaliddatauri", new Object[0]));
        }
        String contentType = matcher.group(1);
        String data = matcher.group(2);
        ByteArrayInputStream base64Data = new ByteArrayInputStream(StringUtils.getBytesUtf8((String)data));
        return new SimpleAvatarSupplier(contentType, (InputStream)new Base64InputStream((InputStream)base64Data));
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void deleteForUser(@Nonnull StashUser user) {
        if (user.getId() != null) {
            this.repository.delete(AvatarType.USER, (Object)user.getId());
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    public void deleteTemporary(@Nonnull String id) {
        this.repository.deleteTemporary(id);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForProject(@Nonnull Project project, int size) {
        Preconditions.checkArgument((((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId() != null ? 1 : 0) != 0, (Object)"The provided project has not been persisted; avatars may not be retrieved for transient projects");
        return this.repository.load(AvatarType.PROJECT, (Object)project.getId(), size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForUser(@Nonnull StashUser user, int size) {
        Preconditions.checkArgument((((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId() != null ? 1 : 0) != 0, (Object)"The provided user has not been persisted; avatars may not be retrieved for transient users");
        return this.repository.load(AvatarType.USER, (Object)user.getId(), size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getProjectDefault(int size) {
        return this.repository.loadDefault(AvatarType.PROJECT, size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForPerson(final @Nonnull Person person, final @Nonnull AvatarRequest request) {
        Preconditions.checkNotNull((Object)person, (Object)"person");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.avatarCache.get(AvatarKey.forPerson(person, request), new Supplier<String>(){

            public String get() {
                return ConfigurableAvatarService.this.doGetUrlForPerson(person, request);
            }
        });
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForProject(final @Nonnull Project project, final @Nonnull AvatarRequest request) {
        Preconditions.checkNotNull((Object)project, (Object)"project");
        return this.avatarCache.get((AvatarKey)project.accept((ProjectVisitor)new AvatarKeyVisitor(request)), new Supplier<String>(){

            public String get() {
                return (String)project.accept((ProjectVisitor)new AvatarProjectVisitor(request));
            }
        });
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getUserDefault(int size) {
        return this.repository.loadDefault(AvatarType.USER, size);
    }

    @Unsecured(value="Anyone is allowed to check whether avatars are enabled")
    public boolean isEnabled() {
        return this.activeSource.get() == this.defaultSource;
    }

    @Unsecured(value="Anyone is allowed to check whether a user's avatar is locally stored")
    public boolean isLocalForUser(@Nonnull StashUser user) {
        return this.repository.isStored(AvatarType.USER, (Object)((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId());
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.cleanup(AvatarType.PROJECT, event.getProject().getId());
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        this.cleanup(AvatarType.USER, event.getDeletedUser().getId());
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public AvatarSupplier readTemporary(@Nonnull String id) {
        return this.repository.loadTemporary(id);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void saveForProject(@Nonnull Project project, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkArgument((((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId() != null ? 1 : 0) != 0, (Object)"The provided project has not been persisted; avatars may not be stored for transient projects");
        this.repository.store(AvatarType.PROJECT, (Object)project.getId(), supplier);
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void saveForUser(@Nonnull StashUser user, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkArgument((((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId() != null ? 1 : 0) != 0, (Object)"The provided user has not been persisted; avatars may not be stored for transient users");
        this.repository.store(AvatarType.USER, (Object)user.getId(), supplier);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public String saveTemporary(@Nonnull AvatarSupplier supplier) {
        return this.repository.storeTemporary(supplier);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setEnabled(boolean enabled) {
        this.propertiesService.setAvatarSource(enabled ? DEFAULT_SOURCE : DISABLED_SOURCE);
        SpringTransactionUtils.invokeAfterCommit((Runnable)new Runnable(){

            @Override
            public void run() {
                ConfigurableAvatarService.this.activeSource.reset();
            }
        });
    }

    private void cleanup(AvatarType type, Object id) {
        try {
            this.repository.delete(type, id);
        }
        catch (AvatarStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug("Could not cleanup avatars for " + type + " " + id, (Throwable)e);
            }
            log.warn("Could not cleanup avatars for " + type + " " + id + ": " + e.getMessage());
        }
    }

    private CachedReference<AvatarSource> createCachedReference(CacheFactory cacheFactory) {
        Supplier<AvatarSource> cacheLoader = new Supplier<AvatarSource>(){

            public AvatarSource get() {
                if (ConfigurableAvatarService.DISABLED_SOURCE.equals(ConfigurableAvatarService.this.propertiesService.getAvatarSource())) {
                    return ConfigurableAvatarService.this.disabledSource;
                }
                return ConfigurableAvatarService.this.defaultSource;
            }
        };
        CacheSettings cacheSettings = new CacheSettingsBuilder().replicateViaInvalidation().build();
        return cacheFactory.getCachedReference(CACHE_NAME, (Supplier)cacheLoader, cacheSettings);
    }

    @Nonnull
    private String doGetUrlForPerson(Person person, AvatarRequest request) {
        StashUser user;
        if (person instanceof StashUser && (user = (StashUser)person).getId() != null && this.repository.isStored(AvatarType.USER, (Object)user.getId())) {
            NavBuilder.Builder builder = this.navBuilder.user(user).avatar(request.getSize());
            return request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }
        return ((AvatarSource)this.activeSource.get()).getUrlForPerson(person, request);
    }

    private class AvatarProjectVisitor
    implements ProjectVisitor<String> {
        private final AvatarRequest request;

        private AvatarProjectVisitor(AvatarRequest request) {
            this.request = (AvatarRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        public String visit(@Nonnull Project project) {
            NavBuilder.Builder builder = ConfigurableAvatarService.this.navBuilder.project(project).avatar(this.request.getSize());
            return this.request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }

        public String visit(@Nonnull PersonalProject project) {
            return ConfigurableAvatarService.this.getUrlForPerson((Person)project.getOwner(), this.request);
        }
    }

    private class AvatarKeyVisitor
    implements ProjectVisitor<AvatarKey> {
        private final AvatarRequest request;

        private AvatarKeyVisitor(AvatarRequest request) {
            this.request = (AvatarRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        public AvatarKey visit(@Nonnull Project project) {
            return AvatarKey.forProject(project, this.request);
        }

        public AvatarKey visit(@Nonnull PersonalProject project) {
            return AvatarKey.forPerson((Person)project.getOwner(), this.request);
        }
    }

    private static class AvatarKey {
        private final Object owner;
        private final AvatarRequest request;

        private AvatarKey(Object owner, AvatarRequest request) {
            this.owner = owner;
            this.request = request;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            AvatarKey that = (AvatarKey)other;
            return this.owner.equals(that.owner) && this.request.equals((Object)that.request);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.request);
        }

        static AvatarKey forPerson(Person person, AvatarRequest request) {
            return new AvatarKey(AvatarKey.personId(person), request);
        }

        static AvatarKey forProject(Project project, AvatarRequest request) {
            return new AvatarKey(project.getKey(), request);
        }

        private static Object personId(Person person) {
            return person instanceof StashUser ? ((StashUser)StashUser.class.cast(person)).getId() : org.apache.commons.lang3.StringUtils.defaultString((String)person.getEmailAddress());
        }
    }
}

