/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="auditEntryLoggingService")
public class DefaultAuditEntryLoggingService
implements AuditEntryLoggingService {
    private static Logger log = LoggerFactory.getLogger((String)"stash.audit-log");
    private static final String LOG_MESSAGE_FORMAT = "%1$s | %2$s | %3$s | %4$d | %5$s | %6$s | %7$s | %8$s";
    private final int maxDetails;

    @Autowired
    public DefaultAuditEntryLoggingService(@Value(value="${audit.details.max.length}") int maxDetails) {
        this.maxDetails = maxDetails;
    }

    public void log(@Nonnull AuditEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        String message = this.getLogMessage(entry);
        log.info(message);
    }

    @VisibleForTesting
    String getLogMessage(AuditEntry event) {
        return String.format(LOG_MESSAGE_FORMAT, this.convertStringsToLogFormat(event.getSourceIpAddress()), this.convertStringsToLogFormat(event.getAction()), this.convertStringsToLogFormat(event.getUser() == null ? null : event.getUser().getName()), event.getTimestamp(), this.convertStringsToLogFormat(event.getTarget()), this.truncate(this.convertStringsToLogFormat(event.getDetails())), this.convertStringsToLogFormat(MDC.get((String)"a-request-id")), this.convertStringsToLogFormat(MDC.get((String)"a-session-id")));
    }

    private String truncate(String s) {
        return StringUtils.abbreviate((String)s, (int)this.maxDetails);
    }

    private String convertStringsToLogFormat(String input) {
        if (input == null) {
            return "-";
        }
        return input.replaceAll("[\r\n]+", "\\n").replaceAll(" \\| ", " PIPE_CHAR ");
    }
}

