/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.event.user.UserAvatarUpdatedEvent;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.DataUriAvatarMetaSupplier;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashAuthenticationContext;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.atlassian.stash.user.AuthenticationException;
import com.atlassian.stash.user.IncorrectPasswordAuthenticationException;
import com.atlassian.stash.user.ServiceUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserService.class)
@Service(value="userService")
public class DefaultUserService
extends AbstractService
implements InternalUserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final InternalAvatarService avatarService;
    private final InternalStashAuthenticationContext authenticationContext;
    private final CrowdControl crowdControl;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PasswordResetHelper passwordResetHelper;
    private final StashUserDao userDao;
    private final UserHelper userHelper;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;
    @Value(value="${page.max.groups}")
    private int maxGroupPageSize;

    @Autowired
    public DefaultUserService(InternalAvatarService avatarService, InternalStashAuthenticationContext authenticationContext, CrowdControl crowdControl, EventPublisher eventPublisher, I18nService i18nService, PasswordResetHelper passwordResetHelper, StashUserDao userDao, UserHelper userHelper) {
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.crowdControl = crowdControl;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.passwordResetHelper = passwordResetHelper;
        this.userDao = userDao;
        this.userHelper = userHelper;
    }

    @Nonnull
    @Transactional(noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser authenticate(@Nonnull String username, @Nonnull String password) {
        log.debug("Authenticating user " + username);
        User crowdUser = this.crowdControl.authenticate(username, password);
        return this.getOrCreateMappedUser(crowdUser);
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void deleteAvatar(@Nonnull StashUser user) {
        this.avatarService.deleteForUser((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user"));
    }

    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public boolean existsGroup(String groupName) {
        return this.crowdControl.findGroup(groupName) != null;
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findGroups(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroups(pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByName(groupName, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN')")
    public Page<String> findGroupsByPrefix(@Nullable String groupPrefix, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByPrefix(groupPrefix, pageRequest);
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<String> findGroupsByUser(@Nonnull String username, @Nonnull PageRequest pageRequest) {
        return this.crowdControl.findGroupsByUser(username, null, false, pageRequest).transform(IdentifierUtils.TO_LOWER_CASE);
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts; it is used for password resets")
    public StashUser findUserByNameOrEmail(@Nonnull String value) {
        User user = this.crowdControl.findUser(value, false);
        if (user == null) {
            user = this.crowdControl.findUserByProperty(UserTermKeys.EMAIL, (Object)value);
        }
        return user == null ? null : this.getOrCreateMappedUser(user);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findUsers(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.userHelper.transform(this.crowdControl.findUsers(pageRequest));
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<? extends StashUser> findUsersByGroup(@Nonnull String groupName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.userHelper.transform(this.crowdControl.findUsersByGroup(groupName, null, false, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<? extends StashUser> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return this.userHelper.transform(this.crowdControl.findUsersByName(username, pageRequest));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<ServiceUser> findServiceUsersByName(@Nullable String displayName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ServiceUser.class, (Page)this.userDao.findServiceUsersByName(displayName, pageRequest));
    }

    @Nonnull
    @Unsecured(value="User avatars are not more privileged than getUserBySlug(String)")
    public CacheableAvatarSupplier getAvatar(@Nonnull StashUser user, int size) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        return this.avatarService.getForUser(user, size);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserById(int id) {
        return this.getUserById(id, false);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserById(int id, boolean deleted) {
        InternalStashUser user = (InternalStashUser)this.userDao.getById((Object)id);
        if (user == null) {
            return null;
        }
        if (deleted || user.getType() != UserType.NORMAL || ((Boolean)user.accept((InternalStashUserVisitor)InternalNormalUser.IS_CROWD_BACKED)).booleanValue()) {
            return user;
        }
        return null;
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserByName(@Nonnull String username) {
        return this.getUserByName(username, false);
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserByName(@Nonnull String username, boolean deleted) {
        if (this.authenticationContext.isAuthenticated() && IdentifierUtils.equalsInLowerCase((String)username, (String)this.authenticationContext.getCurrentUser().getName())) {
            return this.authenticationContext.getCurrentToken().getPrincipal();
        }
        User crowdUser = this.crowdControl.findUser(username, deleted);
        StashUser user = null;
        if (crowdUser != null) {
            user = this.getOrCreateMappedUser(crowdUser);
        } else {
            InternalNormalUser internalUser = this.userDao.findByName(username);
            if (deleted || internalUser != null && internalUser.getType() == UserType.SERVICE) {
                user = internalUser;
            }
        }
        return user;
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public StashUser getUserBySlug(@Nonnull String slug) {
        Preconditions.checkNotNull((Object)slug, (Object)"slug");
        if (this.authenticationContext.isAuthenticated() && this.authenticationContext.getCurrentUser().getSlug().equals(slug)) {
            return this.authenticationContext.getCurrentToken().getPrincipal();
        }
        return this.userDao.findBySlug(slug);
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public Set<? extends StashUser> getUsersById(@Nonnull Set<Integer> ids) {
        return this.getUsersById(ids, false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public Set<? extends StashUser> getUsersById(@Nonnull Set<Integer> ids, boolean deleted) {
        Iterable users = this.userDao.getByIds(ids);
        if (!deleted) {
            users = Iterables.filter((Iterable)users, (Predicate)InternalNormalUser.IS_CROWD_BACKED);
        }
        return ImmutableSet.copyOf((Iterable)users);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<? extends StashUser> getUsersByName(@Nonnull Set<String> usernames) {
        return this.getUsersByName(usernames, false);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<? extends StashUser> getUsersByName(@Nonnull Set<String> usernames, boolean deleted) {
        Set users = this.userDao.findByNames(usernames);
        if (!deleted) {
            users = ImmutableSet.copyOf((Collection)Sets.filter((Set)users, (Predicate)InternalNormalUser.IS_CROWD_BACKED));
        }
        return users;
    }

    @PreAuthorize(value="hasAnyPermission('REPO_ADMIN') or isCurrentUser(#user)")
    public boolean isUserInGroup(@Nonnull StashUser user, final @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)groupName);
        InternalStashUser internalUser = InternalConverter.convertToInternalUser((StashUser)user);
        return (Boolean)internalUser.accept((InternalStashUserVisitor)new InternalStashUserVisitor<Boolean>(){

            public Boolean visit(@Nonnull InternalNormalUser user) {
                User crowdUser = user.getBackingCrowdUser();
                if (crowdUser == null && (crowdUser = DefaultUserService.this.crowdControl.findUser(user.getUsername(), true)) == null) {
                    return false;
                }
                return DefaultUserService.this.crowdControl.isGroupMember(groupName, crowdUser);
            }

            public Boolean visit(@Nonnull InternalServiceUser user) {
                return false;
            }
        });
    }

    @Unsecured(value="This is not restricted by permissions so that SAL tests pass. It should not be exposed via REST")
    public boolean isUserInGroup(@Nonnull String username, @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)groupName);
        StashUser user = this.getUserByName(username);
        return user != null && this.isUserInGroup(user, groupName);
    }

    @Nonnull
    @Transactional
    @Unsecured(value="This should not be more private than findUserByNameOrEmail")
    public Map<String, StashUser> mapUsersByEmail(@Nonnull Set<String> emailAddresses) {
        HashMap usersByEmail = Maps.newHashMapWithExpectedSize((int)emailAddresses.size());
        for (String emailAddress : emailAddresses) {
            StashUser user = this.findUserByNameOrEmail(emailAddress);
            if (user == null) continue;
            usersByEmail.put(emailAddress, user);
        }
        return usersByEmail;
    }

    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public StashUser preauthenticate(@Nonnull String username) {
        log.debug("Authenticating user " + username);
        StashUser user = this.getUserByName(username);
        if (user != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)StashUserAuthenticationToken.forUser((StashUser)user));
        }
        return user;
    }

    @Unsecured(value="This needs to be available to all contexts")
    public void unauthenticate() {
        SecurityContextHolder.clearContext();
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void updateAvatar(@Nonnull StashUser user, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkNotNull((Object)supplier, (Object)"supplier");
        this.doUpdateAvatar(user, (Supplier<AvatarSupplier>)Suppliers.ofInstance((Object)supplier));
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void updateAvatar(@Nonnull StashUser user, @Nonnull String uri) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)uri, (Object)"uri")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank data URI is required");
        this.doUpdateAvatar(user, new DataUriAvatarMetaSupplier(this.avatarService, uri));
    }

    @Transactional
    @PreAuthorize(value="isAuthenticated()")
    public void updatePassword(@Nonnull String currentPassword, @Nonnull String newPassword) {
        String name = this.getCurrentUserForUpdate().getName();
        try {
            User user = this.crowdControl.authenticate(name, currentPassword);
            this.passwordResetHelper.resetPassword(user, newPassword);
        }
        catch (IncorrectPasswordAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.i18nService.createKeyedMessage("stash.service.user.password.invalid", new Object[0]));
        }
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public StashUser updateUser(@Nonnull String displayName, @Nonnull String email) {
        Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        Preconditions.checkNotNull((Object)email, (Object)"email");
        String name = this.getCurrentUserForUpdate().getName();
        User user = this.crowdControl.updateUser(ImmutableUser.newUser().name(name).displayName(displayName).emailAddress(email).toUser());
        return this.userHelper.transform(user);
    }

    private void doUpdateAvatar(@Nonnull StashUser user, @Nonnull Supplier<AvatarSupplier> metaSupplier) {
        this.avatarService.saveForUser((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user"), (AvatarSupplier)((Supplier)Preconditions.checkNotNull(metaSupplier, (Object)"metaSupplier")).get());
        this.eventPublisher.publish((Object)new UserAvatarUpdatedEvent((Object)this, user));
    }

    @Nonnull
    private StashUser getCurrentUserForUpdate() {
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.user.anonymousupdate", new Object[0]));
        }
        return user;
    }

    private StashUser getOrCreateMappedUser(User crowdUser) {
        InternalNormalUser user = this.userHelper.transform(crowdUser);
        if (user.getId() == null) {
            user = this.userDao.create(user);
        }
        return user;
    }
}

