/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermissionVisitor;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DefaultPermissionGraph
implements PermissionGraph {
    private static final Encoding ENCODING = new Encoding();
    private final long[] values;

    private DefaultPermissionGraph(long[] values) {
        this.values = values;
    }

    public boolean isGranted(@Nonnull Permission permission, @Nullable Object resource) {
        if (this.values.length == 0) {
            return false;
        }
        Matcher matcher = ENCODING.createMatcher(permission, resource);
        for (long value : this.values) {
            if (!matcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.values.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultPermissionGraph{values={");
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ENCODING.toString(this.values[i]));
            }
        }
        sb.append("}}");
        return sb.toString();
    }

    static interface Matcher {
        public boolean matches(long var1);
    }

    static class Encoding {
        private static final long FLAG_PERM_GLOBAL = 0x100000000000000L;
        private static final long FLAG_PERM_PROJECT = 0x200000000000000L;
        private static final long FLAG_PERM_REPO = 0x400000000000000L;
        private static final int[] ENCODED_PERMISSIONS = new int[Permission.values().length];
        private static final Map<Integer, Permission> DECODED_PERMISSIONS = Maps.newHashMap();

        Encoding() {
        }

        public String toString(long encoded) {
            String permissionString = Encoding.decodePermission(encoded).toString();
            if ((encoded & 0x100000000000000L) != 0L) {
                return permissionString;
            }
            return permissionString + ": " + Encoding.decodeResourceId(encoded);
        }

        public long encode(@Nonnull Permission permission, @Nullable Integer resourceId) {
            Preconditions.checkArgument((resourceId == null || resourceId > 0 ? 1 : 0) != 0, (Object)"resourceId must be null or greater than 0");
            return Encoding.getCategory(permission) | Encoding.encodeResourceId(resourceId) | (long)Encoding.encodeEffectivePermissionInt(permission);
        }

        @Nonnull
        public Matcher createMatcher(@Nonnull Permission permission, @Nullable Object resource) {
            Preconditions.checkArgument((resource == null || resource instanceof Project || resource instanceof Repository ? 1 : 0) != 0);
            final int permissionInt = Encoding.encodePermissionInt(permission);
            final int projectId = this.getProjectId(resource);
            final int repositoryId = this.getRepositoryId(resource);
            return new Matcher(){

                @Override
                public boolean matches(long encoded) {
                    if ((encoded & (long)permissionInt) == 0L) {
                        return false;
                    }
                    if (projectId == 0 && repositoryId == 0) {
                        return true;
                    }
                    if ((encoded & 0x100000000000000L) != 0L) {
                        return true;
                    }
                    int encodedId = Encoding.decodeResourceId(encoded);
                    return (encoded & 0x200000000000000L) != 0L && projectId != 0 && (encodedId == 0 || projectId == encodedId) || (encoded & 0x400000000000000L) != 0L && repositoryId != 0 && (encodedId == 0 || repositoryId == encodedId);
                }
            };
        }

        private int getProjectId(Object resource) {
            if (resource instanceof Project) {
                return ((Project)resource).getId();
            }
            if (resource instanceof Repository) {
                return ((Repository)resource).getProject().getId();
            }
            return 0;
        }

        private int getRepositoryId(Object resource) {
            return resource instanceof Repository ? ((Repository)resource).getId() : 0;
        }

        private static long getCategory(Permission permission) {
            if (permission.isGlobal()) {
                return 0x100000000000000L;
            }
            if (permission.isResource(Project.class)) {
                return 0x200000000000000L;
            }
            if (permission.isResource(Repository.class)) {
                return 0x400000000000000L;
            }
            throw new IllegalArgumentException("Unsupported permission type " + permission);
        }

        @VisibleForTesting
        static int decodeResourceId(long encoded) {
            return (int)(encoded >> 24);
        }

        private static long encodeResourceId(Integer resourceId) {
            return resourceId != null ? (long)resourceId.intValue() << 24 : 0L;
        }

        @VisibleForTesting
        static Permission decodePermission(long encoded) {
            int permission = 0xFFFFFF & (int)encoded;
            return DECODED_PERMISSIONS.get(permission);
        }

        private static int encodePermissionInt(Permission permission) {
            return 1 << permission.getId();
        }

        private static int encodeEffectivePermissionInt(Permission permission) {
            return ENCODED_PERMISSIONS[permission.ordinal()];
        }

        private long getMatcherFor(Project project) {
            return 0x200000000000000L | Encoding.encodeResourceId((Integer)Preconditions.checkNotNull((Object)((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId(), (Object)"project.id"));
        }

        static {
            for (Permission permission : Permission.values()) {
                int value = Encoding.encodePermissionInt(permission);
                for (Permission inherited : permission.getInheritedPermissions()) {
                    value |= Encoding.encodePermissionInt(inherited);
                }
                Encoding.ENCODED_PERMISSIONS[permission.ordinal()] = value;
                DECODED_PERMISSIONS.put(value, permission);
            }
        }
    }

    public static class Builder
    implements InternalGrantedPermissionVisitor {
        private List<Long> values = Lists.newArrayList();

        public Builder add(@Nonnull InternalGrantedPermission grantedPermission) {
            grantedPermission.accept((InternalGrantedPermissionVisitor)this);
            return this;
        }

        public Builder add(@Nonnull Permission permission, @Nullable Integer resourceId) {
            this.values.add(ENCODING.encode(permission, resourceId));
            return this;
        }

        public Builder addAll(@Nonnull DefaultPermissionGraph permissions) {
            for (long value : permissions.values) {
                this.values.add(value);
            }
            return this;
        }

        public Builder addAll(@Nonnull Iterable<? extends InternalGrantedPermission> permissions) {
            for (InternalGrantedPermission internalGrantedPermission : permissions) {
                this.add(internalGrantedPermission);
            }
            return this;
        }

        public DefaultPermissionGraph build() {
            Collections.sort(this.values);
            long prev = 0L;
            ListIterator<Long> it = this.values.listIterator();
            while (it.hasNext()) {
                long value = it.next();
                if ((value & 0xFFFFFFFFFF000000L) == (prev & 0xFFFFFFFFFF000000L)) {
                    it.remove();
                    it.previous();
                    it.set(value |= prev);
                    it.next();
                }
                prev = value;
            }
            long[] v = new long[this.values.size()];
            int index = 0;
            for (Long value : this.values) {
                v[index++] = value;
            }
            return new DefaultPermissionGraph(v);
        }

        public Builder clearAll(Project project) {
            long projectMatcher = ENCODING.getMatcherFor(project);
            Iterator<Long> it = this.values.iterator();
            while (it.hasNext()) {
                long value = it.next();
                if ((value & projectMatcher) != projectMatcher) continue;
                ENCODING;
                if (Encoding.decodeResourceId(value) != project.getId()) continue;
                it.remove();
                break;
            }
            return this;
        }

        public void visit(@Nonnull InternalGlobalPermission globalPermission) {
            this.values.add(ENCODING.encode(globalPermission.getPermission(), null));
        }

        public void visit(@Nonnull InternalProjectPermission projectPermission) {
            this.values.add(ENCODING.encode(projectPermission.getPermission(), projectPermission.getProject().getId()));
        }

        public void visit(@Nonnull InternalRepositoryPermission repositoryPermission) {
            this.values.add(ENCODING.encode(repositoryPermission.getPermission(), repositoryPermission.getRepository().getId()));
            this.values.add(ENCODING.encode(Permission.PROJECT_VIEW, repositoryPermission.getRepository().getProject().getId()));
        }
    }
}

