/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.language.Language;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.user.InternalUserLocaleService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="stashLocaleResolver")
@AvailableToPlugins(value=LocaleResolver.class)
public class StashLocaleResolver
implements LocaleResolver {
    private final InternalLanguageService languageService;
    private final InternalLocaleService localeService;
    private final InternalUserLocaleService userLocaleService;
    private final UserService userService;

    @Autowired
    public StashLocaleResolver(InternalLanguageService languageService, InternalLocaleService localeService, InternalUserLocaleService userLocaleService, UserService userService) {
        this.languageService = languageService;
        this.localeService = localeService;
        this.userLocaleService = userLocaleService;
        this.userService = userService;
    }

    public Locale getLocale(HttpServletRequest request) {
        return this.getLocale();
    }

    public Locale getLocale() {
        return this.processLocale(this.localeService.getLocale());
    }

    public Locale getLocale(@Nullable UserKey userKey) {
        StashUser user = this.getUserByKey(userKey);
        return this.processLocale(user != null ? this.userLocaleService.getLocale(user) : null);
    }

    public Set<Locale> getSupportedLocales() {
        return Chainable.chain((Iterable)this.languageService.getLanguages()).transform((Function)new Function<Language, Locale>(){

            public Locale apply(Language input) {
                return input.getLocale();
            }
        }).toSet();
    }

    private StashUser getUserByKey(UserKey key) {
        if (key == null) {
            return null;
        }
        try {
            return this.userService.getUserById(Integer.parseInt(key.getStringValue()));
        }
        catch (NumberFormatException e) {
            return this.userService.getUserByName(key.getStringValue());
        }
    }

    private Locale processLocale(Locale locale) {
        return (Locale)Objects.firstNonNull((Object)locale, (Object)Locale.getDefault());
    }
}

