/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetails;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetailsProvider;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.atlassian.stash.pull.RescopeDetails;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultRescopeProcessor
implements RescopeProcessor {
    private static final ChangesetToCommit AS_ADDED = new ChangesetToCommit(PullRequestRescopeCommitAction.ADDED);
    private static final ChangesetToCommit AS_REMOVED = new ChangesetToCommit(PullRequestRescopeCommitAction.REMOVED);
    private static final Logger log = LoggerFactory.getLogger(DefaultRescopeProcessor.class);
    private final PullRequestActivityDao activityDao;
    private final InternalRescopeActivityDetailsProvider detailsProvider;
    private final ExecutorService executorService;
    private final TransactionSynchronizer synchronizer;
    private final TransactionTemplate transactionTemplate;
    private volatile boolean initialized;

    public DefaultRescopeProcessor(PullRequestActivityDao activityDao, InternalRescopeActivityDetailsProvider detailsProvider, ExecutorService executorService, TransactionSynchronizer synchronizer, TransactionTemplate transactionTemplate) {
        this.activityDao = activityDao;
        this.detailsProvider = detailsProvider;
        this.executorService = executorService;
        this.synchronizer = synchronizer;
        this.transactionTemplate = transactionTemplate;
    }

    public void deleteEmptyRescopes() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                int count = DefaultRescopeProcessor.this.activityDao.deleteEmptyRescopes();
                if (count == 0) {
                    log.debug("No empty rescopes were found");
                } else {
                    log.debug("Deleted {} empty rescope(s)", (Object)count);
                }
            }
        });
    }

    @EventListener
    public synchronized void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        List ids = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<Long>>(){

            public List<Long> doInTransaction(TransactionStatus status) {
                return DefaultRescopeProcessor.this.activityDao.findCalculableRescopes();
            }
        });
        if (ids.isEmpty()) {
            log.debug("Rescope details have already been calculated for all open pull requests");
        } else {
            log.info("Scheduling detail calculation for {} pull request rescopes", (Object)ids.size());
            Iterator i$ = ids.iterator();
            while (i$.hasNext()) {
                long id = (Long)i$.next();
                this.executorService.submit(new RescopeCalculator(id));
            }
        }
    }

    @Override
    public void process(@Nonnull InternalPullRequestRescopeActivity activity) {
        this.processAll(activity.getPullRequest(), Collections.singletonList(activity));
    }

    @Override
    public void processAll(@Nonnull InternalPullRequest pullRequest, @Nonnull List<InternalPullRequestRescopeActivity> activities) {
        if (activities.isEmpty()) {
            return;
        }
        ArrayList updated = Lists.newArrayList();
        for (InternalPullRequestRescopeActivity rescope : activities) {
            if (rescope.isPrecalculated()) continue;
            InternalRescopeActivityDetails details = this.detailsProvider.getDetails(rescope);
            rescope.setAdded(details.getAdded());
            rescope.setRemoved(details.getRemoved());
            updated.add(rescope);
        }
        if (!updated.isEmpty()) {
            this.updateActivities(pullRequest, updated);
        }
    }

    @Override
    public void queue(final @Nonnull InternalPullRequestRescopeActivity activity) {
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                log.debug("Queuing detail processing for rescope {}", (Object)activity.getId());
                DefaultRescopeProcessor.this.executorService.submit(new RescopeCalculator(activity.getId()));
            }
        });
    }

    private void updateActivities(InternalPullRequest pullRequest, final List<InternalPullRequestRescopeActivity> activities) {
        try (Timer timer = TimerUtils.start((String)(pullRequest.getGlobalId() + " - Update commits for " + activities.size() + " activities"));){
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    for (InternalPullRequestRescopeActivity activity : activities) {
                        RescopeDetails added = activity.getAdded();
                        RescopeDetails removed = activity.getRemoved();
                        InternalPullRequestRescopeActivity updated = new InternalPullRequestRescopeActivity.Builder(activity).commits((Iterable)Lists.transform((List)added.getChangesets(), (Function)AS_ADDED)).commits((Iterable)Lists.transform((List)removed.getChangesets(), (Function)AS_REMOVED)).totalAdded(added.getTotal()).totalRemoved(removed.getTotal()).build();
                        DefaultRescopeProcessor.this.activityDao.update((Object)updated);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            log.warn(pullRequest.getGlobalId() + ": Could not store calculated rescope details", (Throwable)e);
        }
    }

    private class RescopeCalculator
    implements Runnable {
        private final long activityId;

        private RescopeCalculator(long activityId) {
            this.activityId = activityId;
        }

        @Override
        public void run() {
            InternalPullRequestRescopeActivity activity = (InternalPullRequestRescopeActivity)DefaultRescopeProcessor.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalPullRequestRescopeActivity>(){

                public InternalPullRequestRescopeActivity doInTransaction(TransactionStatus status) {
                    status.setRollbackOnly();
                    return (InternalPullRequestRescopeActivity)HibernateUtils.cast((Object)DefaultRescopeProcessor.this.activityDao.getById((Object)RescopeCalculator.this.activityId), InternalPullRequestRescopeActivity.class);
                }
            });
            if (activity != null && !activity.isPrecalculated()) {
                DefaultRescopeProcessor.this.process(activity);
            }
        }
    }

    private static class ChangesetToCommit
    implements Function<Changeset, InternalPullRequestRescopeCommit> {
        private final PullRequestRescopeCommitAction action;

        private ChangesetToCommit(PullRequestRescopeCommitAction action) {
            this.action = action;
        }

        public InternalPullRequestRescopeCommit apply(Changeset changeset) {
            return new InternalPullRequestRescopeCommit.Builder().action(this.action).changesetId(changeset.getId()).build();
        }
    }
}

