/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.stash.content.AbstractChangesetCallback;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.exception.CommandUsageException;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalRescopeDetails;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetails;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetailsProvider;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component(value="pullRequestRescopeActivityDetailsProvider")
public class DefaultRescopeActivityDetailsProvider
implements InternalRescopeActivityDetailsProvider {
    private static final Comparator<Changeset> DATE_COMPARATOR = new Comparator<Changeset>(){

        @Override
        public int compare(Changeset left, Changeset right) {
            return right.getAuthorTimestamp().compareTo(left.getAuthorTimestamp());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultRescopeActivityDetailsProvider.class);
    private final int displayChangesets;
    private final int maxChangesets;
    private final ScmService scmService;

    @Autowired
    public DefaultRescopeActivityDetailsProvider(ScmService scmService, @Value(value="${pullrequest.rescope.changesets.display}") int displayChangesets, @Value(value="${pullrequest.rescope.changesets.max}") int maxChangesets) {
        this.displayChangesets = displayChangesets;
        this.maxChangesets = maxChangesets;
        this.scmService = scmService;
    }

    @Nonnull
    @Cacheable(value={"rescopeActivityDetails"}, key="#activity.id")
    public InternalRescopeActivityDetails getDetails(@Nonnull InternalPullRequestRescopeActivity activity) {
        InternalPullRequest pullRequest = activity.getPullRequest();
        InternalRepository repository = pullRequest.getScopeRepository();
        InternalRepository secondaryRepository = pullRequest.isCrossRepository() ? pullRequest.getFromRef().getRepository() : null;
        HashMap<String, Changeset> cache = new HashMap<String, Changeset>(this.maxChangesets);
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory((Repository)repository);
        Set<String> current = this.getChangesetsBetween(commandFactory, activity.getToHash(), activity.getFromHash(), secondaryRepository, cache);
        Set<String> previous = this.getChangesetsBetween(commandFactory, activity.getPreviousToHash(), activity.getPreviousFromHash(), secondaryRepository, cache);
        return new InternalRescopeActivityDetails(this.toRescopeDetails(current, previous, cache), this.toRescopeDetails(previous, current, cache));
    }

    private Set<String> getChangesetsBetween(ScmCommandFactory commandFactory, String untilId, String sinceId, InternalRepository secondaryRepository, Map<String, Changeset> cache) {
        MappingChangesetCallback currentCallback = new MappingChangesetCallback(cache, this.maxChangesets);
        try {
            commandFactory.commits(new CommitsCommandParameters.Builder().include(sinceId, new String[0]).exclude(untilId, new String[0]).secondaryRepository((Repository)secondaryRepository).build(), (ChangesetCallback)currentCallback).call();
        }
        catch (CommandUsageException e) {
            log.warn("Changesets between {} and {} could not be calculated; both commits no longer exist", (Object)sinceId, (Object)untilId);
        }
        return currentCallback.getChangesetIds();
    }

    private InternalRescopeDetails toRescopeDetails(Set<String> include, Set<String> exclude, Map<String, Changeset> cache) {
        HashSet difference = Sets.newHashSet(include);
        difference.removeAll(exclude);
        if (difference.isEmpty()) {
            return InternalRescopeDetails.EMPTY;
        }
        List changesets = Lists.newArrayListWithCapacity((int)difference.size());
        for (String changesetId : difference) {
            Changeset changeset = cache.get(changesetId);
            if (changeset == null) continue;
            changesets.add(changeset);
        }
        Collections.sort(changesets, DATE_COMPARATOR);
        if (changesets.size() > this.displayChangesets) {
            changesets = changesets.subList(0, this.displayChangesets);
        }
        return new InternalRescopeDetails.Builder().changesets((Iterable)changesets).total(difference.size()).build();
    }

    private static class MappingChangesetCallback
    extends AbstractChangesetCallback {
        private final Map<String, Changeset> cache;
        private final int maxChangesets;
        private final Set<String> changesetIds;

        private MappingChangesetCallback(Map<String, Changeset> cache, int maxChangesets) {
            this.cache = cache;
            this.maxChangesets = maxChangesets;
            this.changesetIds = Sets.newHashSet();
        }

        public Set<String> getChangesetIds() {
            return this.changesetIds;
        }

        public boolean onChangeset(@Nonnull Changeset changeset) {
            String changesetId = changeset.getId();
            if (this.cache.size() < this.maxChangesets) {
                this.cache.put(changesetId, changeset);
            }
            this.changesetIds.add(changesetId);
            return true;
        }
    }
}

