/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentOperations;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationCommentPostProcessor
implements CommentPostProcessor {
    private StashAuthenticationContext authenticationContext;
    private PermissionService permissionService;

    @Autowired
    public OperationCommentPostProcessor(StashAuthenticationContext authenticationContext, PermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
    }

    @Override
    public InternalComment process(InternalRepository repository, InternalComment comment) {
        this.process(comment, this.authenticationContext.getCurrentUser(), this.isRepoAdmin(repository));
        return comment;
    }

    @Override
    public List<InternalComment> processAll(InternalRepository repository, List<InternalComment> comments) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean isRepoAdmin = this.isRepoAdmin(repository);
        for (InternalComment comment : comments) {
            this.process(comment, currentUser, isRepoAdmin);
        }
        return comments;
    }

    private void process(InternalComment comment, StashUser currentUser, boolean isRepoAdmin) {
        if (comment.getPermittedOperations() == null) {
            comment.setPermittedOperations(InternalCommentOperations.of((boolean)OperationCommentPostProcessor.canEdit(currentUser, (Comment)comment), (boolean)OperationCommentPostProcessor.canDelete(currentUser, (Comment)comment, isRepoAdmin)));
        }
        for (Comment reply : comment.getComments()) {
            if (reply == null) continue;
            this.process(InternalConverter.convertToInternalComment((Comment)reply), currentUser, isRepoAdmin);
        }
    }

    private boolean isRepoAdmin(InternalRepository repository) {
        return this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_ADMIN);
    }

    private static boolean canEdit(StashUser currentUser, Comment comment) {
        return comment.getAuthor().equals(currentUser);
    }

    private static boolean canDelete(StashUser currentUser, Comment comment, boolean isRepoAdmin) {
        return isRepoAdmin || comment.getAuthor().equals(currentUser);
    }
}

