/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAttributeContext;
import com.atlassian.stash.pull.PullRequestAttributeProvider;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentCountProvider
implements PullRequestAttributeProvider {
    private final PullRequestActivityDao activityDao;

    @Autowired
    public CommentCountProvider(PullRequestActivityDao activityDao) {
        this.activityDao = activityDao;
    }

    public void provideAttributes(@Nonnull PullRequestAttributeContext context) {
        ImmutableMap pullRequestsById = Maps.uniqueIndex((Iterable)context, (Function)new Function<PullRequest, Long>(){

            public Long apply(PullRequest pullRequest) {
                return InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId();
            }
        });
        Map commentsByPullRequest = this.activityDao.countCommentsByPullRequest(pullRequestsById.keySet());
        for (Map.Entry entry : commentsByPullRequest.entrySet()) {
            Long pullRequestId = (Long)entry.getKey();
            Long commentCount = (Long)entry.getValue();
            context.addAttribute((PullRequest)pullRequestsById.get(pullRequestId), "commentCount", Long.toString(commentCount));
        }
    }
}

