/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.util.UncheckedOperation;
import com.atlassian.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class PullRequestStateGuard {
    private final AtomicInteger updateCount = new AtomicInteger(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIfUpdated(@Nonnull UncheckedOperation<Void> updateOperation) {
        if (this.updateCount.get() == 0) {
            return;
        }
        AtomicInteger atomicInteger = this.updateCount;
        synchronized (atomicInteger) {
            int preUpdateCount = this.updateCount.get();
            if (preUpdateCount > 0) {
                updateOperation.perform();
                this.updateCount.addAndGet(-preUpdateCount);
            }
        }
    }

    public void updated() {
        this.updateCount.incrementAndGet();
    }
}

