/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAttributeContext;
import com.atlassian.stash.pull.PullRequestAttributeProvider;
import com.atlassian.stash.util.Page;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pullRequestEnricher")
public class PluginPullRequestEnricher
implements PullRequestEnricher {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginPullRequestEnricher(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public Page<InternalPullRequest> enrich(@Nonnull Page<InternalPullRequest> page) {
        Context context = new Context(page);
        for (PullRequestAttributeProvider provider : this.getAttributeProviders()) {
            provider.provideAttributes((PullRequestAttributeContext)context);
        }
        return page.transform((Function)new Enricher(context));
    }

    private List<PullRequestAttributeProvider> getAttributeProviders() {
        return this.pluginAccessor.getEnabledModulesByClass(PullRequestAttributeProvider.class);
    }

    private static class Enricher
    implements Function<InternalPullRequest, InternalPullRequest> {
        private final Context context;

        public Enricher(Context context) {
            this.context = context;
        }

        public InternalPullRequest apply(InternalPullRequest pullRequest) {
            AttributeMap.Builder attributes = this.context.getAttributes().get(pullRequest);
            pullRequest.setAttributes(attributes == null ? AttributeMap.EMPTY : attributes.build());
            return pullRequest;
        }
    }

    private static class Context
    implements PullRequestAttributeContext {
        private final Map<PullRequest, AttributeMap.Builder> attributes = new HashMap<PullRequest, AttributeMap.Builder>();
        private final Iterable<PullRequest> pullRequests;

        private Context(Page<? extends PullRequest> pullRequests) {
            this.pullRequests = pullRequests.getValues();
        }

        public Iterator<PullRequest> iterator() {
            return this.pullRequests.iterator();
        }

        public void addAttribute(@Nonnull PullRequest pullRequest, @Nonnull String key, @Nonnull String value) {
            Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            Preconditions.checkNotNull((Object)key, (Object)"key");
            Preconditions.checkNotNull((Object)value, (Object)"value");
            AttributeMap.Builder builder = this.attributes.get(pullRequest);
            if (builder == null) {
                builder = new AttributeMap.Builder();
                this.attributes.put(pullRequest, builder);
            }
            builder.add(key, new String[]{value});
        }

        @Nonnull
        protected Map<PullRequest, AttributeMap.Builder> getAttributes() {
            return this.attributes;
        }
    }
}

