/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.scm.ScmLatch;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import javax.annotation.Nonnull;

public class UnlatchScmStep
extends AbstractMaintenanceTask {
    private final I18nService i18nService;
    private final InternalScmService scmService;
    private volatile boolean unlatched;

    public UnlatchScmStep(I18nService i18nService, InternalScmService scmService) {
        this.i18nService = i18nService;
        this.scmService = scmService;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("stash.backup.restore.resuming.scm", new Object[0]), this.unlatched ? 100 : 0);
    }

    public void run() {
        ScmLatch latch = (ScmLatch)this.scmService.getCurrentLatch();
        if (latch == null) {
            throw new IllegalStateException("SCMs are not latched");
        }
        latch.unlatch();
        this.unlatched = true;
    }
}

