/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UnlatchDatabaseStep
extends AbstractMaintenanceTask {
    private final DatabaseManager databaseManager;
    private final I18nService i18nService;
    private final DatabaseHandle target;
    private volatile boolean unlatched;

    private UnlatchDatabaseStep(DatabaseHandle targetDatabase, I18nService i18nService, DatabaseManager databaseManager) {
        this.i18nService = i18nService;
        this.databaseManager = databaseManager;
        this.target = targetDatabase;
    }

    @Nonnull
    public Progress getProgress() {
        String message = this.target == null ? this.i18nService.getMessage("stash.backup.restore.resuming.database", new Object[0]) : this.i18nService.getMessage("stash.backup.restore.switching.database", new Object[0]);
        return new ProgressImpl(message, this.unlatched ? 100 : 0);
    }

    public void run() {
        DatabaseLatch latch = (DatabaseLatch)this.databaseManager.getCurrentLatch();
        if (latch == null) {
            throw new IllegalStateException("The database is not latched");
        }
        if (this.target == null) {
            latch.unlatch();
        } else {
            latch.unlatchTo(this.target);
        }
        this.unlatched = true;
    }

    public static class Builder {
        private final DatabaseManager databaseManager;
        private final I18nService i18nService;
        private DatabaseHandle target;

        public Builder(I18nService i18nService, DatabaseManager databaseManager) {
            this.i18nService = i18nService;
            this.databaseManager = databaseManager;
        }

        @Nonnull
        public UnlatchDatabaseStep build() {
            return new UnlatchDatabaseStep(this.target, this.i18nService, this.databaseManager);
        }

        @Nonnull
        public Builder target(@Nullable DatabaseHandle target) {
            this.target = target;
            return this;
        }
    }
}

