/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.concurrent.LatchableService;
import com.atlassian.stash.internal.maintenance.AbstractLatchAndDrainTask;
import com.atlassian.stash.internal.scm.InternalScmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class LatchAndDrainScmStep
extends AbstractLatchAndDrainTask {
    @Autowired
    public LatchAndDrainScmStep(I18nService i18nService, InternalScmService scmService, @Value(value="${backup.drain.scm.timeout}") int drainTimeout) {
        super(i18nService, (LatchableService<?>)scmService, drainTimeout);
    }

    @Override
    protected String getMessage() {
        return this.i18nService.getMessage("stash.backup.backup.scm.drain", new Object[0]);
    }

    @Override
    protected String getResourceName() {
        return "SCMs";
    }

    @Override
    protected ServiceException newDrainFailedException() {
        throw new BackupException(this.i18nService.createKeyedMessage("stash.backup.scm.drain.failed", new Object[0]));
    }
}

