/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.BaseMaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.DatabaseState;
import com.atlassian.stash.internal.maintenance.DefaultMaintenanceLock;
import com.atlassian.stash.internal.maintenance.DefaultMaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.LockedMaintenanceException;
import com.atlassian.stash.internal.maintenance.MaintenanceLock;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.MaintenanceStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.maintenance.ScmState;
import com.atlassian.stash.internal.maintenance.SimpleMaintenanceTaskStatus;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.request.RequestContext;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service(value="maintenanceService")
public class DefaultMaintenanceService
implements MaintenanceService,
DisposableBean {
    private static final Object LOCK_LOCK = new Object();
    private static final Object TASK_LOCK = new Object();
    private static final Logger log = LoggerFactory.getLogger(DefaultMaintenanceService.class);
    private final StashAuthenticationContext authenticationContext;
    private final DatabaseManager databaseManager;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RequestManager requestManager;
    private final InternalScmService scmService;
    private final MaintenanceStatus status;
    private final SecureTokenGenerator tokenGenerator;
    private volatile MaintenanceTaskStatus latestTask;
    private volatile DefaultMaintenanceLock lock;
    private volatile DefaultMaintenanceTaskMonitor runningTask;

    @Autowired
    public DefaultMaintenanceService(StashAuthenticationContext authenticationContext, EventPublisher eventPublisher, ExecutorService executorService, I18nService i18nService, RequestManager requestManager, SecureTokenGenerator tokenGenerator, DatabaseManager databaseManager, InternalScmService scmService) {
        this.authenticationContext = authenticationContext;
        this.databaseManager = databaseManager;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.requestManager = requestManager;
        this.scmService = scmService;
        this.tokenGenerator = tokenGenerator;
        this.status = new DefaultMaintenanceStatus();
    }

    public void destroy() throws Exception {
        DefaultMaintenanceTaskMonitor runningTask = this.runningTask;
        if (runningTask != null) {
            log.warn("Cancelling task {} in response to shutdown", (Object)runningTask.getId());
            if (!runningTask.cancel(runningTask.getCancelToken(), 10L, TimeUnit.SECONDS)) {
                log.warn("Timed out waiting for task {} to cancel in response to shutdown");
            }
        }
    }

    @Unsecured(value="The lock must be available while Johnson is preventing authentication")
    public DefaultMaintenanceLock getLock() {
        return this.lock;
    }

    @Unsecured(value="Retrieving the running task cannot be secured; the database may not be available")
    public MaintenanceTaskMonitor getRunningTask() {
        return this.runningTask;
    }

    @Nonnull
    @Unsecured(value="Retrieving the status cannot be secured; the database may not be available")
    public MaintenanceStatus getStatus() {
        return this.status;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MaintenanceLock lock() {
        Object object = LOCK_LOCK;
        synchronized (object) {
            if (this.lock == null) {
                StashUser user = this.authenticationContext.getCurrentUser();
                if (user == null) {
                    throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.maintenance.lock.anonymousnotallowed", new Object[0]));
                }
                String token = this.tokenGenerator.generateToken();
                DefaultMaintenanceLock lock = new DefaultMaintenanceLock(this.eventPublisher, this.i18nService, user, token);
                lock.addListener(new Runnable(){

                    @Override
                    public void run() {
                        DefaultMaintenanceService.this.lock = null;
                    }
                });
                lock.lock();
                log.info("The system has been locked for maintenance. It may be unlocked with token: {}", (Object)token);
                this.lock = lock;
                return this.lock;
            }
            log.warn("The system has already been locked for maintenance by {}", (Object)this.lock.getOwner().getDisplayName());
            throw new LockedMaintenanceException(this.i18nService.createKeyedMessage("stash.service.maintenance.lock.locked", new Object[0]), this.lock.getOwner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MaintenanceTaskMonitor start(@Nonnull MaintenanceTask task, @Nonnull MaintenanceType type) {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext == null) {
            throw new IllegalStateException("Maintenance can only be started in the context of a user request, as performing maintenance may lock out the system and a user must have the ability to restore the system to a non-maintenance state");
        }
        Object object = TASK_LOCK;
        synchronized (object) {
            DefaultMaintenanceTaskMonitor activeTask = this.runningTask;
            Preconditions.checkState((activeTask == null ? 1 : 0) != 0, (String)"{} maintenance cannot be started; {} maintenance is already in progress.", (Object[])new Object[]{type, activeTask == null ? null : activeTask.getType()});
            String cancelToken = this.tokenGenerator.generateToken();
            DefaultMaintenanceTaskMonitor runningTask = new DefaultMaintenanceTaskMonitor(task, cancelToken, type, requestContext.getSessionId(), cancelToken, this.i18nService);
            runningTask.registerCallback(new BaseMaintenanceCompletionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onCompletion() {
                    Object object = TASK_LOCK;
                    synchronized (object) {
                        DefaultMaintenanceService.this.latestTask = new SimpleMaintenanceTaskStatus((MaintenanceTaskStatus)DefaultMaintenanceService.this.runningTask);
                        DefaultMaintenanceService.this.runningTask = null;
                    }
                }
            });
            this.runningTask = runningTask;
            this.latestTask = this.runningTask;
            log.info("{} started. It may be canceled with token: {}", (Object)type, (Object)cancelToken);
            runningTask.submitTo(this.executorService);
            return runningTask;
        }
    }

    private class DefaultMaintenanceStatus
    implements MaintenanceStatus {
        private DefaultMaintenanceStatus() {
        }

        @Nonnull
        public DatabaseState getDatabaseState() {
            return DefaultMaintenanceService.this.databaseManager.getState();
        }

        public MaintenanceTaskStatus getLatestTask() {
            return DefaultMaintenanceService.this.latestTask;
        }

        @Nonnull
        public ScmState getScmState() {
            return DefaultMaintenanceService.this.scmService.getState();
        }
    }
}

