/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.concurrent.Latch;
import com.atlassian.stash.internal.concurrent.LatchableService;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLatchAndDrainTask
extends AbstractMaintenanceTask {
    protected final I18nService i18nService;
    private final long drainTimeoutSeconds;
    private final LatchableService<?> latchableService;
    private final Logger log;
    private volatile boolean drained;
    private volatile Thread drainingThread;

    public AbstractLatchAndDrainTask(I18nService i18nService, LatchableService<?> latchableService, long drainTimeoutSeconds) {
        this.drainTimeoutSeconds = drainTimeoutSeconds;
        this.i18nService = i18nService;
        this.latchableService = latchableService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void cancel() {
        super.cancel();
        Thread thread = this.drainingThread;
        if (!this.drained && thread != null && thread.getState() == Thread.State.TIMED_WAITING) {
            thread.interrupt();
        }
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.getMessage(), this.drained ? 100 : 0);
    }

    public void run() {
        this.log.debug("Latching {}", (Object)this.getResourceName());
        Latch latch = this.latchableService.acquireLatch();
        this.log.debug("Draining {}", (Object)this.getResourceName());
        this.drainingThread = Thread.currentThread();
        this.drained = latch.drain(this.drainTimeoutSeconds, TimeUnit.SECONDS);
        this.drainingThread = null;
        if (!this.drained) {
            if (this.isCanceled()) {
                Thread.interrupted();
            }
            this.log.warn("The {} could not be drained. Aborting...", (Object)this.getResourceName());
            throw this.newDrainFailedException();
        }
        this.log.debug("Successfully drained the {}", (Object)this.getResourceName());
    }

    protected abstract String getMessage();

    protected abstract String getResourceName();

    protected abstract ServiceException newDrainFailedException();
}

