/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.InvalidLicenseException;
import com.atlassian.stash.exception.LicenseLimitException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.license.LicensedUserCountCache;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import java.security.Principal;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=LicenseService.class)
@Service(value="licenseService")
@Transactional(propagation=Propagation.SUPPORTS)
public class LicenseServiceImpl
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private final I18nService i18nService;
    private final LicenseDecoder licenseDecoder;
    private final LicensedUserCountCache licensedUserCountCache;
    private final LicenseManager licenseManager;
    private final CachedReference<Maybe<StashLicense>> licenseReference;
    private final InternalPermissionService permissionService;
    private final InternalApplicationPropertiesService propertiesService;
    private final UserService userService;

    @Autowired
    public LicenseServiceImpl(LicenseManager licenseManager, LicenseDecoder licenseDecoder, InternalPermissionService permissionService, InternalApplicationPropertiesService propertiesService, I18nService i18nService, LicensedUserCountCache licensedUserCountCache, UserService userService, CacheFactory cacheFactory) {
        this.i18nService = i18nService;
        this.licenseDecoder = licenseDecoder;
        this.licenseManager = licenseManager;
        this.permissionService = permissionService;
        this.propertiesService = propertiesService;
        this.licensedUserCountCache = licensedUserCountCache;
        this.userService = userService;
        this.licenseReference = cacheFactory.getCachedReference(LicenseService.class, "StashLicense", (Supplier)new Supplier<Maybe<StashLicense>>(){

            public Maybe<StashLicense> get() {
                return LicenseServiceImpl.this.loadLicense();
            }
        }, new CacheSettingsBuilder().replicateViaInvalidation().build());
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean isPresent() {
        return this.get() != null;
    }

    @Unsecured(value="everyone needs access to this method")
    public StashLicense get() {
        return (StashLicense)((Maybe)this.licenseReference.get()).getOrNull();
    }

    @Unsecured(value="Access to the encrypted license is required by UPM")
    public String getAsString() {
        return this.propertiesService.getLicense();
    }

    @Unsecured(value="everyone needs access to this method")
    public int getLicensedUsersCount() {
        return this.licensedUserCountCache.getCount();
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean canLogin(Principal principal) {
        if (principal instanceof StashUserAuthenticationToken) {
            principal = ((StashUserAuthenticationToken)principal).getPrincipal();
        }
        if (!(principal instanceof StashUser)) {
            return false;
        }
        StashUser user = (StashUser)principal;
        return user.getType() == UserType.SERVICE || user.isActive() && this.isUserLicensed(user);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanLicenseUser(StashUser user, Permission permission) throws LicenseLimitException {
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        StashLicense license = this.get();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.isUserLicensed(user)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        int licenseCount = this.permissionService.getUsersWithPermission(Permission.LICENSED_USER).size();
        if (licenseCount < licenseLimit) {
            return;
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.license.userlimit", new Object[]{user.getDisplayName(), licenseLimit});
        throw new LicenseLimitException(message);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanLicenseGroup(String group, Permission permission) throws LicenseLimitException {
        Page users;
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        StashLicense license = this.get();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        HashSet<String> licensedUsers = new HashSet<String>();
        licensedUsers.addAll(this.permissionService.getUsersWithPermission(Permission.LICENSED_USER));
        PageRequestImpl request = new PageRequestImpl(0, 1000);
        do {
            users = this.userService.findUsersByGroup(group, (PageRequest)request);
            for (StashUser user : users.getValues()) {
                licensedUsers.add(IdentifierUtils.toLowerCase((String)user.getName()));
                if (licensedUsers.size() <= licenseLimit) continue;
                KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.license.grouplimit", new Object[]{group, licenseLimit});
                throw new LicenseLimitException(message);
            }
        } while ((request = users.getNextPageRequest()) != null);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanAddUserToGroup(String name, String group) {
        if (!this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        StashUser user = this.userService.getUserByName(name);
        if (user != null) {
            this.validateCanLicenseUser(user, Permission.LICENSED_USER);
        }
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getValidityMessage() {
        return this.getLicenseValidityMessage(this.get());
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getOverLimitMessage() {
        StashLicense license = this.get();
        if (license != null && !license.isUnlimitedNumberOfUsers()) {
            int licenseLimit = license.getMaximumNumberOfUsers();
            int licenseCount = this.getLicensedUsersCount();
            if (licenseCount > licenseLimit) {
                return this.i18nService.createKeyedMessage("stash.license.over.limit", new Object[0]);
            }
        }
        return null;
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getStatus() {
        KeyedMessage message = this.getValidityMessage();
        if (message == null) {
            message = this.getOverLimitMessage();
        }
        return message;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void update(String encoded) {
        if (StringUtils.isEmpty((String)encoded)) {
            throw new InvalidLicenseException(this.i18nService.createKeyedMessage("stash.license.empty", new Object[0]));
        }
        StashLicense stashLicense = this.decodeLicense(encoded);
        KeyedMessage validityMessage = this.getLicenseValidityMessage(stashLicense);
        if (validityMessage != null) {
            throw new InvalidLicenseException(validityMessage);
        }
        this.propertiesService.setLicense(encoded);
        SpringTransactionUtils.invokeAfterCommit((Runnable)new Runnable(){

            @Override
            public void run() {
                LicenseServiceImpl.this.licenseReference.reset();
            }
        });
    }

    private StashLicense decodeLicense(String license) throws InvalidLicenseException {
        if (this.licenseDecoder.canDecode(license)) {
            AtlassianLicense atlassianLicense;
            try {
                atlassianLicense = this.licenseManager.getLicense(license);
            }
            catch (Exception e) {
                log.warn("Error decoding license", (Throwable)e);
                throw new InvalidLicenseException(this.i18nService.createKeyedMessage("stash.license.invalid", new Object[0]));
            }
            StashLicense stashLicense = (StashLicense)atlassianLicense.getProductLicense(Product.STASH);
            if (stashLicense == null) {
                throw new InvalidLicenseException(this.i18nService.createKeyedMessage("stash.license.not.included", new Object[]{ApplicationConstants.PRODUCT_NAME}));
            }
            return stashLicense;
        }
        throw new InvalidLicenseException(this.i18nService.createKeyedMessage("stash.license.invalid", new Object[0]));
    }

    private KeyedMessage getLicenseValidityMessage(StashLicense license) {
        if (license == null) {
            return this.i18nService.createKeyedMessage("stash.license.no.license", new Object[0]);
        }
        if (license.isExpired()) {
            if (license.isEvaluation()) {
                return this.i18nService.createKeyedMessage("stash.license.evaluation.expired", new Object[0]);
            }
            return this.i18nService.createKeyedMessage("stash.license.expired", new Object[0]);
        }
        if (license.getMaintenanceExpiryDate() != null && this.propertiesService.getBuildTimestamp() != null && this.propertiesService.getBuildTimestamp().after(license.getMaintenanceExpiryDate())) {
            return this.i18nService.createKeyedMessage("stash.license.unsupported.upgrade", new Object[]{ApplicationConstants.PRODUCT_NAME});
        }
        return null;
    }

    private boolean isUserLicensed(StashUser user) {
        return this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
    }

    private Maybe<StashLicense> loadLicense() {
        String encoded = this.getAsString();
        if (encoded == null) {
            log.warn("No license has been configured.");
            return Option.none();
        }
        try {
            return Option.some((Object)this.decodeLicense(encoded));
        }
        catch (Exception e) {
            log.warn("Failed to decode the configured license.", (Throwable)e);
            return Option.none();
        }
    }
}

