/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.exception.NoSuchResourceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.atlassian.stash.repository.AbstractRefCallback;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefCallback;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.utils.process.IOUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service(value="repositorySnapshotService")
@DependsOn(value={"moveSnapshotDirUpgradeTask"})
public class RepositorySnapshotServiceImpl
implements RepositorySnapshotService {
    public static final String SNAPSHOTS_PATH = "snapshots";
    private static Function<Long, String> TIMESTAMP_TO_STRING = new Function<Long, String>(){

        public String apply(Long input) {
            return Long.toString(input);
        }
    };
    private final I18nService i18nService;
    private final ScmService scmService;
    private final File snapshotDir;

    @Autowired
    public RepositorySnapshotServiceImpl(ApplicationSettings settings, I18nService i18nService, ScmService scmService) {
        this.scmService = scmService;
        this.i18nService = i18nService;
        this.snapshotDir = com.atlassian.stash.util.FileUtils.mkdir((File)settings.getDataDir(), (String)SNAPSHOTS_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> create(@Nonnull Repository repository, @Nonnull Long timestamp) {
        try {
            final FileWriter writer = new FileWriter(this.getSnapshotFile(repository, timestamp));
            final HashSet heads = Sets.newHashSet();
            try {
                ScmCommandFactory commandFactory = this.scmService.getCommandFactory(repository);
                commandFactory.heads((RefCallback)new AbstractRefCallback(){

                    public boolean onRef(@Nonnull Ref ref) throws IOException {
                        writer.write(ref.getLatestChangeset() + "\n");
                        heads.add(ref.getLatestChangeset());
                        return true;
                    }
                }).call();
            }
            finally {
                IOUtils.closeQuietly((Closeable)writer);
            }
            return heads;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open snapshot file for writing", e);
        }
    }

    @Override
    public void deleteByRepository(@Nonnull Repository repository) {
        try {
            FileUtils.deleteDirectory((File)this.getRepositorySnapshotDir(repository));
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting the snapshot files for repository " + repository.getName(), e);
        }
    }

    @Override
    @Nonnull
    public Iterable<String> getByRepository(@Nonnull Repository repository, Long timestamp) {
        if (timestamp != null) {
            File snapshotFile = this.getSnapshotFile(repository, timestamp);
            if (!snapshotFile.exists()) {
                throw new NoSuchResourceException(this.i18nService.createKeyedMessage("stash.service.repositorysnapshot.snapshotfilenotfound", new Object[0]), snapshotFile.getName());
            }
            return new RepositorySnapshotIterable(this.getSnapshotFile(repository, timestamp));
        }
        return Collections.emptySet();
    }

    @EventListener
    public void onDeleteRepository(RepositoryDeletedEvent event) {
        this.deleteByRepository(event.getRepository());
    }

    @Override
    public void pruneByRepository(@Nonnull Repository repository, @Nonnull Set<Long> timestampsToKeep) {
        ImmutableSet snapshotFilesToKeep = ImmutableSet.copyOf((Collection)Collections2.transform(timestampsToKeep, TIMESTAMP_TO_STRING));
        File snapshotDir = this.getRepositorySnapshotDir(repository);
        File[] files = snapshotDir.listFiles();
        if (files != null && files.length > 0) {
            for (File snapshotFile : files) {
                if (snapshotFilesToKeep.contains(snapshotFile.getName()) || snapshotFile.delete()) continue;
                snapshotFile.deleteOnExit();
            }
        }
    }

    private File getRepositorySnapshotDir(Repository repository) {
        return com.atlassian.stash.util.FileUtils.mkdir((File)this.snapshotDir, (String)String.valueOf(repository.getId()));
    }

    private File getSnapshotFile(Repository repository, Long timestamp) {
        File repositorySnapshotDir = this.getRepositorySnapshotDir(repository);
        return new File(repositorySnapshotDir, String.valueOf(timestamp));
    }

    private static class RepositorySnapshotIterable
    implements Iterable<String> {
        private final File file;

        public RepositorySnapshotIterable(File file) {
            this.file = file;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private static final int PAGE_SIZE = 100;
                private final Deque<String> nextValues = new LinkedList<String>();
                private int offset = 0;

                @Override
                public boolean hasNext() {
                    if (this.nextValues.isEmpty() && this.offset >= 0) {
                        this.readPage();
                    }
                    return !this.nextValues.isEmpty();
                }

                private void readPage() {
                    BufferedReader reader = null;
                    try {
                        int lineNumber;
                        reader = new BufferedReader(new FileReader(RepositorySnapshotIterable.this.file));
                        for (lineNumber = 0; lineNumber < this.offset; ++lineNumber) {
                            reader.readLine();
                        }
                        String line = null;
                        int lastLine = this.offset + 100;
                        while (lineNumber < lastLine && (line = reader.readLine()) != null) {
                            this.nextValues.addLast(line);
                            ++lineNumber;
                        }
                        this.offset = line != null ? lastLine : -1;
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(reader);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)reader);
                }

                @Override
                public String next() {
                    if (this.hasNext()) {
                        return this.nextValues.poll();
                    }
                    throw new NoSuchElementException("No more entries are available");
                }

                @Override
                public void remove() {
                    throw new NotImplementedException();
                }
            };
        }
    }
}

