/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.fugue.Effect;
import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.db.DatabaseValidationException;
import com.atlassian.stash.internal.db.DatabaseValidator;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.db.DefaultDatabaseHandle;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.MutableDataSourceConfiguration;
import com.atlassian.stash.internal.hibernate.SwappableDataSource;
import com.atlassian.stash.internal.hibernate.SwappableSessionFactory;
import com.atlassian.stash.internal.maintenance.DatabaseState;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.internal.migration.MigrationValidationException;
import com.atlassian.stash.internal.util.TransactionAwareLatchedInvocationHandler;
import com.atlassian.stash.util.Drainable;
import com.atlassian.stash.util.ProxyUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.InfrastructureProxy;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.AbstractDriverBasedDataSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component(value="databaseManager")
public class DefaultDatabaseManager
implements DatabaseManager,
Ordered {
    public static final String PROTOTYPE_DATA_SOURCE = "dataSourcePrototype";
    public static final String PROTOTYPE_SESSION_FACTORY = "sessionFactoryPrototype";
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseManager.class);
    private final MutableDataSourceConfiguration dataSourceConfiguration;
    private final Object lock;
    private final SwappableDataSource swappableDataSource;
    private final SwappableSessionFactory swappableSessionFactory;
    private final ApplicationContext applicationContext;
    private final I18nService i18nService;
    private final LiquibaseDao liquibaseDao;
    private final DatabaseValidator databaseValidator;
    private Duration connectTimeout;
    private DataSource realDataSource;
    private SessionFactoryImplementor realSessionFactory;
    private DataSourceConfiguration realDataSourceConfiguration;
    private volatile DelegatingDatabaseLatch latch;

    @Autowired
    public DefaultDatabaseManager(ApplicationContext applicationContext, DatabaseValidator databaseValidator, MutableDataSourceConfiguration dataSourceConfiguration, I18nService i18nService, LiquibaseDao liquibaseDao, SwappableDataSource swappableDataSource, SwappableSessionFactory swappableSessionFactory) {
        this.applicationContext = applicationContext;
        this.databaseValidator = databaseValidator;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.i18nService = i18nService;
        this.liquibaseDao = liquibaseDao;
        this.swappableDataSource = swappableDataSource;
        this.swappableSessionFactory = swappableSessionFactory;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public DatabaseLatch acquireLatch() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isLatched()) {
                throw new IllegalStateException("The database has already been latched");
            }
            this.latch = new DelegatingDatabaseLatch(new CountDownLatch(1));
            this.realDataSourceConfiguration = this.dataSourceConfiguration.copy();
            this.realDataSource = this.swappableDataSource.swap((DataSource)ProxyUtils.createProxy(DataSource.class, (InvocationHandler)this.createLatchingInvocationHandler((InfrastructureProxy)this.swappableDataSource, this.latch.latch), (Class[])new Class[]{InfrastructureProxy.class}));
            this.realSessionFactory = this.swappableSessionFactory.swap((SessionFactoryImplementor)ProxyUtils.createProxy(SessionFactoryImplementor.class, (InvocationHandler)this.createLatchingInvocationHandler((InfrastructureProxy)this.swappableSessionFactory, this.latch.latch), (Class[])new Class[]{InfrastructureProxy.class}));
            return this.latch;
        }
    }

    @Nullable
    public DatabaseLatch getCurrentLatch() {
        return this.latch;
    }

    @Nonnull
    public DatabaseHandle getHandle() {
        return new DefaultDatabaseHandle(this.dataSourceConfiguration.copy(), (DataSource)this.swappableDataSource.getWrappedObject(), (SessionFactoryImplementor)this.swappableSessionFactory.getWrappedObject());
    }

    public int getOrder() {
        return 0;
    }

    @Nonnull
    public DatabaseState getState() {
        DatabaseLatch dbLatch = this.getCurrentLatch();
        if (dbLatch == null) {
            return DatabaseState.AVAILABLE;
        }
        if (dbLatch.drain(0L, TimeUnit.NANOSECONDS)) {
            return DatabaseState.DRAINED;
        }
        return DatabaseState.LATCHED;
    }

    public boolean isLatched() {
        return this.latch != null;
    }

    @Nonnull
    public DatabaseHandle prepareDatabase(@Nonnull DataSourceConfiguration targetConfiguration) {
        log.debug("Validating the configuration of the DataSource for the new database");
        this.validateConfiguration(targetConfiguration);
        log.debug("Creating a DataSource connected to the target database");
        DataSource newDataSource = this.createDataSource(targetConfiguration);
        log.debug("Creating the {} schema in the target database", (Object)Product.NAME);
        this.createSchema(newDataSource);
        log.debug("Creating Hibernate SessionFactory on the target database and validating the schema");
        SessionFactoryImplementor newSessionFactory = this.createSessionFactory(newDataSource);
        log.debug("The new database has been prepared.");
        return new DefaultDatabaseHandle(targetConfiguration, newDataSource, newSessionFactory);
    }

    public void validateConfiguration(@Nonnull DataSourceConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        log.debug("Creating a DataSource to test the provided configuration");
        final SingleConnectionDataSource dataSource = new SingleConnectionDataSource();
        dataSource.setDriverClassName(configuration.getDriverClassName());
        dataSource.setPassword(configuration.getPassword());
        dataSource.setUrl(configuration.getUrl());
        dataSource.setUsername(configuration.getUser());
        try {
            DbType.forDriver((String)configuration.getDriverClassName()).foreach((Effect)new Effect<DbType>(){

                public void apply(DbType dbType) {
                    dbType.applyTimeout((AbstractDriverBasedDataSource)dataSource, DefaultDatabaseManager.this.connectTimeout);
                }
            });
            log.debug("Validating connection and target database for: {}", (Object)configuration.getUrl());
            this.databaseValidator.validate((DataSource)dataSource);
        }
        catch (CannotGetJdbcConnectionException e) {
            log.warn("A connection could not be opened with the DataSource", (Throwable)e);
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.test.connectfailed", new Object[0]), (Throwable)e);
        }
        catch (DataRetrievalFailureException e) {
            log.warn("Support for the target database could not be verified", (Throwable)e);
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.test.supportunverified", new Object[]{Product.NAME}), (Throwable)e);
        }
        catch (DataAccessException e) {
            log.warn("An unexpected exception prevented validating the target database", (Throwable)e);
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.test.unexpectedfailure", new Object[]{Product.NAME}), (Throwable)e);
        }
        catch (DatabaseValidationException e) {
            throw new MigrationValidationException(e.getKeyedMessage());
        }
        finally {
            log.debug("Destroying the test DataSource");
            dataSource.destroy();
        }
    }

    void closeDataSource(@Nonnull DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        log.debug("Closing DataSource to release database connections");
        if (dataSource instanceof Closeable) {
            Closeables.closeQuietly((Closeable)((Closeable)((Object)dataSource)));
        } else {
            Class<?> dataSourceClass = dataSource.getClass();
            log.debug("DataSource class [{}] does not implement Closeable", dataSourceClass);
            Method close = ReflectionUtils.findMethod(dataSourceClass, (String)"close");
            if (close == null) {
                log.warn("DataSource class [{}] does not have a close() method and will not be closed.", dataSourceClass);
            } else {
                log.debug("Invoking {}.{}() to close the DataSource", close.getDeclaringClass(), (Object)close.getName());
                try {
                    ReflectionUtils.invokeMethod((Method)close, (Object)dataSource);
                }
                catch (Throwable t) {
                    log.warn(dataSourceClass + "." + close.getName() + "() did not run cleanly. " + "The DataSource may not have been closed", t);
                }
            }
        }
    }

    @Nonnull
    DataSource createDataSource(@Nonnull DataSourceConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        try {
            return (DataSource)this.applicationContext.getBean(PROTOTYPE_DATA_SOURCE, new Object[]{configuration});
        }
        catch (Throwable t) {
            log.error("Failed to obtain data source", t);
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.create.datasource.failed", new Object[0]), Throwables.getRootCause((Throwable)t));
        }
    }

    void createSchema(@Nonnull DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        try {
            this.liquibaseDao.createSchema(dataSource);
        }
        catch (Throwable t) {
            log.error("Failed to create schema in target database.", t);
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.create.schema.failed", new Object[0]), t);
        }
    }

    @Nonnull
    SessionFactoryImplementor createSessionFactory(@Nonnull DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        try {
            return (SessionFactoryImplementor)this.applicationContext.getBean(PROTOTYPE_SESSION_FACTORY, new Object[]{dataSource});
        }
        catch (Throwable t) {
            log.error("Failed to obtain session factory", t);
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.create.sessionfactory.failed", new Object[0]), Throwables.getRootCause((Throwable)t));
        }
    }

    @Value(value="${migration.test.connect.timeout}")
    void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = Duration.standardSeconds((long)connectTimeout);
    }

    private InvocationHandler createLatchingInvocationHandler(InfrastructureProxy swappable, CountDownLatch countDownLatch) {
        return new TransactionAwareLatchedInvocationHandler(swappable, countDownLatch, swappable.getWrappedObject());
    }

    private class DelegatingDatabaseLatch
    implements DatabaseLatch {
        private final CountDownLatch latch;
        private volatile boolean drained;

        public DelegatingDatabaseLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean drain(long timeout, @Nonnull TimeUnit unit) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be non-negative");
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
            this.ensureInitiator();
            if (this.drained) {
                return true;
            }
            if (DefaultDatabaseManager.this.realDataSource instanceof Drainable) {
                Drainable drainable = (Drainable)DefaultDatabaseManager.this.realDataSource;
                if (!drainable.drain(timeout, unit)) {
                    log.debug("The DataSource could not be drained; some database connections are still open.");
                    return false;
                }
                log.debug("The DataSource has been drained");
            } else {
                log.warn("The DataSource for the current database does not implement Drainable. Existing connections will not be closed.");
            }
            this.drained = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlatch() {
            this.ensureInitiator();
            Object object = DefaultDatabaseManager.this.lock;
            synchronized (object) {
                DefaultDatabaseManager.this.dataSourceConfiguration.update(DefaultDatabaseManager.this.realDataSourceConfiguration);
                DefaultDatabaseManager.this.swappableDataSource.swap(DefaultDatabaseManager.this.realDataSource);
                DefaultDatabaseManager.this.swappableSessionFactory.swap(DefaultDatabaseManager.this.realSessionFactory);
                DefaultDatabaseManager.this.latch = null;
            }
            this.latch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlatchTo(@Nonnull DatabaseHandle databaseHandle) {
            this.ensureInitiator();
            Object object = DefaultDatabaseManager.this.lock;
            synchronized (object) {
                DefaultDatabaseManager.this.realDataSource = (DataSource)Preconditions.checkNotNull((Object)databaseHandle.getDataSource(), (Object)"newDataSource");
                DefaultDatabaseManager.this.realDataSourceConfiguration = (DataSourceConfiguration)Preconditions.checkNotNull((Object)databaseHandle.getConfiguration(), (Object)"newConfiguration");
                DefaultDatabaseManager.this.realSessionFactory = (SessionFactoryImplementor)Preconditions.checkNotNull((Object)databaseHandle.getSessionFactory(), (Object)"newSessionFactory");
                this.unlatch();
            }
        }

        private void ensureInitiator() {
            if (DefaultDatabaseManager.this.latch != this) {
                throw new IllegalStateException("This latch is no longer active");
            }
        }
    }
}

