/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.commit.graph.cache.TimedContentProvider;
import com.atlassian.stash.internal.commit.graph.cache.TraversalScmContentProvider;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.util.contentcache.ContentProvider;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class CachedCommitGraphUtils {
    private static final int CSID_LENGTH = 40;

    public static byte[] getCommitIdAsByteArray(String csid) {
        if (csid.length() != 40) {
            throw new IllegalArgumentException("Invalid csid: " + csid);
        }
        try {
            return Hex.decodeHex((char[])csid.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getByteArrayAsCommitId(byte[] csid) {
        if (csid.length != 20) {
            throw new IllegalArgumentException("Invalid csid (length is " + csid.length + ')');
        }
        return new String(Hex.encodeHex((byte[])csid));
    }

    public static byte[] getCountAsByteArray(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        if (count == 0) {
            return new byte[1];
        }
        int length = CachedCommitGraphUtils.arrayCountSize(count);
        byte[] buffer = new byte[length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)(count & 0x7F);
            if ((count >>>= 7) <= 0) continue;
            int n = i;
            buffer[n] = (byte)(buffer[n] | 0x80);
        }
        return buffer;
    }

    public static int getByteArrayAsCount(byte[] count) {
        return CachedCommitGraphUtils.getByteArrayAsCount(count, 0, count.length);
    }

    public static int getByteArrayAsCount(byte[] count, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException("Count must be a non-zero length array");
        }
        int r = 0;
        for (int i = offset; i < length; ++i) {
            r += (count[i] & 0x7F) << i * 7;
        }
        return r;
    }

    public static String getCacheKey(Repository repository) {
        return Integer.toString(repository.getId());
    }

    public static ContentProvider getTimedScmContentProvider(Repository repository, ScmService scmService, I18nService i18nService) {
        return new TimedContentProvider(repository.toString() + ": TraversalScmContentProvider", new TraversalScmContentProvider(scmService, repository, i18nService));
    }

    public static boolean isLastByteInCountArray(int b) {
        return (b & 0x80) != 128;
    }

    private static int arrayCountSize(int count) {
        int highestBit = 32 - Integer.numberOfLeadingZeros(count);
        int required = highestBit / 7;
        return highestBit % 7 == 0 ? required : required + 1;
    }
}

