/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.commit.graph.CommitGraphContext;
import com.atlassian.stash.commit.graph.CommitGraphNode;
import com.atlassian.stash.commit.graph.SubgraphTraversalCallback;
import com.atlassian.stash.commit.graph.TraversalCallback;
import com.atlassian.stash.commit.graph.TraversalContext;
import com.atlassian.stash.commit.graph.TraversalRequest;
import com.atlassian.stash.commit.graph.TraversalStatus;
import com.atlassian.stash.commit.graph.TraversalSummary;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.commit.graph.CommitGraphSource;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphOutputStream;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphUtils;
import com.atlassian.stash.internal.commit.graph.cache.SetPriorityBlockingQueue;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.RefChangeType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.concurrent.ExecutorUtils;
import com.atlassian.util.concurrent.ThreadFactories;
import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.CacheResult;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.BackgroundThreadStreamPumper;
import com.atlassian.util.contentcache.internal.FileContentCache;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="commitGraphSource")
public class CachedCommitGraphSource
implements CommitGraphSource {
    private static final Logger log = LoggerFactory.getLogger(CachedCommitGraphSource.class);
    private static final String CACHE_PATH = "commit-graph";
    private static final String CACHE_KEY = "commit-graph";
    private static final String PUMPER_KEY = "commit-graph-pumper";
    private static final String REQUIRED_FREE_SPACE_KEY = "${commit.graph.cache.min.free.space}";
    private static final int CORE_POOL_SIZE = 0;
    private static final long IDLE_THREAD_KEEP_ALIVE_TIME = 5L;
    private static final TimeUnit IDLE_THREAD_KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final String MAXIMUM_THREAD_POOL_SIZE_KEY = "${commit.graph.cache.max.threads}";
    private static final String MAXIMUM_THREAD_POOL_QUEUE_SIZE_KEY = "${commit.graph.cache.max.job.queue}";
    private static final String TRAVERSE_WAIT_TIME__KEY = "${commit.graph.cache.traverse.timeout}";
    private static final int MAX_RETRIES = 5;
    private static final String THREAD_FACTORY_NAME = CachedCommitGraphSource.class.getSimpleName();
    private final ContentCache contentCache;
    private final ScmService scmService;
    private final I18nService i18nService;
    private final ExecutorService executorService;
    private final long maxTraverseWaitTime;
    private volatile boolean shutdown;

    @Autowired
    public CachedCommitGraphSource(ApplicationSettings applicationSettings, ScmService scmService, I18nService i18nService, @Value(value="${commit.graph.cache.min.free.space}") long requiredFreeSpace, @Value(value="${commit.graph.cache.max.threads}") int maximumPoolSize, @Value(value="${commit.graph.cache.max.job.queue}") int maximumPoolQueueSize, @Value(value="${commit.graph.cache.traverse.timeout}") long maxTraverseWaitTime) {
        this((ContentCache)new FileContentCache((StreamPumper)new BackgroundThreadStreamPumper(PUMPER_KEY), "commit-graph", new File(applicationSettings.getCacheDir(), "commit-graph"), requiredFreeSpace), scmService, i18nService, maximumPoolSize, maximumPoolQueueSize, maxTraverseWaitTime);
    }

    protected CachedCommitGraphSource(ContentCache contentCache, ScmService scmService, I18nService i18nService, int maximumPoolSize, int maximumPoolQueueSize, long maxTraverseWaitTime) {
        this.contentCache = contentCache;
        this.scmService = scmService;
        this.maxTraverseWaitTime = maxTraverseWaitTime;
        this.i18nService = i18nService;
        SetPriorityBlockingQueue<Runnable> jobQueue = new SetPriorityBlockingQueue<Runnable>(maximumPoolQueueSize, new CacheTraversalJobComparator());
        this.executorService = new ThreadPoolExecutor(0, maximumPoolSize, 5L, IDLE_THREAD_KEEP_ALIVE_TIME_UNIT, jobQueue, ThreadFactories.namedThreadFactory((String)THREAD_FACTORY_NAME));
        this.shutdown = false;
    }

    @PreDestroy
    public void destroy() {
        this.shutdown = true;
        this.contentCache.clear();
        ExecutorUtils.shutdown((ExecutorService)this.executorService, (Logger)log);
    }

    @EventListener
    public void onRepositoryRefChanges(RepositoryRefsChangedEvent event) throws Exception {
        if (this.shutdown) {
            return;
        }
        Repository repository = event.getRepository();
        boolean hasRefChanges = !event.getRefChanges().isEmpty();
        boolean onlyDeletions = Iterables.all((Iterable)event.getRefChanges(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)RefChangeType.DELETE), (Function)RefChange.TO_TYPE));
        boolean isFork = repository.isFork();
        log.debug("Checking RepositoryRefsChangedEvent for ref changes on [{0}]; has changes: {1}, is fork: {2}, only deletions {3}", new Object[]{repository, hasRefChanges, isFork, onlyDeletions});
        if (hasRefChanges && !onlyDeletions) {
            if (isFork) {
                this.contentCache.remove(CachedCommitGraphUtils.getCacheKey(repository));
            } else {
                this.executeCacheRebuild(repository);
            }
        }
    }

    @Override
    public void traverse(@Nonnull TraversalRequest request, @Nonnull TraversalCallback callback) {
        block23: {
            Preconditions.checkNotNull((Object)request, (Object)"request");
            Preconditions.checkNotNull((Object)callback, (Object)"callback");
            if (this.shutdown) {
                return;
            }
            Repository repository = request.getRepository();
            CommitGraphContext commitGraphContext = new CommitGraphContext.Builder().exclude((Iterable)request.getExcludes()).include((Iterable)request.getIncludes()).build();
            DelegatingCompletionWaitingTraversalCallback futureCallback = new DelegatingCompletionWaitingTraversalCallback((TraversalCallback)new SubgraphTraversalCallback(callback, commitGraphContext));
            CachedCommitGraphOutputStream cachedCommitGraphOutputStream = new CachedCommitGraphOutputStream(futureCallback);
            String cacheKey = CachedCommitGraphUtils.getCacheKey(repository);
            ContentProvider contentProvider = CachedCommitGraphUtils.getTimedScmContentProvider(repository, this.scmService, this.i18nService);
            try (Timer timer = TimerUtils.start((String)(repository.getId() + ": reading traversal index"));){
                CacheAccess cacheAccess = this.contentCache.access(cacheKey, (OutputStream)cachedCommitGraphOutputStream, contentProvider);
                CacheResult cacheResult = cacheAccess.getResult();
                if (cacheResult == CacheResult.MISS) {
                    log.debug("{} during traversal for {}, delegating job to executorService", (Object)cacheResult, (Object)repository);
                    SingleCacheTraversalJob job = new SingleCacheTraversalJob(repository, cachedCommitGraphOutputStream, cacheAccess);
                    this.executorService.execute(job);
                    try {
                        futureCallback.await(this.maxTraverseWaitTime, TimeUnit.SECONDS);
                        break block23;
                    }
                    catch (InterruptedException e) {
                        throw new ServerException(this.i18nService.createKeyedMessage("stash.commit.graph.traversal.read.interruptedexception", new Object[]{repository}), (Throwable)e);
                    }
                }
                log.debug("{} during traversal for {}", (Object)cacheResult, (Object)repository);
                try {
                    cacheAccess.stream();
                }
                catch (CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException e) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                throw new ServerException(this.i18nService.createKeyedMessage("stash.commit.graph.traversal.read.ioexception", new Object[]{repository}), (Throwable)e);
            }
            finally {
                Closeables.closeQuietly((Closeable)cachedCommitGraphOutputStream);
            }
        }
    }

    private void executeCacheRebuild(Repository repository) {
        RetryingCacheTraversalJob cacheTraversalJob = new RetryingCacheTraversalJob(repository, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        this.executorService.execute(cacheTraversalJob);
    }

    class SingleCacheTraversalJob
    extends CacheTraversalJob {
        private static final int PRIORITY = 2;
        private final CacheAccess cacheAccess;

        public SingleCacheTraversalJob(Repository repository, OutputStream outputStream, CacheAccess cacheAccess) {
            super(2, repository, outputStream);
            this.cacheAccess = cacheAccess;
        }

        @Override
        public void run() {
            try {
                this.cacheAccess.stream();
            }
            catch (CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException e) {
            }
            catch (IOException e) {
                CachedCommitGraphSource.this.executeCacheRebuild(this.repository);
                throw new ServerException(CachedCommitGraphSource.this.i18nService.createKeyedMessage("stash.commit.graph.traversal.read.ioexception", new Object[]{this.repository}), (Throwable)e);
            }
        }
    }

    class RetryingCacheTraversalJob
    extends CacheTraversalJob {
        private static final int PRIORITY = 1;
        private final OutputStream outputStream;
        private final int maxRetries;
        private int retries;

        public RetryingCacheTraversalJob(Repository repository, OutputStream outputStream) {
            super(1, repository, outputStream);
            this.outputStream = outputStream;
            this.maxRetries = 5;
            this.retries = 0;
        }

        @Override
        public void run() {
            try {
                this.streamCache();
            }
            catch (Exception e) {
                if (this.retries < this.maxRetries) {
                    ++this.retries;
                    CachedCommitGraphSource.this.executorService.execute(this);
                }
                log.warn("Failed to stream commit graph on {} after {} retries", new Object[]{this.repository.toString(), this.maxRetries, e});
            }
        }

        private void streamCache() throws IOException {
            String cacheKey = CachedCommitGraphUtils.getCacheKey(this.repository);
            ContentProvider contentProvider = CachedCommitGraphUtils.getTimedScmContentProvider(this.repository, CachedCommitGraphSource.this.scmService, CachedCommitGraphSource.this.i18nService);
            CachedCommitGraphSource.this.contentCache.remove(CachedCommitGraphUtils.getCacheKey(this.repository));
            CacheAccess cacheAccess = CachedCommitGraphSource.this.contentCache.access(cacheKey, this.outputStream, contentProvider);
            if (cacheAccess.getResult() == CacheResult.MISS) {
                cacheAccess.stream();
            } else {
                cacheAccess.cancel();
            }
        }
    }

    class DelegatingCompletionWaitingTraversalCallback
    extends TraversalCallback {
        private final TraversalCallback delegate;
        private final CountDownLatch countDownLatch;
        private volatile boolean finished;

        public DelegatingCompletionWaitingTraversalCallback(TraversalCallback delegate) {
            this.delegate = delegate;
            this.countDownLatch = new CountDownLatch(1);
            this.finished = false;
        }

        public void await() throws InterruptedException {
            this.countDownLatch.await();
        }

        public void await(long timeout, TimeUnit unit) throws InterruptedException {
            this.countDownLatch.await(timeout, unit);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void onEnd(@Nonnull TraversalSummary summary) {
            this.delegate.onEnd(summary);
            this.finished = true;
            this.countDownLatch.countDown();
        }

        public TraversalStatus onNode(@Nonnull CommitGraphNode node) {
            return this.delegate.onNode(node);
        }

        public void onStart(@Nonnull TraversalContext context) {
            this.delegate.onStart(context);
        }
    }

    static class CacheTraversalJobComparator
    implements Comparator<Runnable> {
        CacheTraversalJobComparator() {
        }

        @Override
        public int compare(Runnable o1, Runnable o2) {
            boolean o1IsCacheTraversalJob = o1 instanceof CacheTraversalJob;
            boolean o2IsCacheTraversalJob = o2 instanceof CacheTraversalJob;
            if (o1IsCacheTraversalJob && o2IsCacheTraversalJob) {
                return ((CacheTraversalJob)o2).getPriority() - ((CacheTraversalJob)o1).getPriority();
            }
            if (o1IsCacheTraversalJob) {
                return -1;
            }
            if (o2IsCacheTraversalJob) {
                return 1;
            }
            return 0;
        }
    }

    static abstract class CacheTraversalJob
    implements Runnable {
        protected final int priority;
        protected final Repository repository;
        protected final OutputStream outputStream;

        protected CacheTraversalJob(int priority, Repository repository, OutputStream outputStream) {
            this.priority = priority;
            this.repository = repository;
            this.outputStream = outputStream;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheTraversalJob) {
                CacheTraversalJob other = (CacheTraversalJob)obj;
                return this.repository.equals(other.repository) && this.outputStream == other.outputStream;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.repository.hashCode() + this.outputStream.hashCode();
        }
    }
}

