/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.InternalChange;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;

public class CountAttributeChangeTransform
implements Function<Change, Change> {
    private final Map<InternalChangeLocation, CommentCounts> countsByLocation;

    public CountAttributeChangeTransform(Map<InternalChangeLocation, CommentCounts> countsByLocation) {
        this.countsByLocation = (Map)Preconditions.checkNotNull(countsByLocation, (Object)"countsByLocation");
    }

    public Change apply(Change change) {
        CommentCounts counts = this.countsByLocation.get(new InternalChangeLocation.Builder(change).build());
        if (counts != null) {
            AttributeMap attributes = new AttributeMap.Builder().add("activeComments", new String[]{String.valueOf(counts.getActive())}).add("orphanedComments", new String[]{String.valueOf(counts.getOrphaned())}).build();
            ((InternalChange)change).setAttributes(attributes);
        }
        return change;
    }
}

