/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.comment.AddDiffCommentRequest;
import com.atlassian.stash.comment.AddFileCommentRequest;
import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.comment.CommentDeletionException;
import com.atlassian.stash.comment.CommentOutOfDateException;
import com.atlassian.stash.comment.NoSuchCommentException;
import com.atlassian.stash.commit.CommitDiscussion;
import com.atlassian.stash.commit.CommitDiscussionCommentAnchor;
import com.atlassian.stash.content.DiffFileType;
import com.atlassian.stash.content.DiffSegmentType;
import com.atlassian.stash.event.commit.CommitDiscussionCommentAddedEvent;
import com.atlassian.stash.event.commit.CommitDiscussionCommentDeletedEvent;
import com.atlassian.stash.event.commit.CommitDiscussionCommentEditedEvent;
import com.atlassian.stash.event.commit.CommitDiscussionCommentRepliedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentDeletedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentEditedEvent;
import com.atlassian.stash.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.CommentableVisitor;
import com.atlassian.stash.internal.comment.DiffCommentAnchorDao;
import com.atlassian.stash.internal.comment.DiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentHelper;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestDiffCommentAnchor;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.ValidationUtils;
import com.atlassian.stash.validation.groups.Create;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Validator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCommentHelper<T extends InternalCommentable, A extends InternalDiffCommentAnchor>
implements InternalCommentHelper<T, A> {
    private static final Function<? super InternalDiffCommentAnchor, InternalComment> TO_COMMENT = new Function<InternalDiffCommentAnchor, InternalComment>(){

        public InternalComment apply(InternalDiffCommentAnchor anchor) {
            return anchor.getComment();
        }
    };
    protected final DiffCommentAnchorDao<T, A> anchorDao;
    protected final EventPublisher eventPublisher;
    protected final I18nService i18nService;
    private final StashAuthenticationContext authenticationContext;
    private final CommentDao commentDao;
    private final PermissionService permissionService;
    private final CommentPostProcessor postProcessor;
    private final Validator validator;

    protected AbstractCommentHelper(DiffCommentAnchorDao<T, A> anchorDao, StashAuthenticationContext authenticationContext, CommentDao commentDao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, CommentPostProcessor postProcessor, Validator validator) {
        this.anchorDao = anchorDao;
        this.authenticationContext = authenticationContext;
        this.commentDao = commentDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.postProcessor = postProcessor;
        this.validator = validator;
    }

    @Nonnull
    public Map<InternalChangeLocation, CommentCounts> countsByLocation(@Nonnull T entity) {
        return this.anchorDao.getCountsByLocation(entity);
    }

    @Nonnull
    public InternalComment create(@Nonnull T entity, @Nonnull String text) {
        return this.createComment(entity, null, text);
    }

    @Nonnull
    public InternalComment createDiffComment(@Nonnull T entity, @Nonnull AddDiffCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        this.validateFileType(request);
        return this.doCreateComment(entity, null, request.getText(), this.diffAnchor(entity, request));
    }

    @Nonnull
    public InternalComment createFileComment(@Nonnull T entity, @Nonnull AddFileCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.doCreateComment(entity, null, request.getText(), this.fileAnchor(entity, request));
    }

    @Nonnull
    public InternalComment createReply(@Nonnull T entity, long parentId, String commentText) {
        return this.createComment(entity, this.getById(entity, parentId), commentText);
    }

    public boolean delete(@Nonnull T entity, long commentId, int version) {
        final InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null) {
            return false;
        }
        this.validateVersion(version, comment.getVersion());
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if ((currentUser == null || ObjectUtils.notEqual((Object)currentUser.getId(), (Object)comment.getAuthor().getId())) && !this.permissionService.hasRepositoryPermission((Repository)entity.getScopeRepository(), Permission.REPO_ADMIN)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.comment.delete.otheruser", new Object[0]));
        }
        if (!comment.getComments().isEmpty()) {
            throw new CommentDeletionException(this.i18nService.createKeyedMessage("stash.service.comment.delete.hasreplies", new Object[0]));
        }
        this.deleteActivities(entity, comment);
        this.commentDao.delete((Object)InternalConverter.convertToInternalComment((Comment)comment));
        this.eventPublisher.publish(entity.accept((CommentableVisitor)new CommentableVisitor<Object>(){

            public Object visit(@Nonnull InternalCommitDiscussion discussion) {
                return new CommitDiscussionCommentDeletedEvent((Object)AbstractCommentHelper.this, (CommitDiscussion)discussion, (Comment)comment, (Comment)comment.getParent());
            }

            public Object visit(@Nonnull InternalPullRequest pullRequest) {
                return new PullRequestCommentDeletedEvent((Object)AbstractCommentHelper.this, (PullRequest)pullRequest, (Comment)comment, (Comment)comment.getParent());
            }
        }));
        return true;
    }

    @Nonnull
    public InternalComment getById(@Nonnull T entity, long commentId) {
        return this.postProcessor.process(entity.getScopeRepository(), this.getCommentOrFail(commentId));
    }

    @Nonnull
    public InternalComment update(@Nonnull T entity, long commentId, int version, @Nonnull String text) {
        if (StringUtils.isBlank((String)text)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.service.comment.update.requirestext", new Object[0]));
        }
        InternalComment comment = this.getCommentOrFail(commentId, version);
        final String previousText = comment.getText();
        InternalStashUser currentUser = InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser());
        if (currentUser == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.comment.update.anonymous", new Object[0]));
        }
        if (ObjectUtils.notEqual((Object)currentUser.getId(), (Object)comment.getAuthor().getId())) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.comment.update.otheruser", new Object[0]));
        }
        final InternalComment updated = (InternalComment)this.commentDao.update((Object)new InternalComment.Builder(comment).text(text).updatedDate(new Date()).build());
        this.eventPublisher.publish(entity.accept((CommentableVisitor)new CommentableVisitor<Object>(){

            public Object visit(@Nonnull InternalCommitDiscussion discussion) {
                return new CommitDiscussionCommentEditedEvent((Object)AbstractCommentHelper.this, (CommitDiscussion)discussion, (Comment)updated, (Comment)updated.getParent(), previousText);
            }

            public Object visit(@Nonnull InternalPullRequest pullRequest) {
                return new PullRequestCommentEditedEvent((Object)AbstractCommentHelper.this, (PullRequest)pullRequest, (Comment)updated, (Comment)updated.getParent(), previousText);
            }
        }));
        this.addActivity(entity, updated, null, CommentAction.EDITED, currentUser);
        return this.postProcessor.process(entity.getScopeRepository(), updated);
    }

    protected abstract void addActivity(@Nonnull T var1, @Nonnull InternalComment var2, @Nullable A var3, @Nonnull CommentAction var4, @Nonnull InternalStashUser var5);

    protected abstract void deleteActivities(@Nonnull T var1, @Nonnull InternalComment var2);

    protected abstract Function<InternalComment, A> diffAnchor(@Nonnull T var1, @Nonnull AddDiffCommentRequest var2);

    protected abstract Function<InternalComment, A> fileAnchor(@Nonnull T var1, @Nonnull AddFileCommentRequest var2);

    @Nonnull
    protected List<A> search(@Nonnull T entity, @Nonnull DiffCommentAnchorSearchCriteria searchCriteria) {
        List anchors = this.anchorDao.search(entity, searchCriteria);
        this.postProcessor.processAll(entity.getScopeRepository(), Lists.transform((List)anchors, TO_COMMENT));
        return anchors;
    }

    private InternalComment createComment(T entity, InternalComment parent, String text) {
        return this.doCreateComment(entity, parent, text, null);
    }

    private InternalComment doCreateComment(T entity, InternalComment parent, String text, Function<InternalComment, A> anchorFunction) {
        CommentAction commentAction;
        InternalDiffCommentAnchor anchor;
        if (StringUtils.isBlank((String)text)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.service.comment.new.requirestext", new Object[0]));
        }
        Date modified = new Date();
        InternalStashUser user = InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser());
        final InternalComment comment = (InternalComment)this.commentDao.create((Object)new InternalComment.Builder().author(user).createdDate(modified).parent(parent).text(text).updatedDate(modified).build());
        if (parent == null) {
            if (anchorFunction == null) {
                anchor = null;
            } else {
                anchor = (InternalDiffCommentAnchor)anchorFunction.apply((Object)comment);
                this.anchorDao.create(ValidationUtils.validate((Validator)this.validator, (Object)anchor, (Class[])new Class[]{Create.class}));
            }
            commentAction = CommentAction.ADDED;
            this.eventPublisher.publish(entity.accept((CommentableVisitor)new CommentableVisitor<Object>(){

                public Object visit(@Nonnull InternalCommitDiscussion discussion) {
                    return new CommitDiscussionCommentAddedEvent((Object)AbstractCommentHelper.this, (CommitDiscussion)discussion, (Comment)comment, null, (CommitDiscussionCommentAnchor)anchor);
                }

                public Object visit(@Nonnull InternalPullRequest pullRequest) {
                    return new PullRequestCommentAddedEvent((Object)AbstractCommentHelper.this, (PullRequest)pullRequest, (Comment)comment, null, (PullRequestDiffCommentAnchor)anchor);
                }
            }));
        } else {
            anchor = null;
            commentAction = CommentAction.REPLIED;
            this.eventPublisher.publish(entity.accept((CommentableVisitor)new CommentableVisitor<Object>(){

                public Object visit(@Nonnull InternalCommitDiscussion discussion) {
                    return new CommitDiscussionCommentRepliedEvent((Object)AbstractCommentHelper.this, (CommitDiscussion)discussion, (Comment)comment, (Comment)comment.getParent());
                }

                public Object visit(@Nonnull InternalPullRequest pullRequest) {
                    return new PullRequestCommentRepliedEvent((Object)AbstractCommentHelper.this, (PullRequest)pullRequest, (Comment)comment, (Comment)comment.getParent());
                }
            }));
        }
        this.addActivity(entity, comment, anchor, commentAction, user);
        return this.postProcessor.process(entity.getScopeRepository(), comment);
    }

    private InternalComment getCommentOrFail(long commentId) {
        InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null) {
            throw new NoSuchCommentException(this.i18nService.createKeyedMessage("stash.service.comment.nosuchcomment", new Object[0]));
        }
        return comment;
    }

    private InternalComment getCommentOrFail(long commentId, int version) {
        InternalComment comment = this.getCommentOrFail(commentId);
        this.validateVersion(version, comment.getVersion());
        return comment;
    }

    private void validateFileType(AddDiffCommentRequest request) {
        if (request.getLineType() == DiffSegmentType.REMOVED && request.getFileType() != DiffFileType.FROM) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.service.comment.error.filetype", new Object[]{DiffSegmentType.REMOVED, DiffFileType.FROM, request.getFileType()}));
        }
        if (request.getLineType() == DiffSegmentType.ADDED && request.getFileType() != DiffFileType.TO) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.service.comment.error.filetype", new Object[]{DiffSegmentType.ADDED, DiffFileType.TO, request.getFileType()}));
        }
    }

    private void validateVersion(int expectedVersion, int actualVersion) {
        if (actualVersion != expectedVersion) {
            throw new CommentOutOfDateException(this.i18nService.createKeyedMessage("stash.service.comment.outofdate", new Object[0]), expectedVersion, actualVersion);
        }
    }
}

