/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.stash.cluster.ClusterNode;
import com.atlassian.stash.nav.NavBuilder;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.annotation.Nonnull;

public class LocalClusterNode
implements ClusterNode {
    private final NavBuilder navBuilder;

    public LocalClusterNode(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        URI uri = URI.create(this.navBuilder.buildBaseUrl());
        int port = uri.getPort();
        if (port == -1) {
            port = "http".equalsIgnoreCase(uri.getScheme()) ? 80 : 443;
        }
        return InetSocketAddress.createUnresolved(uri.getHost(), port);
    }

    @Nonnull
    public String getId() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    public boolean isLocal() {
        return true;
    }
}

