/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.license.SIDManager;
import com.atlassian.stash.internal.bootstrap.Bootstrapper;
import com.atlassian.stash.internal.profiles.Dev;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.SetPermissionRequest;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.UrlUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Dev
@Component(value="bootstrapperService")
public class DevBootstrapper
extends Bootstrapper {
    private static final List<UserData> ADMINISTRATORS = ImmutableList.of((Object)new UserData("admin", "Ad", "Min", "Administrator"));
    public static final String LICENSE = "AAABAw0ODAoPeNptkN1Kw0AQhe/7FAtep+Sn0FJYMDbBFE0aaazX4zq1C8kmzGyCfXvTuC0o3i3n7\nHdm5ty94YfIgYS/FEGwXizWYSTSfSVCPwhnbIFP83SAugerWyOPUDM6OUFWpLtJr5CteNYKzc3eE\nE5MAhblJc3zI89fXt3WWFC2gAbl+G7J6TloY9GAUZh+dZrOE15GmfNHRg8oLfX4OykdyVqqS9Q92\nBqYNZi5ahv3zS1XnTuchlbjkdvicbZHGpC2iXw4bDIvXr2svDCOMu/pUOYOLYGsQZowJ+3oE4zmn\n1Li6zhnFn3zjrQ7vjISy1uNboN/zyp7Uidg/FvWNzfnjvQwLAIUTVb2KvELK9HtYl4MOc1u/Z8yx\n20CFDHaIjT/tVAlYnXGmXy3SlkcnixtX02d9";
    private static final Logger log = LoggerFactory.getLogger(DevBootstrapper.class);
    private static final List<UserData> USERS = ImmutableList.of((Object)new UserData("user", "U", "Ser", "User"));
    private final LicenseService licenseService;
    private final UserService userService;

    @Autowired
    public DevBootstrapper(ApplicationManager appManager, DirectoryManager directoryManager, InternalApplicationPropertiesService propertiesService, SecurityService securityService, PermissionAdminService permissionAdminService, SIDManager sidManager, LicenseService licenseService, UserService userService) {
        super(appManager, directoryManager, propertiesService, securityService, permissionAdminService, sidManager);
        this.licenseService = licenseService;
        this.userService = userService;
    }

    @Override
    protected void addUsers(Directory dir) throws CrowdException, PermissionException {
        Long dirId = dir.getId();
        StashLicense license = this.licenseService.get();
        int licensedUsers = 0;
        for (UserData data : ADMINISTRATORS) {
            this.addUser(data.username, data.firstName, data.lastName, data.name, dirId, new String[0]);
            StashUser user = this.userService.getUserByName(data.username);
            this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().globalPermission(Permission.SYS_ADMIN).user(user).build());
            ++licensedUsers;
        }
        for (UserData data : USERS) {
            this.addUser(data.username, data.firstName, data.lastName, data.name, dirId, new String[0]);
            if (licensedUsers < license.getMaximumNumberOfUsers()) {
                this.directoryManager.addUserToGroup(dirId.longValue(), data.username, "stash-users");
                ++licensedUsers;
                continue;
            }
            log.warn("Not adding {} to {}; there are already {} licensed users", new Object[]{data.username, "stash-users", licensedUsers});
        }
    }

    @Override
    public synchronized void bootstrap() {
        this.licenseService.update(LICENSE);
        super.bootstrap();
        this.disableFirstRunWizard();
    }

    @Override
    protected void ensureMinimalApplicationProperties() {
        super.ensureMinimalApplicationProperties();
        if (this.propertiesService.getBaseUrl() == null) {
            this.propertiesService.setBaseURL(UrlUtils.uncheckedCreateURI((String)"http://localhost:7990/stash"));
        }
    }

    private static class UserData {
        private final String firstName;
        private final String lastName;
        private final String name;
        private final String username;

        private UserData(String username, String firstName, String lastName, String name) {
            this.username = username;
            this.firstName = firstName;
            this.lastName = lastName;
            this.name = name;
        }
    }
}

