/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.license.SIDManager;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.profiles.Production;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.SetPermissionRequest;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Production
@Component(value="bootstrapperService")
public class Bootstrapper
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    protected final ApplicationManager appManager;
    protected final DirectoryManager directoryManager;
    protected final PermissionAdminService permissionAdminService;
    protected final InternalApplicationPropertiesService propertiesService;
    protected final SecurityService securityService;
    protected final SIDManager sidManager;
    private final AtomicBoolean started;

    @Autowired
    public Bootstrapper(ApplicationManager appManager, DirectoryManager directoryManager, InternalApplicationPropertiesService propertiesService, SecurityService securityService, PermissionAdminService permissionAdminService, SIDManager sidManager) {
        this.propertiesService = propertiesService;
        this.appManager = appManager;
        this.directoryManager = directoryManager;
        this.permissionAdminService = permissionAdminService;
        this.securityService = securityService;
        this.sidManager = sidManager;
        this.started = new AtomicBoolean(false);
    }

    @Transactional
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.started.compareAndSet(false, true)) {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Bootstrap application").call((Operation)new UncheckedOperation<Void>(){

                public Void perform() {
                    List allDirectories = Bootstrapper.this.directoryManager.findAllDirectories();
                    if (allDirectories == null || allDirectories.isEmpty()) {
                        Bootstrapper.this.bootstrap();
                    }
                    Bootstrapper.this.ensureMinimalApplicationProperties();
                    return null;
                }
            });
        }
    }

    public synchronized void bootstrap() {
        Directory directory;
        Application application;
        try {
            application = this.appManager.findByName(ApplicationConstants.CROWD_APPLICATION_NAME);
        }
        catch (ApplicationNotFoundException e) {
            application = ApplicationImpl.newInstanceWithCredential((String)ApplicationConstants.CROWD_APPLICATION_NAME, (ApplicationType)ApplicationType.CROWD, (PasswordCredential)PasswordCredential.NONE);
            try {
                application = this.appManager.add(application);
            }
            catch (InvalidCredentialException ice) {
                throw new RuntimeException(ice);
            }
        }
        try {
            directory = this.directoryManager.findDirectoryByName(ApplicationConstants.INTERNAL_DIRECTORY_NAME);
        }
        catch (DirectoryNotFoundException e) {
            DirectoryImpl dir = new DirectoryImpl();
            dir.setName(ApplicationConstants.INTERNAL_DIRECTORY_NAME);
            dir.setActive(true);
            dir.setDescription(ApplicationConstants.INTERNAL_DIRECTORY_NAME);
            dir.setType(DirectoryType.INTERNAL);
            dir.setImplementationClass(InternalDirectory.class.getName());
            for (OperationType t : OperationType.values()) {
                dir.addAllowedOperation(t);
            }
            dir.setAttribute("user_encryption_method", "atlassian-security");
            try {
                directory = this.directoryManager.addDirectory((Directory)dir);
            }
            catch (DirectoryInstantiationException die) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.appManager.addDirectoryMapping(application, directory, true, OperationType.values());
        }
        catch (CrowdException e) {
            throw new RuntimeException(e);
        }
        Long dirId = directory.getId();
        try {
            this.directoryManager.addGroup(dirId.longValue(), new GroupTemplate("stash-users", dirId.longValue()));
            this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().globalPermission(Permission.LICENSED_USER).group("stash-users").build());
            this.addUsers(directory);
        }
        catch (CrowdException | PermissionException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    protected void addUsers(Directory dir) throws CrowdException, PermissionException {
    }

    protected void ensureMinimalApplicationProperties() {
        if (this.propertiesService.getServerId() == null) {
            this.propertiesService.setServerId(this.sidManager.generateSID());
        }
        if (this.propertiesService.getDisplayName() == null) {
            this.propertiesService.setDisplayName(ApplicationConstants.PRODUCT_NAME);
        }
    }

    protected void addUser(String username, String first, String last, String display, long dirId, String ... groups) throws CrowdException, PermissionException {
        UserTemplate user = new UserTemplate(username, first, last, display);
        user.setDirectoryId(dirId);
        user.setEmailAddress(username + "@example.com");
        user.setActive(true);
        this.directoryManager.addUser(dirId, user, new PasswordCredential(username));
        if (groups != null) {
            for (String group : groups) {
                this.directoryManager.addUserToGroup(dirId, username, group);
            }
        }
    }

    protected void disableFirstRunWizard() {
        this.propertiesService.setSetup(true);
    }

    public int getOrder() {
        return 10000;
    }
}

