/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.auth.CaptchaResponse;
import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.user.CaptchaTicket;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.AuthenticationException;
import com.atlassian.stash.user.AuthenticationSystemException;
import com.atlassian.stash.user.CaptchaRequiredAuthenticationException;
import com.atlassian.stash.user.IncorrectCaptchaAuthenticationException;
import com.atlassian.stash.user.IncorrectPasswordAuthenticationException;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.base.Preconditions;
import com.octo.captcha.service.CaptchaServiceException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="captchaService")
public class DefaultCaptchaService
extends AbstractService
implements CaptchaService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCaptchaService.class);
    public static final String FAILED_AUTHENTICATION_ATTEMPT_COUNT = "failedAuthenticationAttemptCount";
    private final com.octo.captcha.service.CaptchaService captchaService;
    private final CrowdControl crowdControl;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultCaptchaService(com.octo.captcha.service.CaptchaService captchaService, CrowdControl crowdControl, FeatureManager featureManager, I18nService i18nService, ApplicationPropertiesService propertiesService) {
        this.captchaService = captchaService;
        this.crowdControl = crowdControl;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
    }

    @Transactional(noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
    @Unsecured(value="This needs to be available during authentication")
    public StashUser authenticateWithCaptcha(@Nonnull CaptchaTicket captchaTicket, @Nonnull UncheckedOperation<StashUser> authenticateOperation) {
        Preconditions.checkNotNull((Object)captchaTicket, (Object)"captchaTicket");
        Preconditions.checkNotNull(authenticateOperation, (Object)"authenticateOperation");
        Preconditions.checkArgument((boolean)(captchaTicket instanceof ValidCaptchaTicket), (Object)"invalid CaptchaTicket!");
        ValidCaptchaTicket validCaptchaTicket = (ValidCaptchaTicket)captchaTicket;
        try {
            StashUser user = (StashUser)authenticateOperation.perform();
            if (user != null) {
                validCaptchaTicket.onAuthenticationSuccess();
            }
            return user;
        }
        catch (IncorrectPasswordAuthenticationException e) {
            validCaptchaTicket.onAuthenticationFailure((AuthenticationException)e);
            throw e;
        }
    }

    @Nonnull
    @Unsecured(value="This needs to be available during authentication")
    public CaptchaTicket checkCaptcha(@Nonnull String username, @Nullable CaptchaResponse captchaResponse) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        UserWithAttributes attributes = this.crowdControl.findUserWithAttributes(username);
        if (this.isCaptchaRequired(attributes)) {
            if (captchaResponse == null) {
                throw new CaptchaRequiredAuthenticationException(this.missingCaptchaResponse());
            }
            if (!captchaResponse.isVerified() && !this.isCaptchaValid(captchaResponse)) {
                this.incrementAttemptCountFor(attributes);
                throw new IncorrectCaptchaAuthenticationException(this.invalidCaptcha());
            }
        }
        return new ValidCaptchaTicket(attributes);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void clearCaptchaChallenge(@Nonnull String username) {
        User user = this.crowdControl.findUser(username, false);
        if (user == null) {
            throw this.newNoSuchUserException(username);
        }
        this.crowdControl.setUserAttribute(user, FAILED_AUTHENTICATION_ATTEMPT_COUNT, (Object)0L);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean isCaptchaChallenged(@Nonnull String username) {
        UserWithAttributes user = this.crowdControl.findUserWithAttributes(username);
        if (user == null) {
            throw this.newNoSuchUserException(username);
        }
        return this.isCaptchaRequired(user);
    }

    @Unsecured(value="This needs to be available during signup")
    public boolean validateCaptchaResponse(@Nonnull CaptchaResponse captchaResponse) {
        return this.captchaService.validateResponseForID(captchaResponse.getChallengeId(), (Object)captchaResponse.getUserResponse());
    }

    private KeyedMessage captchaServiceFail() {
        return this.i18nService.createKeyedMessage("stash.service.user.captchasvcfail", new Object[0]);
    }

    private long getAttemptCountFor(UserWithAttributes user) {
        String count;
        if (user != null && (count = user.getValue(FAILED_AUTHENTICATION_ATTEMPT_COUNT)) != null) {
            try {
                return Long.valueOf(count);
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Invalid attribute %s for user %s: %s", FAILED_AUTHENTICATION_ATTEMPT_COUNT, user.getName(), count));
            }
        }
        return 0L;
    }

    private long incrementAttemptCount(long val) {
        return val == Long.MAX_VALUE ? Long.MAX_VALUE : val + 1L;
    }

    private long incrementAttemptCountFor(UserWithAttributes user) {
        if (user != null) {
            long failedLoginCount = this.incrementAttemptCount(this.getAttemptCountFor(user));
            this.crowdControl.setUserAttribute((User)user, FAILED_AUTHENTICATION_ATTEMPT_COUNT, (Object)failedLoginCount);
            return failedLoginCount;
        }
        return 0L;
    }

    private KeyedMessage invalidCaptcha() {
        return this.i18nService.createKeyedMessage("stash.service.user.invalidcaptcha", new Object[0]);
    }

    private boolean isCaptchaRequired(UserWithAttributes user) {
        return this.isCaptchaRequired(this.getAttemptCountFor(user));
    }

    private boolean isCaptchaRequired(long attempts) {
        return this.featureManager.isEnabled(Feature.AUTH_CAPTCHA) && attempts > 0L && attempts >= (long)this.propertiesService.getMaxCaptchaAttempts();
    }

    private boolean isCaptchaValid(CaptchaResponse response) {
        try {
            if (!response.isVerified() && this.captchaService.validateResponseForID(response.getChallengeId(), (Object)response.getUserResponse()).booleanValue()) {
                response.setVerified(true);
            }
            return response.isVerified();
        }
        catch (CaptchaServiceException e) {
            throw new AuthenticationSystemException(this.captchaServiceFail());
        }
    }

    private KeyedMessage missingCaptchaResponse() {
        return this.i18nService.createKeyedMessage("stash.service.user.missingcaptcharesponse", new Object[0]);
    }

    private NoSuchUserException newNoSuchUserException(String username) {
        throw new NoSuchUserException(this.i18nService.createKeyedMessage("stash.service.users.noSuchUser", new Object[]{username}), username);
    }

    private class ValidCaptchaTicket
    implements CaptchaTicket {
        private long attempts;
        private final UserWithAttributes user;

        private ValidCaptchaTicket(UserWithAttributes user) {
            this.attempts = DefaultCaptchaService.this.getAttemptCountFor(user);
            this.user = user;
        }

        public void onAuthenticationFailure(AuthenticationException exception) {
            if (this.user != null) {
                this.attempts = DefaultCaptchaService.this.incrementAttemptCount(this.attempts);
                DefaultCaptchaService.this.crowdControl.setUserAttribute((User)this.user, DefaultCaptchaService.FAILED_AUTHENTICATION_ATTEMPT_COUNT, (Object)this.attempts);
                if (DefaultCaptchaService.this.isCaptchaRequired(this.attempts)) {
                    throw new CaptchaRequiredAuthenticationException(exception.getKeyedMessage());
                }
            }
        }

        public void onAuthenticationSuccess() {
            if (this.attempts != 0L) {
                DefaultCaptchaService.this.crowdControl.setUserAttribute((User)this.user, DefaultCaptchaService.FAILED_AUTHENTICATION_ATTEMPT_COUNT, (Object)0L);
            }
        }
    }
}

