/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.event.audit.AuditEvent;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="auditEventListener")
public class AuditEventListener {
    private final AuditEntryLoggingService service;
    private Priority priorityToFilter;

    @Autowired
    public AuditEventListener(AuditEntryLoggingService service) {
        this.service = service;
    }

    @Value(value="${audit.highest.priority.to.log}")
    public void setPriorityToLog(Priority priority) {
        this.priorityToFilter = priority;
    }

    @EventListener
    public void onAuditEvent(AuditEvent event) {
        if (this.priorityToFilter == Priority.NONE) {
            return;
        }
        if (event.getPriority().getWeight() >= this.priorityToFilter.getWeight()) {
            this.service.log(event.getEntry());
        }
    }
}

