/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.Product;
import com.atlassian.stash.event.permission.GlobalPermissionGrantRequestedEvent;
import com.atlassian.stash.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.stash.event.permission.GlobalPermissionModificationRequestedEvent;
import com.atlassian.stash.event.permission.GlobalPermissionModifiedEvent;
import com.atlassian.stash.event.permission.GlobalPermissionRevocationRequestedEvent;
import com.atlassian.stash.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.stash.event.permission.PermissionEvent;
import com.atlassian.stash.event.permission.ProjectPermissionEvent;
import com.atlassian.stash.event.permission.ProjectPermissionGrantRequestedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionModificationRequestedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionModifiedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionRevocationRequestedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionRevokedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionGrantRequestedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionGrantedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionModificationRequestedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionModifiedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionRevocationRequestedEvent;
import com.atlassian.stash.event.permission.RepositoryPermissionRevokedEvent;
import com.atlassian.stash.event.user.GroupCleanupEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.RequestCanceledException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.experimental.user.ExperimentalPermissionAdminService;
import com.atlassian.stash.experimental.user.PermittedGroupGlobalSearchRequest;
import com.atlassian.stash.experimental.user.PermittedGroupProjectSearchRequest;
import com.atlassian.stash.experimental.user.PermittedGroupRepositorySearchRequest;
import com.atlassian.stash.experimental.user.PermittedGroupSearchRequest;
import com.atlassian.stash.experimental.user.PermittedUserGlobalSearchRequest;
import com.atlassian.stash.experimental.user.PermittedUserProjectSearchRequest;
import com.atlassian.stash.experimental.user.PermittedUserRepositorySearchRequest;
import com.atlassian.stash.experimental.user.PermittedUserSearchRequest;
import com.atlassian.stash.experimental.user.ProjectPermission;
import com.atlassian.stash.experimental.user.ProjectPermissionRequest;
import com.atlassian.stash.experimental.user.ProjectPermissionSearchRequest;
import com.atlassian.stash.experimental.user.RepositoryPermission;
import com.atlassian.stash.experimental.user.RepositoryPermissionRequest;
import com.atlassian.stash.experimental.user.RepositoryPermissionSearchRequest;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.GroupPageFilter;
import com.atlassian.stash.internal.user.InIteratorPredicate;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.atlassian.stash.internal.user.UserPageFilter;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.PermissionGrantCanceledException;
import com.atlassian.stash.user.PermissionModificationCanceledException;
import com.atlassian.stash.user.PermissionRevocationCanceledException;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.PermissionValidationService;
import com.atlassian.stash.user.PermittedGroup;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.SetPermissionRequest;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.SimpleCancelState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={PermissionAdminService.class, ExperimentalPermissionAdminService.class})
@Service(value="permissionAdminService")
@Transactional(readOnly=true)
public class PermissionAdminServiceImpl
implements ExperimentalPermissionAdminService {
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return IdentifierUtils.compareToInLowerCase((String)s1, (String)s2);
        }
    };
    private static final Comparator<StashUser> CASE_INSENSITIVE_NAME_COMPARATOR = new Comparator<StashUser>(){

        @Override
        public int compare(StashUser u1, StashUser u2) {
            return IdentifierUtils.compareToInLowerCase((String)u1.getName(), (String)u2.getName());
        }
    };
    public static final int INTERNAL_PAGE_LIMIT = 500;
    private final EventPublisher eventPublisher;
    private final GlobalPermissionDao globalPermissionDao;
    private final ProjectPermissionDao projectPermissionDao;
    private final RepositoryPermissionDao repositoryPermissionDao;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final int maxUsers;
    private final int maxGroups;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final StashAuthenticationContext authenticationContext;
    private final InternalUserService userService;

    @Autowired
    public PermissionAdminServiceImpl(InternalUserService userService, GlobalPermissionDao globalPermissionDao, ProjectPermissionDao projectPermissionDao, RepositoryPermissionDao repositoryPermissionDao, StashAuthenticationContext authenticationContext, PermissionService permissionService, PermissionValidationService permissionValidationService, I18nService i18nService, LicenseService licenseService, EventPublisher eventPublisher, @Value(value="${page.max.users}") int maxUsers, @Value(value="${page.max.groups}") int maxGroups) {
        this.userService = userService;
        this.globalPermissionDao = globalPermissionDao;
        this.projectPermissionDao = projectPermissionDao;
        this.repositoryPermissionDao = repositoryPermissionDao;
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.eventPublisher = eventPublisher;
        this.maxUsers = maxUsers;
        this.maxGroups = maxGroups;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<ProjectPermission> searchProjects(@Nonnull ProjectPermissionSearchRequest request, @Nonnull PageRequest pageRequest) {
        this.validateRequest(request);
        CommonValidations.validatePageRequest(pageRequest);
        return this.projectPermissionDao.findHighestPermissionsForUser(request.getUser().getId().intValue(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<RepositoryPermission> searchRepositories(@Nonnull RepositoryPermissionSearchRequest request, @Nonnull PageRequest pageRequest) {
        this.validateRequest(request);
        CommonValidations.validatePageRequest(pageRequest);
        return this.repositoryPermissionDao.findHighestPermissionsForUser(request.getUser().getId().intValue(), pageRequest);
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<PermittedUser> searchUsers(@Nonnull PermittedUserSearchRequest request, final @Nonnull PageRequest pageRequest) {
        this.validateRequest(request);
        CommonValidations.validatePageRequest(pageRequest);
        return (Page)request.accept((PermittedUserSearchRequest.Visitor)new PermittedUserSearchRequest.Visitor<Page<PermittedUser>>(){

            public Page<PermittedUser> visit(@Nonnull PermittedUserGlobalSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return PermissionAdminServiceImpl.this.globalPermissionDao.findHighestPermissionPerUser(request.getUserType(), request.getNameFilter(), pageRequest);
            }

            public Page<PermittedUser> visit(@Nonnull PermittedUserProjectSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return PermissionAdminServiceImpl.this.projectPermissionDao.findHighestPermissionPerUser(request.getProject().getId().intValue(), request.getUserType(), request.getNameFilter(), pageRequest);
            }

            public Page<PermittedUser> visit(@Nonnull PermittedUserRepositorySearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return PermissionAdminServiceImpl.this.repositoryPermissionDao.findHighestPermissionPerUser(request.getRepository().getId().intValue(), request.getUserType(), request.getNameFilter(), pageRequest);
            }
        });
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<PermittedGroup> searchGroups(@Nonnull PermittedGroupSearchRequest request, final @Nonnull PageRequest pageRequest) {
        this.validateRequest(request);
        CommonValidations.validatePageRequest(pageRequest);
        return (Page)request.accept((PermittedGroupSearchRequest.Visitor)new PermittedGroupSearchRequest.Visitor<Page<PermittedGroup>>(){

            public Page<PermittedGroup> visit(@Nonnull PermittedGroupGlobalSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return PermissionAdminServiceImpl.this.globalPermissionDao.findHighestPermissionPerGroup(request.getNameFilter(), pageRequest);
            }

            public Page<PermittedGroup> visit(@Nonnull PermittedGroupProjectSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return PermissionAdminServiceImpl.this.projectPermissionDao.findHighestPermissionPerGroup(request.getProject().getId().intValue(), request.getNameFilter(), pageRequest);
            }

            public Page<PermittedGroup> visit(@Nonnull PermittedGroupRepositorySearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return PermissionAdminServiceImpl.this.repositoryPermissionDao.findHighestPermissionPerGroup(request.getRepository().getId().intValue(), request.getNameFilter(), pageRequest);
            }
        });
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<StashUser> searchUsersLacking(@Nonnull PermittedUserSearchRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request);
        CommonValidations.validatePageRequest(pageRequest);
        PageProvider provider = (PageProvider)request.accept((PermittedUserSearchRequest.Visitor)new PermittedUserSearchRequest.Visitor<PageProvider<StashUser>>(){

            public PageProvider<StashUser> visit(final @Nonnull PermittedUserGlobalSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return new PageProvider<StashUser>(){

                    public Page<StashUser> get(PageRequest innerPageRequest) {
                        return PermissionAdminServiceImpl.this.globalPermissionDao.findUsersWithPermission(request.getUserType(), innerPageRequest);
                    }
                };
            }

            public PageProvider<StashUser> visit(final @Nonnull PermittedUserProjectSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return new PageProvider<StashUser>(){

                    public Page<StashUser> get(PageRequest innerPageRequest) {
                        return PermissionAdminServiceImpl.this.projectPermissionDao.findUsersWithPermission(request.getProject().getId().intValue(), request.getUserType(), innerPageRequest);
                    }
                };
            }

            public PageProvider<StashUser> visit(final @Nonnull PermittedUserRepositorySearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return new PageProvider<StashUser>(){

                    public Page<StashUser> get(PageRequest innerPageRequest) {
                        return PermissionAdminServiceImpl.this.repositoryPermissionDao.findUsersWithPermission(request.getRepository().getId().intValue(), request.getUserType(), innerPageRequest);
                    }
                };
            }
        });
        return this.getUsersWithoutPermission(PermissionAdminServiceImpl.withoutUsers((PageProvider<StashUser>)provider), request.getUserType(), request.getNameFilter(), pageRequest);
    }

    @Nonnull
    @Secured(value="Secured internally using the PermissionValidationService")
    public Page<String> searchGroupsLacking(@Nonnull PermittedGroupSearchRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request);
        CommonValidations.validatePageRequest(pageRequest);
        PageProvider provider = (PageProvider)request.accept((PermittedGroupSearchRequest.Visitor)new PermittedGroupSearchRequest.Visitor<PageProvider<String>>(){

            public PageProvider<String> visit(@Nonnull PermittedGroupGlobalSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForGlobal(Permission.ADMIN);
                return new PageProvider<String>(){

                    public Page<String> get(PageRequest innerPageRequest) {
                        return PermissionAdminServiceImpl.this.globalPermissionDao.findGroupsWithPermission(innerPageRequest);
                    }
                };
            }

            public PageProvider<String> visit(final @Nonnull PermittedGroupProjectSearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForProject(request.getProject(), Permission.PROJECT_ADMIN);
                return new PageProvider<String>(){

                    public Page<String> get(PageRequest innerPageRequest) {
                        return PermissionAdminServiceImpl.this.projectPermissionDao.findGroupsWithPermission(request.getProject().getId().intValue(), innerPageRequest);
                    }
                };
            }

            public PageProvider<String> visit(final @Nonnull PermittedGroupRepositorySearchRequest request) {
                PermissionAdminServiceImpl.this.permissionValidationService.validateForRepository(request.getRepository(), Permission.REPO_ADMIN);
                return new PageProvider<String>(){

                    public Page<String> get(PageRequest innerPageRequest) {
                        return PermissionAdminServiceImpl.this.repositoryPermissionDao.findGroupsWithPermission(request.getRepository().getId().intValue(), innerPageRequest);
                    }
                };
            }
        });
        return this.getGroupsWithoutPermission(request.getNameFilter(), PermissionAdminServiceImpl.withoutGroups((PageProvider<String>)provider), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedUser> findUsersWithGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.Builder)new PermittedUserSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<StashUser> findUsersWithoutGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsersLacking((PermittedUserSearchRequest)((PermittedUserSearchRequest.Builder)new PermittedUserSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<PermittedGroup> findGroupsWithGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroups((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.Builder)new PermittedGroupSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Page<String> findGroupsWithoutGlobalPermission(String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroupsLacking((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.Builder)new PermittedGroupSearchRequest.Builder().nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedUser> findUsersWithProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.ProjectBuilder)new PermittedUserSearchRequest.Builder().project(project).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<StashUser> findUsersWithoutProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsersLacking((PermittedUserSearchRequest)((PermittedUserSearchRequest.ProjectBuilder)new PermittedUserSearchRequest.Builder().project(project).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<PermittedGroup> findGroupsWithProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroups((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.ProjectBuilder)new PermittedGroupSearchRequest.Builder().project(project).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public Page<String> findGroupsWithoutProjectPermission(@Nonnull Project project, String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroupsLacking((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.ProjectBuilder)new PermittedGroupSearchRequest.Builder().project(project).nameFilter(filter)).build(), pageRequest);
    }

    private Page<StashUser> getUsersWithoutPermission(Predicate<StashUser> pageFilter, UserType userType, String filter, PageRequest request) {
        PageProvider<StashUser> userProvider = this.createUserProvider(userType, filter);
        UserPageFilter userMatchFilter = new UserPageFilter(filter);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxUsers);
        return PageUtils.filterPages(userProvider, (Predicate)Predicates.and((Predicate)userMatchFilter, pageFilter), (PageRequest)pageRequest);
    }

    private Page<String> getGroupsWithoutPermission(final String groupnamePattern, Predicate<String> groupsWithoutPermissionFilter, PageRequest request) {
        PageProvider<String> groupsProvider = new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return PermissionAdminServiceImpl.this.userService.findGroupsByName(groupnamePattern, request);
            }
        };
        GroupPageFilter groupPageFilter = new GroupPageFilter(groupnamePattern);
        PageRequest pageRequest = request.buildRestrictedPageRequest(this.maxGroups);
        return PageUtils.filterPages((PageProvider)groupsProvider, (Predicate)Predicates.and((Predicate)groupPageFilter, groupsWithoutPermissionFilter), (PageRequest)pageRequest).transform(IdentifierUtils.TO_LOWER_CASE);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<PermittedUser> findUsersWithRepositoryPermission(@Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.RepositoryBuilder)new PermittedUserSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<StashUser> findUsersWithoutRepositoryPermission(@Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        return this.searchUsersLacking((PermittedUserSearchRequest)((PermittedUserSearchRequest.RepositoryBuilder)new PermittedUserSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<PermittedGroup> findGroupsWithRepositoryPermission(@Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroups((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.RepositoryBuilder)new PermittedGroupSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<String> findGroupsWithoutRepositoryPermission(@Nonnull Repository repository, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        return this.searchGroupsLacking((PermittedGroupSearchRequest)((PermittedGroupSearchRequest.RepositoryBuilder)new PermittedGroupSearchRequest.Builder().repository(repository).nameFilter(filter)).build(), pageRequest);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        Permission revoked = this.doRevokeAllGlobalPermissions(group);
        if (revoked != null) {
            this.fireGlobalPermissionRequestedEvent(revoked, null, group, null);
            this.fireGlobalPermissionEvent(revoked, null, group, null);
        }
    }

    private Permission doRevokeAllGlobalPermissions(String group) {
        if (this.permissionService.hasGlobalPermission(group, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("stash.service.permissionadmin.revoke.insufficient.permission", new Object[]{group}));
        }
        Permission revoked = null;
        for (Permission permission : Permission.getGlobalPermissions()) {
            InternalGlobalPermission perm = this.buildPermission(permission, group, null);
            if (!this.globalPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm) || !this.revokeGlobalPermission(permission, group)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGlobalPermissions(@Nonnull StashUser user) {
        CommonValidations.validateUser(user);
        Permission revoked = this.doRevokeAllGlobalPermissions(user);
        if (revoked != null) {
            this.fireGlobalPermissionRequestedEvent(revoked, null, null, user);
            this.fireGlobalPermissionEvent(revoked, null, null, user);
        }
    }

    private Permission doRevokeAllGlobalPermissions(StashUser user) {
        if (this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("stash.service.permissionadmin.revoke.insufficient.permission", new Object[]{user.getDisplayName()}));
        }
        Permission revoked = null;
        for (Permission permission : Permission.getGlobalPermissions()) {
            InternalGlobalPermission perm = this.buildPermission(permission, null, user);
            if (!this.globalPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm) || !this.revokeGlobalPermission(permission, user)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull String group) {
        CommonValidations.validateProject(project);
        CommonValidations.validateGroup(group);
        Permission revoked = this.doRevokeAllProjectPermissions(project, group);
        if (revoked != null) {
            this.fireProjectPermissionRequestedEvent(project, revoked, null, group, null);
            this.fireProjectPermissionEvent(project, revoked, null, group, null);
        }
    }

    private Permission doRevokeAllProjectPermissions(Project project, String group) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Project.class)) {
            if (!this.revokeProjectPermission(permission, project, group)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermissions(@Nonnull Project project, @Nonnull StashUser user) {
        CommonValidations.validateProject(project);
        CommonValidations.validateUser(user);
        Permission revoked = this.doRevokeAllProjectPermissions(project, user);
        if (revoked != null) {
            this.fireProjectPermissionRequestedEvent(project, revoked, null, null, user);
            this.fireProjectPermissionEvent(project, revoked, null, null, user);
        }
    }

    private Permission doRevokeAllProjectPermissions(Project project, StashUser user) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Project.class)) {
            if (!this.revokeProjectPermission(permission, project, user)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void revokeAllRepositoryPermissions(@Nonnull Repository repository, @Nonnull String group) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateGroup(group);
        Permission revoked = this.doRevokeAllRepositoryPermissions(repository, group);
        if (revoked != null) {
            this.fireRepositoryPermissionRequestedEvent(repository, revoked, null, group, null);
            this.fireRepositoryPermissionEvent(repository, revoked, null, group, null);
        }
    }

    private Permission doRevokeAllRepositoryPermissions(Repository repository, String group) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Repository.class)) {
            if (!this.revokeRepositoryPermission(permission, repository, group)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void revokeAllRepositoryPermissions(@Nonnull Repository repository, @Nonnull StashUser user) {
        CommonValidations.validateRepository(repository);
        CommonValidations.validateUser(user);
        Permission revoked = this.doRevokeAllRepositoryPermissions(repository, user);
        if (revoked != null) {
            this.fireRepositoryPermissionRequestedEvent(repository, revoked, null, null, user);
            this.fireRepositoryPermissionEvent(repository, revoked, null, null, user);
        }
    }

    private Permission doRevokeAllRepositoryPermissions(Repository repository, StashUser user) {
        Permission revoked = null;
        for (Permission permission : Permission.getPermissionsOn(Repository.class)) {
            if (!this.revokeRepositoryPermission(permission, repository, user)) continue;
            revoked = Permission.max(revoked, (Permission)permission);
        }
        return revoked;
    }

    @Transactional
    @Secured(value="Permissions checks done internally")
    public void setPermission(@Nonnull SetPermissionRequest request) {
        boolean hasInsufficientPermission;
        Permission permission = request.getPermission();
        Project project = request.getProject();
        Repository repository = request.getRepository();
        boolean hasInsufficientGlobalPermission = permission.isGlobal() && !this.permissionService.hasGlobalPermission(Permission.max((Permission)permission, (Permission)Permission.ADMIN));
        boolean hasInsufficientProjectPermission = permission.isResource(Project.class) && !this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
        boolean hasInsufficientRepositoryPermission = permission.isResource(Repository.class) && !this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN);
        boolean bl = hasInsufficientPermission = hasInsufficientGlobalPermission || hasInsufficientProjectPermission || hasInsufficientRepositoryPermission;
        if (hasInsufficientPermission) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.permissionadmin.usercannotgrantpermission", new Object[]{permission}));
        }
        this.doSetPermission(request);
    }

    private void doSetPermission(@Nonnull SetPermissionRequest request) {
        Permission permission = request.getPermission();
        Project project = request.getProject();
        Repository repository = request.getRepository();
        Set users = request.getUsers();
        Set groups = request.getGroups();
        CommonValidations.validateGrantablePermission(permission);
        if (permission.isGlobal()) {
            Permission revoked;
            for (StashUser user : users) {
                revoked = this.doRevokeAllGlobalPermissions(user);
                this.fireGlobalPermissionRequestedEvent(revoked, permission, null, user);
                this.grantGlobalPermission(permission, user);
                this.fireGlobalPermissionEvent(revoked, permission, null, user);
            }
            for (String group : groups) {
                revoked = this.doRevokeAllGlobalPermissions(group);
                this.fireGlobalPermissionRequestedEvent(revoked, permission, group, null);
                this.grantGlobalPermission(permission, group);
                this.fireGlobalPermissionEvent(revoked, permission, group, null);
            }
        } else if (permission.isResource(Project.class)) {
            Permission revoked;
            for (StashUser user : users) {
                revoked = this.doRevokeAllProjectPermissions(project, user);
                this.fireProjectPermissionRequestedEvent(project, revoked, permission, null, user);
                this.grantPermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
                this.fireProjectPermissionEvent(project, revoked, permission, null, user);
            }
            for (String group : groups) {
                revoked = this.doRevokeAllProjectPermissions(project, group);
                this.fireProjectPermissionRequestedEvent(project, revoked, permission, group, null);
                this.grantPermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).group(group)).build());
                this.fireProjectPermissionEvent(project, revoked, permission, group, null);
            }
        } else if (permission.isResource(Repository.class)) {
            Permission revoked;
            for (StashUser user : users) {
                revoked = this.doRevokeAllRepositoryPermissions(repository, user);
                this.fireRepositoryPermissionRequestedEvent(repository, revoked, permission, null, user);
                this.grantPermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
                this.fireRepositoryPermissionEvent(repository, revoked, permission, null, user);
            }
            for (String group : groups) {
                revoked = this.doRevokeAllRepositoryPermissions(repository, group);
                this.fireRepositoryPermissionRequestedEvent(repository, revoked, permission, group, null);
                this.grantPermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).group(group)).build());
                this.fireRepositoryPermissionEvent(repository, revoked, permission, group, null);
            }
        } else {
            throw new ServerException(this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotgrantunknownpermission", new Object[]{Product.NAME, permission}));
        }
    }

    private PageProvider<StashUser> createUserProvider(final UserType userType, final String usernamePattern) {
        return new PageProvider<StashUser>(){

            public Page<StashUser> get(PageRequest request) {
                return PageUtils.asPageOf(StashUser.class, (Page)(userType == UserType.NORMAL ? PermissionAdminServiceImpl.this.userService.findUsersByName(usernamePattern, request) : PermissionAdminServiceImpl.this.userService.findServiceUsersByName(usernamePattern, request)));
            }
        };
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public boolean hasAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        CommonValidations.validateProject(project);
        return this.projectPermissionDao.hasPermissionEntry((InternalGrantedPermission)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build());
    }

    @Nullable
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN')")
    public Permission getProjectPermission(@Nonnull ProjectPermissionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.projectPermissionDao.getHighestPermissionForUser(request.getUser().getId().intValue(), request.getProject().getId().intValue());
    }

    @Nullable
    @PreAuthorize(value="hasRepositoryPermission(#request.repository, 'REPO_ADMIN')")
    public Permission getRepositoryPermission(@Nonnull RepositoryPermissionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.repositoryPermissionDao.getHighestPermissionForUser(request.getUser().getId().intValue(), request.getRepository().getId().intValue());
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        this.licenseService.validateCanLicenseUser(user, permission);
        InternalGlobalPermission perm = this.buildPermission(permission, null, user);
        this.grantPermission(perm);
    }

    private void grantGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        this.licenseService.validateCanLicenseGroup(group, permission);
        InternalGlobalPermission perm = this.buildPermission(permission, group, null);
        this.grantPermission(perm);
    }

    private void grantPermission(InternalGlobalPermission perm) {
        if (!this.globalPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) {
            this.globalPermissionDao.create((Object)perm);
        }
    }

    private void grantPermission(InternalProjectPermission perm) {
        if (perm.getProject().getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("stash.service.permissionadmin.personalproject.grant", new Object[0]));
        }
        if (!this.projectPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) {
            this.projectPermissionDao.create((Object)perm);
        }
    }

    private void grantPermission(InternalRepositoryPermission perm) {
        if (!this.repositoryPermissionDao.hasPermissionEntry((InternalGrantedPermission)perm)) {
            this.repositoryPermissionDao.create((Object)perm);
        }
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void grantAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        CommonValidations.validateProject(project);
        InternalProjectPermission perm = ((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build();
        this.grantPermission(perm);
    }

    private boolean revokeRepositoryPermission(@Nonnull Permission permission, @Nonnull Repository repository, @Nonnull StashUser user) {
        boolean revokeAllowed;
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedRepositoryPermission(permission, repository);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasRepositoryPermissionThroughGroupMembership(repository, permission, Collections.emptySet());
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cantrevokeownrepositorypermission", new Object[]{repository.getName()});
            throw new IntegrityException(message);
        }
        return this.revokePermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
    }

    private boolean revokeRepositoryPermission(@Nonnull Permission permission, @Nonnull Repository repository, @Nonnull String group) {
        boolean revokeAllowed;
        CommonValidations.validateRepository(repository);
        CommonValidations.validateRepositoryPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup(currentUser, group);
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedRepositoryPermission(permission, repository);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectRepositoryUserPermission(repository, permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasRepositoryPermissionThroughGroupMembership(repository, permission, Collections.singleton(group));
        }
        if (!revokeAllowed) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cantrevokegrouprepositorypermission", new Object[]{repository.getName(), group});
            throw new IntegrityException(message);
        }
        return this.revokePermission(((InternalRepositoryPermission.Builder)((InternalRepositoryPermission.Builder)new InternalRepositoryPermission.Builder().permission(permission)).repository(InternalConverter.convertToInternalRepository((Repository)repository)).group(group)).build());
    }

    private boolean currentUserHasImpliedRepositoryPermission(Permission permission, final Repository repository) {
        return Iterables.any((Iterable)permission.getImplyingPermissions(), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission higherPermission) {
                if (higherPermission.isGlobal()) {
                    return PermissionAdminServiceImpl.this.permissionService.hasGlobalPermission(higherPermission);
                }
                if (higherPermission.isResource(Project.class)) {
                    return PermissionAdminServiceImpl.this.permissionService.hasProjectPermission(repository.getProject(), higherPermission);
                }
                if (higherPermission.isResource(Repository.class)) {
                    return PermissionAdminServiceImpl.this.permissionService.hasRepositoryPermission(repository, higherPermission);
                }
                return false;
            }
        });
    }

    private boolean revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull StashUser user) {
        boolean revokeAllowed;
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.emptySet());
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cantrevokeownprojectpermission", new Object[]{project.getName()});
        throw new IntegrityException(message);
    }

    private boolean revokeProjectPermission(@Nonnull Permission permission, @Nonnull Project project, @Nonnull String group) {
        boolean revokeAllowed;
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup(currentUser, group);
        if (!revokeAllowed) {
            revokeAllowed = this.currentUserHasImpliedProjectPermission(permission, project);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectProjectUserPermission(project, permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasProjectPermissionThroughGroupMembership(project, permission, Collections.singleton(group));
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalProjectPermission.Builder)((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).group(group)).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cantrevokegroupprojectpermission", new Object[]{project.getName(), group});
        throw new IntegrityException(message);
    }

    private boolean currentUserHasImpliedProjectPermission(Permission permission, final Project project) {
        return Iterables.any((Iterable)permission.getImplyingPermissions(), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission higherPermission) {
                if (higherPermission.isGlobal()) {
                    return PermissionAdminServiceImpl.this.permissionService.hasGlobalPermission(higherPermission);
                }
                if (higherPermission.isResource(Project.class)) {
                    return PermissionAdminServiceImpl.this.permissionService.hasProjectPermission(project, higherPermission);
                }
                return false;
            }
        });
    }

    private boolean revokeGlobalPermission(@Nonnull Permission permission, @Nonnull StashUser user) {
        boolean revokeAllowed;
        boolean bl = revokeAllowed = !user.equals(this.authenticationContext.getCurrentUser());
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator i$ = implyingPermissions.iterator();
            while (i$.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)i$.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.emptySet());
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cantrevokeownpermission", new Object[0]);
        throw new IntegrityException(message);
    }

    private boolean revokePermission(InternalGlobalPermission globalPermission) {
        return this.globalPermissionDao.revoke((InternalGrantedPermission)globalPermission) > 0;
    }

    private boolean revokePermission(InternalProjectPermission projectPermission) {
        if (projectPermission.getProject().getType() == ProjectType.PERSONAL) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("stash.service.permissionadmin.personalproject.revoke", new Object[0]));
        }
        return this.projectPermissionDao.revoke((InternalGrantedPermission)projectPermission) > 0;
    }

    private boolean revokePermission(InternalRepositoryPermission repositoryPermission) {
        return this.repositoryPermissionDao.revoke((InternalGrantedPermission)repositoryPermission) > 0;
    }

    private boolean revokeGlobalPermission(@Nonnull Permission permission, @Nonnull String group) {
        boolean revokeAllowed;
        InternalStashUser currentUser = InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser());
        boolean bl = revokeAllowed = currentUser == null || !this.userService.isUserInGroup((StashUser)currentUser, group);
        if (!revokeAllowed) {
            Permission higherPermission;
            Set implyingPermissions = permission.getImplyingPermissions();
            Iterator i$ = implyingPermissions.iterator();
            while (i$.hasNext() && !(revokeAllowed = this.permissionService.hasGlobalPermission(higherPermission = (Permission)i$.next()))) {
            }
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasDirectGlobalUserPermission(permission);
        }
        if (!revokeAllowed) {
            revokeAllowed = this.permissionService.hasGlobalPermissionThroughGroupMembership(permission, Collections.singleton(group));
        }
        if (revokeAllowed) {
            return this.revokePermission(((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).group(group)).build());
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cantrevokegrouppermission", new Object[]{group});
        throw new IntegrityException(message);
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void revokeAllProjectPermission(@Nonnull Permission permission, @Nonnull Project project) {
        CommonValidations.validateProjectPermission(permission);
        CommonValidations.validateGrantablePermission(permission);
        CommonValidations.validateProject(project);
        boolean revoked = this.revokePermission(((InternalProjectPermission.Builder)new InternalProjectPermission.Builder().permission(permission)).project(InternalConverter.convertToInternalProject((Project)project)).build());
        if (revoked) {
            this.fireProjectPermissionRequestedEvent(project, permission, null, null, null);
            this.fireProjectPermissionEvent(project, permission, null, null, null);
        }
    }

    @Transactional
    @PreAuthorize(value="not isCurrentUser(#username) and (hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN')))")
    public void revokeAllUserPermissions(@Nonnull String username) {
        CommonValidations.validateUser(username);
        StashUser user = this.userService.getUserByName(username, true);
        if (user != null) {
            this.revokeAllUserPermissions(user);
        }
    }

    @Transactional
    @PreAuthorize(value="not isCurrentUser(#user) and (hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN')))")
    public void revokeAllUserPermissions(@Nonnull StashUser user) {
        Preconditions.checkNotNull((Object)user);
        this.globalPermissionDao.revokeAll(user.getId().intValue());
        this.projectPermissionDao.revokeAll(user.getId().intValue());
        this.repositoryPermissionDao.revokeAll(user.getId().intValue());
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void revokeAllGroupPermissions(@Nonnull String name) {
        CommonValidations.validateGroup(name);
        this.canRemovePermissionsFromGroup(name);
        this.globalPermissionDao.revokeAll(name);
        this.projectPermissionDao.revokeAll(name);
        this.repositoryPermissionDao.revokeAll(name);
    }

    private void canRemovePermissionsFromGroup(String name) {
        try {
            this.canDeleteGroup(name);
        }
        catch (IntegrityException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotremovepermissionsgroup", new Object[0]);
            throw new IntegrityException(message);
        }
        catch (ForbiddenException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotdeletegroup", new Object[]{"You cannot remove the permissions of the group {0} as it has System Administrator privileges, and you are not a System Administrator.", name});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canRemoveUserFromGroup(@Nonnull String username, @Nonnull String group) {
        CommonValidations.validateUser(username);
        CommonValidations.validateGroup(group);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            if (!this.userService.isUserInGroup(currentUser, group)) {
                return;
            }
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotremoveself", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotremoveuser", new Object[]{username, group});
            throw new ForbiddenException(message);
        }
    }

    private boolean canRemoveCurrentUserFromGroup(String group) {
        return !(this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group) ? !this.permissionService.hasDirectGlobalUserPermission(Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.SYS_ADMIN, Collections.singleton(group)) : this.permissionService.hasGlobalGroupPermission(Permission.ADMIN, group) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && !this.permissionService.hasDirectGlobalUserPermission(Permission.ADMIN) && !this.permissionService.hasGlobalPermissionThroughGroupMembership(Permission.ADMIN, Collections.singleton(group)));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canAddUserToGroup(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotaddusertogroup", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteGroup(@Nonnull String group) {
        CommonValidations.validateGroup(group);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && this.userService.isUserInGroup(currentUser, group)) {
            if (!this.canRemoveCurrentUserFromGroup(group)) {
                KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotremovegroup", new Object[0]);
                throw new IntegrityException(message);
            }
        } else if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalGroupPermission(Permission.SYS_ADMIN, group)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotdeletegroup", new Object[]{group});
            throw new ForbiddenException(message);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void canDeleteUser(@Nonnull String username) {
        CommonValidations.validateUser(username);
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && IdentifierUtils.equalsInLowerCase((String)currentUser.getName(), (String)username)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.selfdelete", new Object[0]);
            throw new IntegrityException(message);
        }
        StashUser user = this.userService.getUserByName(username);
        if (user == null) {
            return;
        }
        if (this.permissionService.hasGlobalPermission(user, Permission.SYS_ADMIN) && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.permissionadmin.cannotdeleteuser", new Object[]{user.getName()});
            throw new ForbiddenException(message);
        }
    }

    @EventListener
    public void onGroupDeleted(GroupCleanupEvent event) {
        this.globalPermissionDao.revokeAll(event.getGroup());
        this.projectPermissionDao.revokeAll(event.getGroup());
        this.repositoryPermissionDao.revokeAll(event.getGroup());
    }

    @EventListener
    public void onUserDeleted(UserCleanupEvent event) {
        this.globalPermissionDao.revokeAll(event.getDeletedUser().getId().intValue());
        this.projectPermissionDao.revokeAll(event.getDeletedUser().getId().intValue());
        this.repositoryPermissionDao.revokeAll(event.getDeletedUser().getId().intValue());
    }

    private InternalGlobalPermission buildPermission(Permission permission, String group, StashUser user) {
        return ((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(permission)).user(InternalConverter.convertToInternalUser((StashUser)user))).group(group)).build();
    }

    private void fireGlobalPermissionEvent(final Permission oldValue, final Permission newValue, final String group, final StashUser user) {
        this.eventPublisher.publish((Object)PermissionAdminServiceImpl.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<PermissionEvent>(){

            @Override
            public GlobalPermissionGrantedEvent visitPermissionGranted() {
                return new GlobalPermissionGrantedEvent((Object)PermissionAdminServiceImpl.this, newValue, group, user);
            }

            @Override
            public GlobalPermissionModifiedEvent visitPermissionModified() {
                return new GlobalPermissionModifiedEvent((Object)PermissionAdminServiceImpl.this, oldValue, newValue, group, user);
            }

            @Override
            public GlobalPermissionRevokedEvent visitPermissionRevoked() {
                return new GlobalPermissionRevokedEvent((Object)PermissionAdminServiceImpl.this, oldValue, group, user);
            }
        }));
    }

    private void fireGlobalPermissionRequestedEvent(final Permission oldValue, final Permission newValue, final String group, final StashUser user) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)PermissionAdminServiceImpl.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<PermissionEvent>(){

            @Override
            public GlobalPermissionGrantRequestedEvent visitPermissionGranted() {
                return new GlobalPermissionGrantRequestedEvent((Object)PermissionAdminServiceImpl.this, newValue, group, user, (CancelState)cancelState);
            }

            @Override
            public GlobalPermissionModificationRequestedEvent visitPermissionModified() {
                return new GlobalPermissionModificationRequestedEvent((Object)PermissionAdminServiceImpl.this, oldValue, newValue, group, user, (CancelState)cancelState);
            }

            @Override
            public GlobalPermissionRevocationRequestedEvent visitPermissionRevoked() {
                return new GlobalPermissionRevocationRequestedEvent((Object)PermissionAdminServiceImpl.this, oldValue, group, user, (CancelState)cancelState);
            }
        }));
        this.maybeCancelRequest(oldValue, newValue, cancelState);
    }

    private void fireProjectPermissionEvent(final Project project, final Permission oldValue, final Permission newValue, final String group, final StashUser user) {
        this.eventPublisher.publish((Object)PermissionAdminServiceImpl.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<ProjectPermissionEvent>(){

            @Override
            public ProjectPermissionGrantedEvent visitPermissionGranted() {
                return new ProjectPermissionGrantedEvent((Object)PermissionAdminServiceImpl.this, newValue, project, group, user);
            }

            @Override
            public ProjectPermissionModifiedEvent visitPermissionModified() {
                return new ProjectPermissionModifiedEvent((Object)PermissionAdminServiceImpl.this, oldValue, newValue, project, group, user);
            }

            @Override
            public ProjectPermissionRevokedEvent visitPermissionRevoked() {
                return new ProjectPermissionRevokedEvent((Object)PermissionAdminServiceImpl.this, oldValue, project, group, user);
            }
        }));
    }

    private void fireProjectPermissionRequestedEvent(final Project project, final Permission oldValue, final Permission newValue, final String group, final StashUser user) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)PermissionAdminServiceImpl.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<PermissionEvent>(){

            @Override
            public ProjectPermissionGrantRequestedEvent visitPermissionGranted() {
                return new ProjectPermissionGrantRequestedEvent((Object)PermissionAdminServiceImpl.this, newValue, project, group, user, (CancelState)cancelState);
            }

            @Override
            public ProjectPermissionModificationRequestedEvent visitPermissionModified() {
                return new ProjectPermissionModificationRequestedEvent((Object)PermissionAdminServiceImpl.this, oldValue, newValue, project, group, user, (CancelState)cancelState);
            }

            @Override
            public ProjectPermissionRevocationRequestedEvent visitPermissionRevoked() {
                return new ProjectPermissionRevocationRequestedEvent((Object)PermissionAdminServiceImpl.this, oldValue, project, group, user, (CancelState)cancelState);
            }
        }));
        this.maybeCancelRequest(oldValue, newValue, cancelState);
    }

    private void fireRepositoryPermissionEvent(final Repository repository, final Permission oldValue, final Permission newValue, final String group, final StashUser user) {
        this.eventPublisher.publish((Object)PermissionAdminServiceImpl.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<RepositoryPermissionEvent>(){

            @Override
            public RepositoryPermissionGrantedEvent visitPermissionGranted() {
                return new RepositoryPermissionGrantedEvent((Object)PermissionAdminServiceImpl.this, newValue, repository, group, user);
            }

            @Override
            public RepositoryPermissionModifiedEvent visitPermissionModified() {
                return new RepositoryPermissionModifiedEvent((Object)PermissionAdminServiceImpl.this, oldValue, newValue, repository, group, user);
            }

            @Override
            public RepositoryPermissionRevokedEvent visitPermissionRevoked() {
                return new RepositoryPermissionRevokedEvent((Object)PermissionAdminServiceImpl.this, oldValue, repository, group, user);
            }
        }));
    }

    private void fireRepositoryPermissionRequestedEvent(final Repository repository, final Permission oldValue, final Permission newValue, final String group, final StashUser user) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)PermissionAdminServiceImpl.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<RepositoryPermissionEvent>(){

            @Override
            public RepositoryPermissionGrantRequestedEvent visitPermissionGranted() {
                return new RepositoryPermissionGrantRequestedEvent((Object)PermissionAdminServiceImpl.this, newValue, repository, group, user, (CancelState)cancelState);
            }

            @Override
            public RepositoryPermissionModificationRequestedEvent visitPermissionModified() {
                return new RepositoryPermissionModificationRequestedEvent((Object)PermissionAdminServiceImpl.this, oldValue, newValue, repository, group, user, (CancelState)cancelState);
            }

            @Override
            public RepositoryPermissionRevocationRequestedEvent visitPermissionRevoked() {
                return new RepositoryPermissionRevocationRequestedEvent((Object)PermissionAdminServiceImpl.this, oldValue, repository, group, user, (CancelState)cancelState);
            }
        }));
        this.maybeCancelRequest(oldValue, newValue, cancelState);
    }

    private void maybeCancelRequest(Permission oldValue, Permission newValue, final SimpleCancelState cancelState) {
        if (cancelState.isCanceled()) {
            throw PermissionAdminServiceImpl.visitPermissionAction(oldValue, newValue, new PermissionActionVisitor<RequestCanceledException>(){

                @Override
                public PermissionGrantCanceledException visitPermissionGranted() {
                    return new PermissionGrantCanceledException(PermissionAdminServiceImpl.this.i18nService.getKeyedText("stash.service.permissionadmin.grantcanceled", "Permission grant canceled", new Object[0]), cancelState.getCancelMessages());
                }

                @Override
                public PermissionModificationCanceledException visitPermissionModified() {
                    return new PermissionModificationCanceledException(PermissionAdminServiceImpl.this.i18nService.getKeyedText("stash.service.permissionadmin.modificationcanceled", "Permission modification canceled", new Object[0]), cancelState.getCancelMessages());
                }

                @Override
                public PermissionRevocationCanceledException visitPermissionRevoked() {
                    return new PermissionRevocationCanceledException(PermissionAdminServiceImpl.this.i18nService.getKeyedText("stash.service.permissionadmin.revocationcanceled", "Permission revocation canceled", new Object[0]), cancelState.getCancelMessages());
                }
            });
        }
    }

    @VisibleForTesting
    static Predicate<String> withoutGroups(PageProvider<String> provider) {
        return Predicates.not(new InIteratorPredicate<String>(CASE_INSENSITIVE_COMPARATOR, new PagedIterable(provider, 500).iterator()));
    }

    @VisibleForTesting
    static Predicate<StashUser> withoutUsers(PageProvider<StashUser> provider) {
        return Predicates.not(new InIteratorPredicate<StashUser>(CASE_INSENSITIVE_NAME_COMPARATOR, new PagedIterable(provider, 500).iterator()));
    }

    private <R> R validateRequest(R request) {
        return (R)Preconditions.checkNotNull(request, (Object)"request");
    }

    private IllegalArgumentException throwBadRequestType(Object request) {
        return new IllegalArgumentException("Unexpected request type: " + request.getClass().getName());
    }

    private static <T> T visitPermissionAction(Permission existingPermission, Permission newPermission, PermissionActionVisitor<T> visitor) {
        if (existingPermission == null) {
            return visitor.visitPermissionGranted();
        }
        if (newPermission == null) {
            return visitor.visitPermissionRevoked();
        }
        return visitor.visitPermissionModified();
    }

    private static interface PermissionActionVisitor<T> {
        public T visitPermissionGranted();

        public T visitPermissionModified();

        public T visitPermissionRevoked();
    }
}

