/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.internal.locale.DefaultLocaleService;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalStashAuthenticationContext;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalUserLocaleService;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.user.StashUser;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=InternalUserLocaleService.class)
@Service(value="userLocaleService")
public class DefaultUserLocaleService
implements InternalUserLocaleService {
    private final InternalStashAuthenticationContext authenticationContext;
    private final StashUserDao userDao;

    @Autowired
    public DefaultUserLocaleService(StashUserDao userDao, InternalStashAuthenticationContext authenticationContext) {
        this.userDao = userDao;
        this.authenticationContext = authenticationContext;
    }

    @Transactional
    public void setLocale(@Nonnull StashUser user, @Nullable Locale locale) throws ServerException {
        InternalNormalUser normalUser = DefaultLocaleService.getNormalUser((StashUser)user);
        if (normalUser != null) {
            InternalStashUser updatedUser = (InternalStashUser)this.userDao.update((Object)new InternalNormalUser.Builder(normalUser).locale(locale).build());
            StashUser currentUser = this.authenticationContext.getCurrentUser();
            if (currentUser != null && user.getId() != null && user.getId().equals(currentUser.getId())) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)this.authenticationContext.getCurrentToken().copyWithUser((StashUser)updatedUser));
            }
        }
    }

    @Nullable
    public Locale getLocale(@Nullable StashUser stashUser) {
        InternalNormalUser user = DefaultLocaleService.getNormalUser((StashUser)stashUser);
        return user != null ? user.getLocale() : null;
    }
}

