/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Pair;
import com.atlassian.stash.event.ProjectDeletedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.event.permission.PermissionEvent;
import com.atlassian.stash.event.permission.ProjectPermissionEvent;
import com.atlassian.stash.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.stash.event.user.GroupCleanupEvent;
import com.atlassian.stash.event.user.UserCleanupEvent;
import com.atlassian.stash.internal.user.DefaultPermissionGraph;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.internal.user.PermissionGraphFactory;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.AbstractStashUserVisitor;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.ServiceUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserVisitor;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="permissionGraphFactory")
public class CachingPermissionGraphFactory
implements PermissionGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(CachingPermissionGraphFactory.class);
    private volatile long cacheInvalidationCount;
    private volatile DefaultPermissionGraph defaultPermissions;
    private final EffectivePermissionDao effectivePermissionDao;
    private final Cache<String, DefaultPermissionGraph> groupPermissions;
    private int maxGrantedPermissionsPageSize;
    private final ProjectPermissionDao projectPermissionDao;
    private final TransactionTemplate transactionTemplate;
    private final Cache<Integer, DefaultPermissionGraph> userPermissions;
    private final UserService userService;

    @Autowired
    public CachingPermissionGraphFactory(final EffectivePermissionDao effectivePermissionDao, ProjectPermissionDao projectPermissionDao, PlatformTransactionManager transactionManager, UserService userService, @Value(value="${permissions.cache.groups.max}") int maxCachedGroupPermissions, @Value(value="${permissions.cache.users.max}") int maxCachedUserPermissions) {
        this.effectivePermissionDao = effectivePermissionDao;
        this.projectPermissionDao = projectPermissionDao;
        this.userService = userService;
        this.maxGrantedPermissionsPageSize = 1000;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setReadOnly(true);
        this.groupPermissions = CacheBuilder.newBuilder().maximumSize(maxCachedGroupPermissions).build((CacheLoader)new CacheLoader<String, DefaultPermissionGraph>(){

            public DefaultPermissionGraph load(String key) throws Exception {
                throw new UnsupportedOperationException("Unexpected use of cache loader for group permissions");
            }
        });
        this.userPermissions = CacheBuilder.newBuilder().maximumSize(maxCachedUserPermissions).build((CacheLoader)new CacheLoader<Integer, DefaultPermissionGraph>(){

            public DefaultPermissionGraph load(final Integer key) throws Exception {
                return new DefaultPermissionGraph.Builder().addAll((Iterable<? extends InternalGrantedPermission>)new PagedIterable((PageProvider)new PageProvider<InternalGrantedPermission>(){

                    public Page<InternalGrantedPermission> get(PageRequest request) {
                        return effectivePermissionDao.findByUserId(key, request);
                    }
                }, CachingPermissionGraphFactory.this.maxGrantedPermissionsPageSize)).build();
            }
        });
    }

    @Nonnull
    public PermissionGraph createGraph(@Nonnull StashUser user) {
        return new RecalculatingPermissionGraph(user);
    }

    @PostConstruct
    public void initialize() {
        this.defaultPermissions = (DefaultPermissionGraph)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<DefaultPermissionGraph>(){

            public DefaultPermissionGraph doInTransaction(TransactionStatus transactionStatus) {
                PagedIterable defaultPermissions = new PagedIterable((PageProvider)new PageProvider<InternalProjectPermission>(){

                    public Page<InternalProjectPermission> get(PageRequest request) {
                        return CachingPermissionGraphFactory.this.projectPermissionDao.findDefaultPermissions(request);
                    }
                }, CachingPermissionGraphFactory.this.maxGrantedPermissionsPageSize);
                return new DefaultPermissionGraph.Builder().addAll((Iterable<? extends InternalGrantedPermission>)defaultPermissions).build();
            }
        });
    }

    @EventListener
    public void onGroupCleanup(GroupCleanupEvent event) {
        this.invalidate(this.groupPermissions, event.getGroup());
    }

    @EventListener
    public void onPermissionsChanged(PermissionEvent event) {
        StashUser user = event.getAffectedUser();
        String group = event.getAffectedGroup();
        if (user != null) {
            this.invalidate(this.userPermissions, user.getId());
        } else if (StringUtils.isNotBlank((String)group)) {
            this.invalidate(this.groupPermissions, group);
        } else if (event instanceof ProjectPermissionEvent) {
            this.updateDefaultPermission(((ProjectPermissionEvent)event).getProject(), event instanceof ProjectPermissionGrantedEvent ? event.getPermission() : null);
        }
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.updateDefaultPermission(event.getProject(), null);
        this.invalidateAll(this.userPermissions);
        this.invalidateAll(this.groupPermissions);
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.invalidateAll(this.userPermissions);
        this.invalidateAll(this.groupPermissions);
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        StashUser deletedUser = event.getDeletedUser();
        if (deletedUser != null) {
            this.invalidate(this.userPermissions, deletedUser.getId());
        }
    }

    @Value(value="${page.max.granted.permissions}")
    public void setMaxGrantedPermissionsPageSize(int maxGrantedPermissionsPageSize) {
        this.maxGrantedPermissionsPageSize = maxGrantedPermissionsPageSize;
    }

    private PageRequest createPage1Request() {
        return PageUtils.newRequest((int)0, (int)this.maxGrantedPermissionsPageSize);
    }

    private Iterable<String> getGroups(final StashUser user) {
        Preconditions.checkArgument((user.getType() == UserType.NORMAL ? 1 : 0) != 0, (Object)"only normal users have groups");
        return new PagedIterable((PageProvider)new PageProvider<String>(){

            public Page<String> get(PageRequest request) {
                return CachingPermissionGraphFactory.this.userService.findGroupsByUser(user.getName(), request);
            }
        }, this.createPage1Request());
    }

    private DefaultPermissionGraph getGroupsPermissions(Iterable<String> groups) {
        ConcurrentMap groupPermissionsMap = this.groupPermissions.asMap();
        DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder();
        final HashSet missingGroups = Sets.newHashSet();
        for (String group : groups) {
            DefaultPermissionGraph groupPerms = (DefaultPermissionGraph)groupPermissionsMap.get(group);
            if (groupPerms != null) {
                builder.addAll(groupPerms);
                continue;
            }
            missingGroups.add(group);
        }
        if (!missingGroups.isEmpty()) {
            String curGroup = null;
            DefaultPermissionGraph.Builder groupPermBuilder = null;
            PagedIterable permissions = new PagedIterable((PageProvider)new PageProvider<InternalGrantedPermission>(){

                public Page<InternalGrantedPermission> get(PageRequest request) {
                    return CachingPermissionGraphFactory.this.effectivePermissionDao.findByGroup((Iterable)missingGroups, request);
                }
            }, this.maxGrantedPermissionsPageSize);
            for (InternalGrantedPermission permission : permissions) {
                if (!permission.getGroup().equals(curGroup)) {
                    if (groupPermBuilder != null) {
                        groupPermissionsMap.put(curGroup, groupPermBuilder.build());
                    }
                    curGroup = permission.getGroup();
                    groupPermBuilder = new DefaultPermissionGraph.Builder();
                }
                builder.add(permission);
                groupPermBuilder.add(permission);
            }
            if (groupPermBuilder != null) {
                groupPermissionsMap.put(curGroup, groupPermBuilder.build());
            }
        }
        return builder.build();
    }

    private DefaultPermissionGraph getUserPermissions(Integer userId) {
        return (DefaultPermissionGraph)this.userPermissions.getUnchecked((Object)userId);
    }

    public boolean cacheInvalidatedSince(long count) {
        return this.cacheInvalidationCount != count;
    }

    private synchronized void updateDefaultPermission(Project project, Permission newPermission) {
        DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder().addAll(this.defaultPermissions).clearAll(project);
        if (newPermission != null) {
            builder.add(newPermission, project.getId());
        }
        this.defaultPermissions = builder.build();
    }

    private <K, V> void invalidate(Cache<K, V> cache, K key) {
        cache.invalidate(key);
        this.markCacheInvalidation();
    }

    private <K, V> void invalidateAll(Cache<K, V> cache) {
        cache.invalidateAll();
        this.markCacheInvalidation();
    }

    private void markCacheInvalidation() {
        ++this.cacheInvalidationCount;
    }

    private class ServiceUserPermissionGraphCalculator
    implements PermissionGraphCalculator {
        private final ServiceUser user;

        private ServiceUserPermissionGraphCalculator(ServiceUser user) {
            this.user = user;
        }

        @Override
        public PermissionGraph calculate() {
            return new DefaultPermissionGraph.Builder().addAll(CachingPermissionGraphFactory.this.getUserPermissions(this.user.getId())).add(Permission.LICENSED_USER, null).build();
        }
    }

    private class NormalUserPermissionGraphCalculator
    implements PermissionGraphCalculator {
        private final StashUser user;

        private NormalUserPermissionGraphCalculator(StashUser user) {
            this.user = user;
        }

        @Override
        public PermissionGraph calculate() {
            return new DefaultPermissionGraph.Builder().addAll(CachingPermissionGraphFactory.this.defaultPermissions).addAll(CachingPermissionGraphFactory.this.getGroupsPermissions(CachingPermissionGraphFactory.this.getGroups(this.user))).addAll(CachingPermissionGraphFactory.this.getUserPermissions(this.user.getId())).build();
        }
    }

    private class RecalculatingPermissionGraph
    implements PermissionGraph {
        private final PermissionGraphCalculator calculator;
        private final StashUser user;
        private volatile Pair<PermissionGraph, Long> graphAndTimestamp;

        private RecalculatingPermissionGraph(StashUser stashUser) {
            this.user = stashUser;
            this.calculator = this.newCalculatorForUserType(stashUser);
            this.graphAndTimestamp = this.recalculate();
        }

        public boolean isGranted(Permission permission, @Nullable Object resource) {
            if (CachingPermissionGraphFactory.this.cacheInvalidatedSince((Long)this.graphAndTimestamp.right())) {
                log.debug("Permission graph for user {} has expired and will be recalculated", (Object)this.user.getName());
                this.graphAndTimestamp = this.recalculate();
            }
            return ((PermissionGraph)this.graphAndTimestamp.left()).isGranted(permission, resource);
        }

        private PermissionGraphCalculator newCalculatorForUserType(StashUser stashUser) {
            return (PermissionGraphCalculator)stashUser.accept((StashUserVisitor)new AbstractStashUserVisitor<PermissionGraphCalculator>(){

                public PermissionGraphCalculator visit(@Nonnull DetailedUser user) {
                    return this.visit((StashUser)user);
                }

                public PermissionGraphCalculator visit(@Nonnull ServiceUser user) {
                    return new ServiceUserPermissionGraphCalculator(user);
                }

                public PermissionGraphCalculator visit(@Nonnull StashUser user) {
                    return new NormalUserPermissionGraphCalculator(user);
                }
            });
        }

        private Pair<PermissionGraph, Long> recalculate() {
            return Pair.pair((Object)this.calculator.calculate(), (Object)CachingPermissionGraphFactory.this.cacheInvalidationCount);
        }
    }

    private static interface PermissionGraphCalculator {
        public PermissionGraph calculate();
    }
}

