/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.TicketAcquiredEvent;
import com.atlassian.stash.event.TicketRejectedEvent;
import com.atlassian.stash.event.TicketReleasedEvent;
import com.atlassian.stash.event.request.RequestEndedEvent;
import com.atlassian.stash.exception.NoSuchResourceException;
import com.atlassian.stash.exception.ResourceBusyException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.throttle.AbstractTicket;
import com.atlassian.stash.internal.throttle.InternalThrottleService;
import com.atlassian.stash.internal.throttle.SemaphoreTicketBucket;
import com.atlassian.stash.throttle.ThrottleService;
import com.atlassian.stash.throttle.Ticket;
import com.atlassian.stash.util.PropertiesUtils;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ThrottleService.class)
@Service(value="throttleService")
public class SemaphoreThrottleService
implements InternalThrottleService,
StatefulService {
    public static final String RESOURCE_PREFIX = "throttle.resource.";
    private static final Logger log = LoggerFactory.getLogger(SemaphoreThrottleService.class);
    private final Map<String, SemaphoreTicketBucket> buckets;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final Properties properties;
    private final ThreadLocal<StubTicket> tickets;

    @Autowired
    public SemaphoreThrottleService(EventPublisher eventPublisher, I18nService i18nService, @Qualifier(value="applicationProperties") Properties properties) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.properties = properties;
        this.buckets = Maps.newHashMap();
        this.tickets = new ThreadLocal();
    }

    @Nonnull
    public Ticket acquireTicket(@Nonnull String resourceName) {
        StubTicket ticket = this.tickets.get();
        if (ticket == null) {
            SemaphoreTicketBucket bucket = this.getBucket(resourceName);
            if (bucket.tryAcquireTicket()) {
                log.trace("Acquired ticket for resource [{}]", (Object)resourceName);
                ticket = new SemaphoreTicket(resourceName);
                this.eventPublisher.publish((Object)new TicketAcquiredEvent((Object)this, resourceName));
                this.tickets.set(ticket);
            } else {
                this.eventPublisher.publish((Object)new TicketRejectedEvent((Object)this, resourceName));
                KeyedMessage message = this.i18nService.createKeyedMessage("stash.resource.busy", new Object[0]);
                throw new ResourceBusyException(message, resourceName);
            }
        }
        ticket.acquire();
        return ticket;
    }

    public void cleanupTickets() {
        StubTicket ticket = this.tickets.get();
        if (ticket != null) {
            ticket.closeNow();
        }
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new TicketState(this.tickets.get());
    }

    public long getTimeSinceLastRejectedTicketRequest(String resourceName) {
        long lastRejectedTimestamp = this.getBucket(resourceName).getLastRejectedTimestamp();
        return lastRejectedTimestamp == 0L ? 0L : System.currentTimeMillis() - lastRejectedTimestamp;
    }

    public long getLongestQueueingTimeForCurrentTicketRequests(String resourceName) {
        long earliestQueuingTime = this.getBucket(resourceName).getEarliestQueuingTime();
        return earliestQueuingTime == 0L ? 0L : System.currentTimeMillis() - earliestQueuingTime;
    }

    @PostConstruct
    public void initialise() {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String propertyName = (String)names.nextElement();
            if (!propertyName.startsWith(RESOURCE_PREFIX) || propertyName.endsWith(".timeout")) continue;
            String bucketName = propertyName.substring(RESOURCE_PREFIX.length());
            int tickets = this.parseBucketLimit(bucketName, this.properties.getProperty(propertyName));
            int timeoutSeconds = Integer.parseInt(this.properties.getProperty(propertyName + ".timeout", "0"));
            log.debug("Configured resource [{}] with {} tickets and an acquire timeout of {} s", new Object[]{bucketName, tickets, timeoutSeconds});
            this.buckets.put(bucketName, new SemaphoreTicketBucket(tickets, timeoutSeconds, TimeUnit.SECONDS));
        }
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent event) {
        this.cleanupTickets();
    }

    protected SemaphoreTicketBucket getBucket(String resourceName) {
        SemaphoreTicketBucket ticketBucket = this.buckets.get(resourceName);
        if (ticketBucket == null) {
            throw this.noSuchResource(resourceName, true);
        }
        return ticketBucket;
    }

    private NoSuchResourceException noSuchResource(String resourceName, boolean logThrowing) {
        KeyedMessage message = this.i18nService.createKeyedMessage("stash.resource.not.configured", new Object[]{resourceName});
        if (logThrowing) {
            log.error(message.getRootMessage());
        }
        return new NoSuchResourceException(message, resourceName);
    }

    private int parseBucketLimit(String resourceName, String expression) {
        int result = PropertiesUtils.parseExpression((String)expression, (int)-1);
        if (result == -1) {
            result = (int)Math.round((double)Runtime.getRuntime().availableProcessors() * 1.5);
            log.warn("The configured resource limit for " + resourceName + " '" + expression + "' is invalid. Only (floating point) numbers, +, -, /, *, (, ) and cpu are supported. " + "Falling back to defaultValue: " + result);
        }
        return result;
    }

    int getNumberOfPermits(String resourceName) {
        return this.getBucket(resourceName).getNumberOfPermits();
    }

    private final class TicketState
    implements TransferableState {
        private final StubTicket state;

        public TicketState(StubTicket state) {
            if (state != null) {
                state = new StubTicket(state.getResourceName());
                state.acquire();
            }
            this.state = state;
        }

        public void apply() {
            SemaphoreThrottleService.this.tickets.set(this.state);
        }

        public void remove() {
            SemaphoreThrottleService.this.cleanupTickets();
        }
    }

    @NotThreadSafe
    private class StubTicket
    extends AbstractTicket {
        private final AtomicInteger count;

        private StubTicket(String resourceName) {
            super(resourceName);
            this.count = new AtomicInteger(0);
        }

        public void acquire() {
            this.count.incrementAndGet();
        }

        public void close() {
            this.closeIf(new Predicate<Ticket>(){

                public boolean apply(Ticket input) {
                    return StubTicket.this.count.decrementAndGet() == 0;
                }
            });
        }

        @Deprecated
        public void release() {
            this.close();
        }

        protected void onRelease() {
            log.trace("Released ticket for resource [{}]", (Object)this.resourceName);
            SemaphoreThrottleService.this.tickets.remove();
        }

        protected void onRetain() {
            log.trace("Not releasing ticket for resource [{}]; {} acquire(s) remain", (Object)this.resourceName, (Object)this.count.get());
        }

        private void closeIf(Predicate<Ticket> predicate) {
            Ticket removed = (Ticket)SemaphoreThrottleService.this.tickets.get();
            if (removed == this) {
                if (predicate.apply((Object)removed)) {
                    this.onRelease();
                } else {
                    this.onRetain();
                }
            } else {
                throw new IllegalStateException("Attempted to release a ticket for resource [" + this.resourceName + "] on a thread which did not own it");
            }
        }

        private void closeNow() {
            this.closeIf((Predicate<Ticket>)Predicates.alwaysTrue());
        }
    }

    @NotThreadSafe
    private final class SemaphoreTicket
    extends StubTicket {
        private SemaphoreTicket(String resourceName) {
            super(resourceName);
        }

        @Override
        protected void onRelease() {
            super.onRelease();
            ((SemaphoreTicketBucket)SemaphoreThrottleService.this.buckets.get(this.resourceName)).release();
            SemaphoreThrottleService.this.eventPublisher.publish((Object)new TicketReleasedEvent((Object)SemaphoreThrottleService.this, this.resourceName));
        }
    }
}

