/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.server.InternalApplicationStatusService;
import com.atlassian.stash.internal.throttle.InternalThrottleService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.server.ApplicationState;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="applicationStatusService")
public class DefaultApplicationStatusService
implements InternalApplicationStatusService {
    private final JohnsonEventContainer johnsonEventContainer;
    private final ApplicationPropertiesService propertiesService;
    private final Iterable<String> resourceNames;
    private final InternalThrottleService throttleService;
    private long serverBusyMessageTimeout;
    private long serverBusyQueueTime;
    private volatile ApplicationState state;

    @Autowired
    public DefaultApplicationStatusService(ApplicationPropertiesService propertiesService, InternalThrottleService throttleService, ServletContext servletContext) {
        this.propertiesService = propertiesService;
        this.throttleService = throttleService;
        this.resourceNames = Collections.singleton("scm-hosting");
        this.johnsonEventContainer = Johnson.getEventContainer((ServletContext)servletContext);
        this.state = ApplicationState.STARTING;
    }

    @Unsecured(value="can be called anonymously")
    public ApplicationState getState() {
        ApplicationState current = this.state;
        if (current == ApplicationState.STOPPING) {
            return current;
        }
        if (this.johnsonEventContainer != null && this.johnsonEventContainer.hasEvents()) {
            for (Event event : this.johnsonEventContainer.getEvents()) {
                String level = event.getLevel().getLevel();
                if ("error".equals(level) || "fatal".equals(level)) {
                    return ApplicationState.ERROR;
                }
                if (!"maintenance".equals(level) && !"system-maintenance".equals(level)) continue;
                return ApplicationState.MAINTENANCE;
            }
        }
        if (current == ApplicationState.RUNNING && !this.propertiesService.isSetup()) {
            return ApplicationState.FIRST_RUN;
        }
        return current;
    }

    @Unsecured(value="can be called anonymously")
    public boolean hasRecentlyRejectedRequests() {
        if (this.serverBusyMessageTimeout < 1L) {
            return false;
        }
        long timeSinceLastRejection = 0L;
        for (String resource : this.resourceNames) {
            long resourceTime = this.throttleService.getTimeSinceLastRejectedTicketRequest(resource);
            if (resourceTime <= timeSinceLastRejection) continue;
            timeSinceLastRejection = resourceTime;
        }
        return timeSinceLastRejection != 0L && timeSinceLastRejection < this.serverBusyMessageTimeout;
    }

    @Unsecured(value="can be called anonymously")
    public boolean isQueueingRequests() {
        if (this.serverBusyQueueTime < 1L) {
            return false;
        }
        long longestQueuingTime = 0L;
        for (String resource : this.resourceNames) {
            long resourceTime = this.throttleService.getLongestQueueingTimeForCurrentTicketRequests(resource);
            if (resourceTime <= longestQueuingTime) continue;
            longestQueuingTime = resourceTime;
        }
        if (longestQueuingTime == 0L) {
            return false;
        }
        return longestQueuingTime > this.serverBusyQueueTime;
    }

    @PluginEventListener
    public void onStart(PluginFrameworkStartedEvent event) {
        this.state = ApplicationState.RUNNING;
    }

    @Value(value="${server.busy.on.queue.time}")
    public void setServerBusyQueueTime(long serverBusyQueueTime) {
        this.setServerBusyQueueTime(serverBusyQueueTime, TimeUnit.SECONDS);
    }

    @Value(value="${server.busy.on.ticket.rejected.within}")
    public void setServerBusyMessageTimeout(long resourceBusyMessageTimeout) {
        this.serverBusyMessageTimeout = TimeUnit.MINUTES.toMillis(resourceBusyMessageTimeout);
    }

    @PreDestroy
    public void shutdown() {
        this.state = ApplicationState.STOPPING;
    }

    @VisibleForTesting
    void setServerBusyQueueTime(long serverBusyQueueTime, TimeUnit timeUnit) {
        this.serverBusyQueueTime = timeUnit.toMillis(serverBusyQueueTime);
    }
}

