/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.UnsupportedScmTypeException;
import com.atlassian.stash.hook.ScmHookHandlerFactory;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.hook.PluginScmHookHandlerFactory;
import com.atlassian.stash.internal.maintenance.DatabaseState;
import com.atlassian.stash.internal.maintenance.ScmState;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.scm.PluginScmCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmPullRequestCommandFactory;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.DeleteCommandParameters;
import com.atlassian.stash.scm.FeatureUnsupportedScmException;
import com.atlassian.stash.scm.PluginCommandBuilderFactory;
import com.atlassian.stash.scm.Scm;
import com.atlassian.stash.scm.ScmCommandBuilder;
import com.atlassian.stash.scm.ScmCommandFactory;
import com.atlassian.stash.scm.ScmProtocol;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.ScmStatus;
import com.atlassian.stash.scm.UnavailableScmException;
import com.atlassian.stash.scm.UnsupportedScmException;
import com.atlassian.stash.scm.event.ScmStatusChangedEvent;
import com.atlassian.stash.scm.hook.PluginHookHandlerFactory;
import com.atlassian.stash.scm.pull.PluginPullRequestCommandFactory;
import com.atlassian.stash.scm.pull.RepositoryRescopeCommandParameters;
import com.atlassian.stash.scm.pull.ScmPullRequestCommandFactory;
import com.atlassian.stash.util.Drainable;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ScmService.class)
@Service(value="scmService")
public class PluginScmService
implements InternalScmService {
    private static final String SCM_GIT = "git";
    private static final String STARS = StringUtils.repeat((String)"*", (int)75);
    private static final Logger log = LoggerFactory.getLogger(PluginScmService.class);
    private final Cache<String, Scm> cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<String, Scm>(){

        public Scm apply(String scmId) {
            log.debug("Cache miss for SCM {}; searching plugins", (Object)scmId);
            for (Scm scm : PluginScmService.this.pluginAccessor.getEnabledModulesByClass(Scm.class)) {
                if (!StringUtils.equals((String)scmId, (String)scm.getId())) continue;
                ScmStatus status = scm.getStatus();
                if (status.isAvailable()) {
                    return scm;
                }
                throw PluginScmService.this.unavailableScm(scmId, status.getMessage());
            }
            throw PluginScmService.this.unsupportedScm(scmId);
        }
    }));
    private final DatabaseManager databaseManager;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginScmService(EventPublisher eventPublisher, DatabaseManager databaseManager, I18nService i18nService, PluginAccessor pluginAccessor) {
        this.databaseManager = databaseManager;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public ScmCommandBuilder<?> createBuilder(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginCommandBuilderFactory builderFactory = scm.getCommandBuilderFactory();
        if (builderFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), "CommandBuilder");
        }
        return builderFactory.builder(repository);
    }

    public void delete(@Nonnull Repository repository, @Nonnull DeleteCommandParameters parameters) {
        Preconditions.checkNotNull((Object)parameters, (Object)"parameters");
        this.findByRepository(repository).getCommandFactory().delete(repository, parameters).synchronous().call();
    }

    public boolean drain(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must non-negative");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        log.debug("Draining SCMs with timeout of {}ms", (Object)unit.toMillis(timeout));
        long timeoutNs = unit.toNanos(timeout);
        long remainingNs = Math.max(0L, timeoutNs);
        for (Scm scm : this.pluginAccessor.getEnabledModulesByClass(Scm.class)) {
            if (!(scm instanceof Drainable) || !scm.getStatus().isAvailable()) continue;
            log.debug("Draining SCM {}", (Object)scm);
            Timer timer = TimerUtils.start((String)("Draining SCM " + scm));
            Throwable throwable = null;
            try {
                long startNs = System.nanoTime();
                if (!((Drainable)scm).drain(remainingNs, TimeUnit.NANOSECONDS)) {
                    log.warn("Failed to drain SCM {} in remaining allocated time ({}ms) of total ({}ms)", new Object[]{scm, TimeUnit.NANOSECONDS.toMillis(remainingNs), unit.toMillis(timeout)});
                    boolean bl = false;
                    return bl;
                }
                remainingNs = Math.max(0L, remainingNs - (System.nanoTime() - startNs));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (timer == null) continue;
                if (throwable != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                timer.close();
            }
        }
        return true;
    }

    @Nonnull
    public Scm findById(@Nonnull String scmId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)((String)Preconditions.checkNotNull((Object)scmId, (Object)"scmId"))), (Object)"An scmId is required to locate an SCM");
        try {
            return (Scm)this.cache.getUnchecked((Object)scmId);
        }
        catch (UncheckedExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Nonnull
    public Scm findByRepository(@Nonnull Repository repository) {
        return this.findById(((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getScmId());
    }

    @Nonnull
    public ScmState getState() {
        if (this.databaseManager.getState() == DatabaseState.AVAILABLE) {
            return ScmState.AVAILABLE;
        }
        if (this.drain(0L, TimeUnit.NANOSECONDS)) {
            return ScmState.DRAINED;
        }
        return ScmState.LATCHED;
    }

    @Nonnull
    public Set<ScmProtocol> getProtocols(@Nonnull Repository repository) {
        Scm scm = this.findById(repository.getScmId());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ScmProtocol scmProtocol : this.pluginAccessor.getEnabledModulesByClass(ScmProtocol.class)) {
            if (!scmProtocol.supports(scm)) continue;
            builder.add((Object)scmProtocol);
        }
        return builder.build();
    }

    @Nonnull
    public ScmCommandFactory getCommandFactory(@Nonnull Repository repository) {
        return new PluginScmCommandFactory(repository, this.findByRepository(repository).getCommandFactory());
    }

    @Nonnull
    public ScmHookHandlerFactory getHookHandlerFactory(@Nonnull Repository repository) {
        return new PluginScmHookHandlerFactory(repository, this.hookHandlerFactory(repository));
    }

    @Nonnull
    public ScmPullRequestCommandFactory getPullRequestCommandFactory(@Nonnull PullRequest pullRequest) {
        return new PluginScmPullRequestCommandFactory(pullRequest, this.pullRequestCommandFactory(pullRequest));
    }

    public boolean isEmpty(@Nonnull Repository repository) {
        return this.findByRepository(repository).isEmpty(repository);
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        Plugin plugin = event.getPlugin();
        log.debug("Plugin {} has been disabled; checking for SCMs and SCM protocols", (Object)plugin.getKey());
        this.invalidateCacheForDisabledScms(plugin);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.checkGitStatus();
    }

    @EventListener
    public void onStatusChanged(ScmStatusChangedEvent event) {
        Scm scm = event.getScm();
        log.debug("Invaliding cached Scm for SCM {} after status change", (Object)scm.getId());
        this.cache.invalidate((Object)scm.getId());
        if (SCM_GIT.equals(scm.getId())) {
            this.checkGitStatus();
        }
    }

    public void rescope(@Nonnull RepositoryRescopeCommandParameters parameters) {
        this.pullRequestCommandFactory(((RepositoryRescopeCommandParameters)Preconditions.checkNotNull((Object)parameters, (Object)"parameters")).getRepository()).rescope(parameters).call();
    }

    private void checkGitStatus() {
        try {
            Scm scm = this.findById(SCM_GIT);
            KeyedMessage statusMessage = scm.getStatus().getMessage();
            if (statusMessage != null) {
                log.info(statusMessage.getRootMessage());
            }
        }
        catch (UnavailableScmException e) {
            String localisedMessage = e.getLocalizedMessage();
            log.error(STARS);
            log.error(localisedMessage);
            log.error(STARS);
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), localisedMessage, EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
        catch (UnsupportedScmTypeException e) {
            log.error(STARS);
            log.error(e.getLocalizedMessage());
            log.error(STARS);
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), this.i18nService.getMessage("stash.plugin.failed", new Object[]{"Git SCM Plugin"}), EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
    }

    private FeatureUnsupportedScmException featureUnsupported(String scmId, String feature) {
        throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("stash.scm.feature.unsupported", new Object[]{scmId, feature}), scmId, feature);
    }

    @Nonnull
    private PluginHookHandlerFactory hookHandlerFactory(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginHookHandlerFactory handlerFactory = scm.getHookHandlerFactory();
        if (handlerFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), "Hooks");
        }
        return handlerFactory;
    }

    @Nonnull
    private PluginPullRequestCommandFactory pullRequestCommandFactory(@Nonnull PullRequest pullRequest) {
        return this.pullRequestCommandFactory(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getToRef().getRepository());
    }

    @Nonnull
    private PluginPullRequestCommandFactory pullRequestCommandFactory(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginPullRequestCommandFactory commandFactory = scm.getPullRequestCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), "PullRequest");
        }
        return commandFactory;
    }

    private UnavailableScmException unavailableScm(String scmId, KeyedMessage statusMessage) {
        throw new UnavailableScmException(statusMessage, scmId);
    }

    private UnsupportedScmException unsupportedScm(String scmId) {
        throw new UnsupportedScmException(this.i18nService.createKeyedMessage("stash.scm.unsupported", new Object[]{scmId}), scmId);
    }

    private void invalidateCacheForDisabledScms(Plugin plugin) {
        List descriptors = plugin.getModuleDescriptorsByModuleClass(Scm.class);
        if (CollectionUtils.isEmpty((Collection)descriptors)) {
            log.debug("Plugin {} did not provide any SCMs", (Object)plugin.getKey());
        } else {
            log.debug("Plugin {} provided {} SCM(s); removing from cache if present", (Object)plugin.getKey(), (Object)descriptors.size());
            for (ModuleDescriptor descriptor : descriptors) {
                Scm scm = (Scm)descriptor.getModule();
                log.debug("Invalidating cached Scm for SCM {} after disabling", (Object)scm.getId());
                this.cache.invalidate((Object)scm.getId());
            }
        }
    }
}

