/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.stash.scm.HttpScmRequestProvider;
import com.atlassian.stash.scm.http.HttpScmRequest;
import com.atlassian.stash.scm.http.HttpScmRequestHandler;
import com.atlassian.stash.scm.http.HttpScmRequestHandlerModuleDescriptor;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=HttpScmRequestProvider.class)
@Component(value="httpScmRequestProvider")
public class PluginHttpScmRequestProvider
implements HttpScmRequestProvider {
    private final PluginModuleTracker<HttpScmRequestHandler, HttpScmRequestHandlerModuleDescriptor> pluginModuleTracker;

    @Autowired
    public PluginHttpScmRequestProvider(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.pluginModuleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, HttpScmRequestHandlerModuleDescriptor.class);
    }

    @PreDestroy
    public void destroy() {
        this.pluginModuleTracker.close();
    }

    @Nullable
    public HttpScmRequest getHttpScmRequest(HttpServletRequest req, HttpServletResponse resp) {
        HttpScmRequestHandler handler;
        HttpScmRequest httpScmRequest = null;
        Iterator i$ = ModuleDescriptorUtils.toSortedModules((Iterable)this.pluginModuleTracker.getModuleDescriptors()).iterator();
        while (i$.hasNext() && (httpScmRequest = (handler = (HttpScmRequestHandler)i$.next()).create(req, resp)) == null) {
        }
        return httpScmRequest;
    }
}

