/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.internal.repository.RefMetadataMapProvider;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.MetadataMap;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefMetadataContext;
import com.atlassian.stash.repository.RefMetadataRequest;
import com.atlassian.stash.repository.RefOrder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryBranchesRequest;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.Tag;
import com.atlassian.stash.scm.BranchesCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.TagsCommandParameters;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=RepositoryMetadataService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="repositoryMetadataService")
public class RepositoryMetadataServiceImpl
extends AbstractScmService
implements RepositoryMetadataService {
    private static final String CACHE_NAME = "com.atlassian.stash.repository.RepositoryMetadataService";
    private static final String EMPTY_KEY = "empty:";
    private static final String MAX_REF_METADATA_REQUEST_COUNT = "${ref.metadata.max.request.count}";
    private static final int MIN_BRANCHES_COUNT = 1;
    private static final int MIN_TAGS_COUNT = 1;
    private static final int MIN_REF_METADATA_REQUEST_COUNT = 1;
    private final CacheManager cacheManager;
    private final EventPublisher eventPublisher;
    private final RefMetadataMapProvider refMetadataMapProvider;
    private int maxBranches;
    private int maxTags;
    private int maxRefMetadataRequestCount;

    @Autowired
    public RepositoryMetadataServiceImpl(ScmService scmService, CacheManager cacheManager, EventPublisher eventPublisher, RefMetadataMapProvider refMetadataMapProvider) {
        super(scmService);
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
        this.refMetadataMapProvider = refMetadataMapProvider;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<Branch> getBranches(@Nonnull RepositoryBranchesRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxBranches);
        BranchesCommandParameters parameters = ((BranchesCommandParameters.Builder)((BranchesCommandParameters.Builder)new BranchesCommandParameters.Builder().filterText(request.getFilterText())).order(request.getOrder())).build();
        Page page = (Page)this.getCommandFactory(request.getRepository()).branches(parameters, pageRequest).call();
        if (page == null) {
            page = PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return page;
    }

    @Nonnull
    public Branch getDefaultBranch(@Nonnull Repository repository) {
        return (Branch)this.getCommandFactory(repository).defaultBranch().call();
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Map<Ref, MetadataMap> getMetadataByRefs(@Nonnull RefMetadataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Ref baseRef = request.getBaseRef();
        if (baseRef == null) {
            baseRef = this.getDefaultBranch(request.getRepository());
        }
        InternalRefMetadataContext context = new InternalRefMetadataContext(request.getRepository(), baseRef, Iterables.limit((Iterable)request.getRefs(), (int)this.maxRefMetadataRequestCount));
        return this.refMetadataMapProvider.getMetadata(context);
    }

    @Nonnull
    public Page<? extends Tag> getTags(@Nonnull Repository repository, @Nonnull PageRequest pageRequest, @Nullable String filterText, @Nullable RefOrder order) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxTags);
        TagsCommandParameters parameters = ((TagsCommandParameters.Builder)((TagsCommandParameters.Builder)new TagsCommandParameters.Builder().filterText(filterText)).order(order)).build();
        Page page = (Page)this.getCommandFactory(repository).tags(parameters, pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    @Cacheable(key="'empty:'+#repository.id", value={"com.atlassian.stash.repository.RepositoryMetadataService"})
    public boolean isEmpty(@Nonnull Repository repository) {
        return this.scmService.isEmpty(repository);
    }

    @Nullable
    public Ref resolveRef(@Nonnull Repository repository, @Nullable String objectId) {
        if (objectId == null) {
            return this.getDefaultBranch(repository);
        }
        return (Ref)this.getCommandFactory(repository).resolveRef(objectId).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void setDefaultBranch(@Nonnull Repository repository, @Nonnull String branchName) {
        this.getCommandFactory(repository).updateDefaultBranch(branchName).call();
        this.eventPublisher.publish((Object)new RepositoryDefaultBranchModifiedEvent((Object)this, repository, branchName));
    }

    @Value(value="${page.max.branches}")
    public void setMaxBranches(int maxBranches) {
        this.maxBranches = Math.max(maxBranches, 1);
    }

    @Value(value="${page.max.tags}")
    public void setMaxTags(int maxTags) {
        this.maxTags = Math.max(maxTags, 1);
    }

    @Value(value="${ref.metadata.max.request.count}")
    public void setMaxRefMetadataRequestCount(int maxRefMetadataRequestCount) {
        this.maxRefMetadataRequestCount = Math.max(maxRefMetadataRequestCount, 1);
    }

    @EventListener
    public void onDeletedEvent(RepositoryDeletedEvent event) {
        this.evictEmptyCache(event.getRepository());
    }

    @EventListener
    public void onRefsChangedEvent(RepositoryRefsChangedEvent event) {
        this.evictEmptyCache(event.getRepository());
    }

    private void evictEmptyCache(Repository repository) {
        this.cacheManager.getCache(CACHE_NAME).evict((Object)(EMPTY_KEY + repository.getId()));
    }

    private static class InternalRefMetadataContext
    implements RefMetadataContext {
        private final Repository repository;
        private final Ref baseRef;
        private final Set<Ref> refs;

        private InternalRefMetadataContext(Repository repository, Ref baseRef, Iterable<? extends Ref> refs) {
            this.repository = repository;
            this.baseRef = baseRef;
            this.refs = ImmutableSet.copyOf(refs);
        }

        @Nonnull
        public Ref getBaseRef() {
            return this.baseRef;
        }

        @Nonnull
        public Set<Ref> getRefs() {
            return this.refs;
        }

        @Nonnull
        public Repository getRepository() {
            return this.repository;
        }
    }
}

