/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.pull.comment.InternalPullRequestCommentHelper;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftRequestDao;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.CompositeCommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.InternalDriftRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DriftCommentUpdateProcessor
implements CommentUpdateProcessor {
    private static final int MAX_ATTEMPTS = 20;
    private static final Logger log = LoggerFactory.getLogger(DriftCommentUpdateProcessor.class);
    private final CommentDriftRequestDao driftRequestDao;
    private final ExecutorService executorService;
    private final InternalLockService lockService;
    private final Map<Long, List<InternalDriftRequest>> pending;
    private final Map<Long, Integer> failedAttemptCountForPullRequest;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final CommentDriftStrategy strategy;
    private final TransactionTemplate transactionTemplate;
    @Autowired
    private InternalPullRequestCommentHelper commentHelper;

    public DriftCommentUpdateProcessor(CommentDriftRequestDao driftRequestDao, ExecutorService executorService, InternalLockService lockService, ScmService scmService, SecurityService securityService, List<CommentDriftStrategy> strategies, PlatformTransactionManager transactionManager) {
        this.driftRequestDao = driftRequestDao;
        this.executorService = executorService;
        this.lockService = lockService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.failedAttemptCountForPullRequest = Maps.newConcurrentMap();
        this.pending = Maps.newHashMap();
        this.strategy = new CompositeCommentDriftStrategy(strategies);
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.securityService.withPermission(Permission.REPO_WRITE, "Reschedule any pending comment drift").call((Operation)new CommentDriftLoader());
    }

    @Override
    public void maybeProcess(InternalPullRequest pullRequest) {
        new CommentDriftBootstrapper(pullRequest).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(InternalPullRequest pullRequest, String previousFromHash, String previousToHash) {
        List<InternalDriftRequest> driftRequests;
        List<InternalDriftRequest> list = driftRequests = this.getPendingDrifts(pullRequest);
        synchronized (list) {
            final InternalDriftRequest request = new InternalDriftRequest(null, pullRequest, previousFromHash, previousToHash, pullRequest.getFromRef().getLatestChangeset(), pullRequest.getToRef().getLatestChangeset());
            this.schedule(request);
            try {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalDriftRequest>(){

                    public InternalDriftRequest doInTransaction(TransactionStatus status) {
                        return DriftCommentUpdateProcessor.this.driftRequestDao.create(request);
                    }
                });
            }
            catch (Exception e) {
                log.warn("{}:{}@{}: Problem persisting drift request (still scheduled)", new Object[]{pullRequest.getScopeRepository().getId(), pullRequest.getId(), pullRequest.getVersion(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InternalDriftRequest> getPendingDrifts(InternalPullRequest pullRequest) {
        Map<Long, List<InternalDriftRequest>> map = this.pending;
        synchronized (map) {
            Long globalId = pullRequest.getGlobalId();
            LinkedList drifts = this.pending.get(globalId);
            if (drifts == null) {
                drifts = Lists.newLinkedList();
                this.pending.put(globalId, drifts);
            }
            return drifts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(InternalDriftRequest request) {
        List<InternalDriftRequest> driftRequests;
        List<InternalDriftRequest> list = driftRequests = this.getPendingDrifts(request.getPullRequest());
        synchronized (list) {
            log.debug("{}:{}@{}: Scheduling drift (oldFrom: {}, oldTo: {}, newFrom: {}, newTo: {})", new Object[]{request.getPullRequest().getScopeRepository().getId(), request.getPullRequest().getId(), request.getPullRequest().getVersion(), request.getOldFromHash(), request.getOldToHash(), request.getNewFromHash(), request.getNewToHash()});
            driftRequests.add(request);
            this.executorService.submit(new CommentDriftBootstrapper(request.getPullRequest()));
        }
    }

    private class CommentDriftOperation
    implements UncheckedOperation<Void> {
        private final InternalPullRequest cachedPullRequest;

        private CommentDriftOperation(InternalPullRequest cachedPullRequest) {
            this.cachedPullRequest = cachedPullRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void perform() {
            ArrayList drifts;
            List pendingDrifts;
            List list = pendingDrifts = DriftCommentUpdateProcessor.this.getPendingDrifts(this.cachedPullRequest);
            synchronized (list) {
                drifts = Lists.newArrayList((Iterable)pendingDrifts);
                pendingDrifts.clear();
            }
            if (drifts.isEmpty()) {
                log.debug("{}:{}@{}: No rescopes are pending drift", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion()});
                return null;
            }
            final CommentDriftCalculator calculator = this.calculatorFor(drifts);
            try {
                DriftCommentUpdateProcessor.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                    public Void doInTransaction(TransactionStatus status) {
                        try (Timer timer = TimerUtils.start((String)("Drift: Calculate for " + calculator));){
                            calculator.calculate(drifts);
                            DriftCommentUpdateProcessor.this.driftRequestDao.deleteAll(drifts);
                        }
                        return null;
                    }
                });
                DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.remove(this.cachedPullRequest.getGlobalId());
            }
            catch (RuntimeException e) {
                Integer failedAttempts = (Integer)DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.get(this.cachedPullRequest.getGlobalId());
                failedAttempts = failedAttempts == null ? 1 : failedAttempts + 1;
                if (failedAttempts <= 20 && this.isRecoverable(e)) {
                    DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.put(this.cachedPullRequest.getGlobalId(), failedAttempts);
                    log.info("{}:{}@{}: Failed to drift comments (Attempt {} of {}). Rescheduling", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), failedAttempts, 20, e});
                    List list2 = pendingDrifts = DriftCommentUpdateProcessor.this.getPendingDrifts(this.cachedPullRequest);
                    synchronized (list2) {
                        pendingDrifts.addAll(0, drifts);
                        DriftCommentUpdateProcessor.this.executorService.submit(new CommentDriftBootstrapper(this.cachedPullRequest));
                    }
                }
                DriftCommentUpdateProcessor.this.failedAttemptCountForPullRequest.remove(this.cachedPullRequest.getGlobalId());
                InternalDriftRequest first = (InternalDriftRequest)drifts.get(0);
                InternalDriftRequest last = (InternalDriftRequest)drifts.get(drifts.size() - 1);
                log.error("{}:{}@{}: Error calculating comment drift ({} attempts).\n\tFirst: {}\n\tLast: {}", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), failedAttempts, first, last, e});
            }
            return null;
        }

        private CommentDriftCalculator calculatorFor(List<InternalDriftRequest> drifts) {
            if (drifts.size() > 1) {
                log.debug("{}:{}@{}: Calculating combined drift for {} rescopes", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), drifts.size()});
            }
            InternalDriftRequest first = drifts.get(0);
            return new CommentDriftCalculator(this.cachedPullRequest, first.getOldFromHash(), first.getOldToHash());
        }

        private boolean isRecoverable(Exception e) {
            return DataAccessException.class.isAssignableFrom(e.getClass()) || TransactionException.class.isAssignableFrom(e.getClass()) || HibernateException.class.isAssignableFrom(e.getClass());
        }
    }

    private class CommentDriftLoader
    extends TransactionCallbackWithoutResult
    implements UncheckedOperation<Void> {
        private CommentDriftLoader() {
        }

        protected void doInTransactionWithoutResult(TransactionStatus status) {
            List requests = DriftCommentUpdateProcessor.this.driftRequestDao.findAll();
            for (InternalDriftRequest driftRequest : requests) {
                DriftCommentUpdateProcessor.this.schedule(driftRequest);
            }
        }

        public Void perform() {
            DriftCommentUpdateProcessor.this.transactionTemplate.execute((TransactionCallback)this);
            return null;
        }
    }

    private class CommentDriftCalculator {
        private final InternalPullRequest cachedPullRequest;
        private final String previousFromHash;
        private final String previousToHash;
        private final InternalRepository repository;

        public CommentDriftCalculator(InternalPullRequest cachedPullRequest, String previousFromHash, String previousToHash) {
            this.cachedPullRequest = cachedPullRequest;
            this.previousFromHash = previousFromHash;
            this.previousToHash = previousToHash;
            this.repository = cachedPullRequest.getScopeRepository();
        }

        public void calculate(List<InternalDriftRequest> driftRequests) {
            Map<PullRequestEffectiveDiff, List<InternalPullRequestDiffCommentAnchor>> previousDiffs;
            PullRequestEffectiveDiff effectiveDiff;
            try (Timer timer = TimerUtils.start((String)("Drift: Map anchors " + this.cachedPullRequest.getGlobalId()));){
                List anchors = DriftCommentUpdateProcessor.this.commentHelper.findDiffAnchors(this.cachedPullRequest);
                if (anchors.isEmpty()) {
                    log.debug("{}:{}@{}: No active diff comments", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion()});
                    return;
                }
                effectiveDiff = (PullRequestEffectiveDiff)DriftCommentUpdateProcessor.this.scmService.getPullRequestCommandFactory((PullRequest)this.cachedPullRequest).effectiveDiff().call();
                previousDiffs = this.mapPreviousDiffs(anchors, effectiveDiff);
            }
            if (previousDiffs.isEmpty()) {
                StringBuilder builder = new StringBuilder().append(this.repository.getId()).append(":").append(this.cachedPullRequest.getId()).append("@").append(this.cachedPullRequest.getVersion()).append(": Comments have already been drifted (").append(effectiveDiff.getSinceId()).append(", ").append(effectiveDiff.getUntilId()).append(") when processing ").append(driftRequests.size()).append(" drift request(s):");
                for (InternalDriftRequest driftRequest : driftRequests) {
                    builder.append("\n\t").append(driftRequest);
                }
                log.warn(builder.toString());
                return;
            }
            if (previousDiffs.size() > 1) {
                log.warn("{}:{}@{}: Non-orphaned comments span {} diffs", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), previousDiffs.size()});
            }
            for (Map.Entry<PullRequestEffectiveDiff, List<InternalPullRequestDiffCommentAnchor>> entry : previousDiffs.entrySet()) {
                PullRequestEffectiveDiff previousDiff = entry.getKey();
                DriftContext context = new DriftContext(this.repository, this.cachedPullRequest, this.previousFromHash, this.previousToHash, effectiveDiff, previousDiff, entry.getValue());
                try (Timer timer = TimerUtils.start((String)("Drift: Strategy - " + DriftCommentUpdateProcessor.this.strategy.getName() + " " + this.cachedPullRequest.getGlobalId()));){
                    DriftCommentUpdateProcessor.this.strategy.apply(context);
                }
                List<InternalPullRequestDiffCommentAnchor> driftedAnchors = context.done();
                try (Timer timer = TimerUtils.start((String)("Drift: Update anchors " + this.cachedPullRequest.getGlobalId()));){
                    DriftCommentUpdateProcessor.this.commentHelper.updateAnchors(driftedAnchors);
                }
                log.debug("{}:{}@{}: Successfully drifted {} anchors from ({}, {}) to ({}, {})", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), driftedAnchors.size(), previousDiff.getSinceId(), previousDiff.getUntilId(), effectiveDiff.getSinceId(), effectiveDiff.getUntilId()});
            }
        }

        private Map<PullRequestEffectiveDiff, List<InternalPullRequestDiffCommentAnchor>> mapPreviousDiffs(List<InternalPullRequestDiffCommentAnchor> anchors, PullRequestEffectiveDiff currentDiff) {
            HashMap previousDiffs = Maps.newHashMap();
            for (InternalPullRequestDiffCommentAnchor anchor : anchors) {
                PullRequestEffectiveDiff diff = new PullRequestEffectiveDiff(anchor.getToHash(), anchor.getFromHash());
                if (currentDiff.equals((Object)diff)) {
                    log.warn("{}:{}@{}: Comment {} is already in the current diff ({}, {}) and will not be drifted", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), anchor.getComment().getId(), currentDiff.getSinceId(), currentDiff.getUntilId()});
                    continue;
                }
                List diffAnchors = (List)previousDiffs.get(diff);
                if (diffAnchors == null) {
                    diffAnchors = Lists.newArrayList();
                    previousDiffs.put(diff, diffAnchors);
                }
                diffAnchors.add(anchor);
            }
            return previousDiffs;
        }
    }

    private class CommentDriftBootstrapper
    implements Runnable {
        private final InternalPullRequest cachedPullRequest;

        private CommentDriftBootstrapper(InternalPullRequest cachedPullRequest) {
            this.cachedPullRequest = cachedPullRequest;
        }

        @Override
        public void run() {
            DriftCommentUpdateProcessor.this.lockService.doWithLock(this.cachedPullRequest, (Operation)new CommentDriftOperation(this.cachedPullRequest));
        }
    }
}

