/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.comment.AddDiffCommentRequest;
import com.atlassian.stash.comment.AddFileCommentRequest;
import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.DiffCommentAnchor;
import com.atlassian.stash.commit.CommitEnricher;
import com.atlassian.stash.content.AbstractChangesetCallback;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.ChangesetsBetweenRequest;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.content.InternalMinimalChangeset;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.event.RepositoryDeletionRequestedEvent;
import com.atlassian.stash.event.pull.PullRequestApprovedEvent;
import com.atlassian.stash.event.pull.PullRequestDeclinedEvent;
import com.atlassian.stash.event.pull.PullRequestMergedEvent;
import com.atlassian.stash.event.pull.PullRequestOpenRequestedEvent;
import com.atlassian.stash.event.pull.PullRequestOpenedEvent;
import com.atlassian.stash.event.pull.PullRequestParticipantsUpdatedEvent;
import com.atlassian.stash.event.pull.PullRequestReopenedEvent;
import com.atlassian.stash.event.pull.PullRequestRescopedEvent;
import com.atlassian.stash.event.pull.PullRequestRolesUpdatedEvent;
import com.atlassian.stash.event.pull.PullRequestUnapprovedEvent;
import com.atlassian.stash.event.pull.PullRequestUpdatedEvent;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.NoSuchChangesetException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.comment.CountAttributeChangeCallback;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestParticipantDao;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeability;
import com.atlassian.stash.internal.pull.comment.InternalPullRequestCommentHelper;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.pull.DuplicatePullRequestException;
import com.atlassian.stash.pull.EmptyPullRequestException;
import com.atlassian.stash.pull.IllegalPullRequestStateException;
import com.atlassian.stash.pull.InvalidPullRequestParticipantException;
import com.atlassian.stash.pull.InvalidPullRequestReviewersException;
import com.atlassian.stash.pull.InvalidPullRequestRoleException;
import com.atlassian.stash.pull.InvalidPullRequestTargetException;
import com.atlassian.stash.pull.NoSuchParticipantException;
import com.atlassian.stash.pull.NoSuchPullRequestException;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.pull.PullRequestActivity;
import com.atlassian.stash.pull.PullRequestActivityPage;
import com.atlassian.stash.pull.PullRequestChangesRequest;
import com.atlassian.stash.pull.PullRequestDiffRequest;
import com.atlassian.stash.pull.PullRequestDirection;
import com.atlassian.stash.pull.PullRequestEntityType;
import com.atlassian.stash.pull.PullRequestMergeVetoedException;
import com.atlassian.stash.pull.PullRequestMergeability;
import com.atlassian.stash.pull.PullRequestOpenCanceledException;
import com.atlassian.stash.pull.PullRequestOrder;
import com.atlassian.stash.pull.PullRequestOutOfDateException;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.pull.PullRequestRef;
import com.atlassian.stash.pull.PullRequestRole;
import com.atlassian.stash.pull.PullRequestSearchRequest;
import com.atlassian.stash.pull.PullRequestService;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.pull.PullRequestUpdateRequest;
import com.atlassian.stash.pull.UnmodifiablePullRequestRoleException;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.pull.MergeRequestCheckService;
import com.atlassian.stash.scm.pull.PullRequestChangeCommandParameters;
import com.atlassian.stash.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.stash.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.stash.scm.pull.ScmPullRequestCommandFactory;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.PagedIterable;
import com.atlassian.stash.util.SimpleCancelState;
import com.atlassian.stash.util.UncheckedOperation;
import com.atlassian.stash.util.ValidationUtils;
import com.atlassian.stash.watcher.Watcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=PullRequestService.class)
@Service(value="pullRequestService")
public class PullRequestServiceImpl
extends AbstractService
implements InternalPullRequestService {
    public static final String DIFF_CONTEXT_LINES = "${pullrequest.diff.context}";
    private static final Predicate<PullRequestActivity> INTERESTING_ACTIVITIES = new Predicate<PullRequestActivity>(){

        public boolean apply(PullRequestActivity activity) {
            if (activity instanceof InternalPullRequestRescopeActivity) {
                InternalPullRequestRescopeActivity rescope = (InternalPullRequestRescopeActivity)activity;
                return rescope.getAdded().getTotal() > 0 || rescope.getRemoved().getTotal() > 0;
            }
            return true;
        }
    };
    private static final Function<PullRequestParticipant, StashUser> TO_USER = new Function<PullRequestParticipant, StashUser>(){

        public StashUser apply(PullRequestParticipant participant) {
            return participant.getUser();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(PullRequestServiceImpl.class);
    private final PullRequestActivityDao activityDao;
    private final List<PullRequestActivityEnricher> activityEnrichers;
    private final StashAuthenticationContext authenticationContext;
    private final InternalPullRequestCommentHelper commentHelper;
    private final CommitEnricher commitEnricher;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final InternalLockService lockService;
    private final MergeRequestCheckService mergeRequestCheckService;
    private final RepositoryMetadataService metadataService;
    private final PullRequestParticipantDao participantDao;
    private final PermissionService permissionService;
    private final PermissionPredicateFactory predicateFactory;
    private final PullRequestDao pullRequestDao;
    private final RescopeProcessor rescopeProcessor;
    private final ScmService scmService;
    private final UserService userService;
    private final Validator validator;
    private final InternalWatcherService watcherService;
    @Value(value="${pullrequest.diff.context}")
    private int diffContext;
    @Value(value="${page.max.pullrequest.activities}")
    private int maxActivities;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${page.max.commits}")
    private int maxCommits;
    @Value(value="${page.max.diff.lines}")
    private int maxDiffLines;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;
    @Value(value="${page.max.pullrequests}")
    private int maxPullRequests;

    @Autowired
    public PullRequestServiceImpl(PullRequestActivityDao activityDao, List<PullRequestActivityEnricher> activityEnrichers, StashAuthenticationContext authenticationContext, InternalPullRequestCommentHelper commentHelper, CommitEnricher commitEnricher, EventPublisher eventPublisher, I18nService i18nService, InternalLockService lockService, MergeRequestCheckService mergeRequestCheckService, RepositoryMetadataService metadataService, PullRequestParticipantDao participantDao, PermissionService permissionService, PermissionPredicateFactory predicateFactory, PullRequestDao pullRequestDao, RescopeProcessor rescopeProcessor, ScmService scmService, UserService userService, Validator validator, InternalWatcherService watcherService) {
        this.activityDao = activityDao;
        this.activityEnrichers = activityEnrichers;
        this.authenticationContext = authenticationContext;
        this.commentHelper = commentHelper;
        this.commitEnricher = commitEnricher;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.mergeRequestCheckService = mergeRequestCheckService;
        this.metadataService = metadataService;
        this.participantDao = participantDao;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.pullRequestDao = pullRequestDao;
        this.rescopeProcessor = rescopeProcessor;
        this.scmService = scmService;
        this.userService = userService;
        this.validator = validator;
        this.watcherService = watcherService;
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addComment(int repositoryId, long pullRequestId, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.create((InternalCommentable)pullRequest, commentText);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addDiffComment(int repositoryId, long pullRequestId, @Nonnull AddDiffCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.createDiffComment((InternalCommentable)pullRequest, request);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addFileComment(int repositoryId, long pullRequestId, @Nonnull AddFileCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.createFileComment((InternalCommentable)pullRequest, request);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment addReply(int repositoryId, long pullRequestId, long commentId, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.makeCurrentUserParticipantAndWatcher(pullRequest);
        return this.commentHelper.createReply((InternalCommentable)pullRequest, commentId, commentText);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant approve(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        if (pullRequest.getState() == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.approve.add.declined", new Object[0]));
        }
        if (pullRequest.getState() == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.approve.add.merged", new Object[0]));
        }
        return this.updateParticipantWithApproval(pullRequest, true);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequestParticipant assignRole(int repositoryId, long pullRequestId, @Nonnull String username, @Nonnull PullRequestRole role) {
        if (Preconditions.checkNotNull((Object)role, (Object)"role") != PullRequestRole.REVIEWER) {
            throw new InvalidPullRequestRoleException(this.i18nService.createKeyedMessage("stash.service.pullrequest.role.assign.restriction", new Object[]{PullRequestRole.REVIEWER.name().toLowerCase(Locale.US)}));
        }
        StashUser user = this.getUserAndEnsureHasReadPerms(username, repositoryId, role);
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId().longValue(), user.getId().intValue());
        if (participant != null) {
            if (participant.getRole() == PullRequestRole.AUTHOR) {
                throw new UnmodifiablePullRequestRoleException(this.i18nService.createKeyedMessage("stash.service.pullrequest.role.assign.unmodifiable", new Object[0]));
            }
            if (participant.getRole() != role) {
                participant = (InternalPullRequestParticipant)this.participantDao.update((Object)new InternalPullRequestParticipant.Builder(participant).role(role).build());
                this.fireReviewerAdded(pullRequest, user, false);
            }
            return participant;
        }
        participant = (InternalPullRequestParticipant)this.participantDao.create((Object)((InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).role(role).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
        this.fireReviewerAdded(pullRequest, user, true);
        this.watcherService.addUserAsWatcher((InternalWatchable)pullRequest, user);
        return participant;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequestMergeability canMerge(int repositoryId, long pullRequestId) {
        return this.canMerge(this.getPullRequestOrFail(repositoryId, pullRequestId));
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Internal interface method")
    public PullRequest closeMerged(long globalId, int version) {
        InternalPullRequest internalPullRequest = this.getPullRequestOrFail(globalId, version);
        InternalPullRequest updatedPullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(internalPullRequest).state(PullRequestState.MERGED).build());
        this.logMergeActivity(updatedPullRequest, new Date(), null);
        this.eventPublisher.publish((Object)new PullRequestMergedEvent((Object)this, (PullRequest)updatedPullRequest, null));
        return updatedPullRequest;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public long countChangesetsFor(int repositoryId, long pullRequestId) {
        ChangesetsBetweenRequest request = this.buildChangesetsBetweenRequest(repositoryId, pullRequestId);
        ChangesetCountingCallback countingCallback = new ChangesetCountingCallback();
        this.scmService.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), (ChangesetCallback)countingCallback).call();
        return countingCallback.getCount();
    }

    @PreAuthorize(value="hasGlobalPermission(#user, 'LICENSED_USER')")
    public long countForParticipant(@Nonnull StashUser user, PullRequestRole role, Boolean approved, PullRequestState state) {
        PullRequestSearchCriteria criteria = new PullRequestSearchCriteria();
        criteria.setUserId(((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId().intValue());
        criteria.setParticipantRole(role);
        criteria.setApproved(approved);
        criteria.setState(state);
        return this.pullRequestDao.countMatching(criteria);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public long countInDirection(@Nonnull PullRequestDirection direction, int repositoryId, PullRequestState state) {
        Preconditions.checkNotNull((Object)direction, (Object)"direction");
        PullRequestSearchCriteria criteria = new PullRequestSearchCriteria();
        criteria.setState(state);
        if (direction == PullRequestDirection.INCOMING) {
            criteria.setToRepositoryId(repositoryId);
        } else {
            criteria.setFromRepositoryId(repositoryId);
        }
        return this.pullRequestDao.countMatching(criteria);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#fromRepository, 'REPO_READ') and hasRepositoryPermission(#toRepository, 'REPO_READ')")
    @Transactional
    public InternalPullRequest create(@Nonnull String title, String description, @Nonnull Set<String> reviewers, @Nonnull Repository fromRepository, @Nonnull String fromBranchId, @Nonnull Repository toRepository, @Nonnull String toBranchId) {
        this.checkSameHierarchies(fromRepository, toRepository);
        this.checkNotSameBranches(fromRepository, fromBranchId, toRepository, toBranchId);
        Ref fromRef = this.resolveBranchOrFail(fromRepository, fromBranchId);
        Ref toRef = this.resolveBranchOrFail(toRepository, toBranchId);
        InternalPullRequestRef fromPullRef = this.createPullRequestRef(fromRepository, fromRef);
        InternalPullRequestRef toPullRef = this.createPullRequestRef(toRepository, toRef);
        this.checkUniquePullRequest(fromPullRef, toPullRef);
        this.checkHasChangesets((PullRequestRef)fromPullRef, (PullRequestRef)toPullRef);
        Date now = new Date();
        InternalPullRequest pullRequest = new InternalPullRequest.Builder().title(title).description(description).fromRef(fromPullRef).toRef(toPullRef).createdDate(now).updatedDate(now).state(PullRequestState.OPEN).build();
        ValidationUtils.validate((Validator)this.validator, (Object)pullRequest, (Class[])new Class[0]);
        Set<StashUser> resolvedReviewers = this.resolveReviewersOrFail(reviewers, Collections.emptySet(), toRepository, true);
        this.fireOpenRequested((PullRequest)pullRequest, resolvedReviewers);
        pullRequest = (InternalPullRequest)this.pullRequestDao.create((Object)pullRequest);
        InternalPullRequestParticipant.Builder participantBuilder = (InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).role(PullRequestRole.AUTHOR).user(this.getCurrentUser());
        this.participantDao.create((Object)participantBuilder.build());
        this.watcherService.addCurrentUserAsWatcher((InternalWatchable)pullRequest);
        for (StashUser resolvedReviewer : resolvedReviewers) {
            this.participantDao.create((Object)((InternalPullRequestParticipant.Builder)participantBuilder.role(PullRequestRole.REVIEWER).user(InternalConverter.convertToInternalUser((StashUser)resolvedReviewer))).build());
            this.watcherService.addUserAsWatcher((InternalWatchable)pullRequest, resolvedReviewer);
        }
        this.logActivity(pullRequest, PullRequestAction.OPENED);
        this.eventPublisher.publish((Object)new PullRequestOpenedEvent((Object)this, (PullRequest)pullRequest));
        return pullRequest;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequest decline(int repositoryId, long pullRequestId, final int version) {
        final InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return (PullRequest)this.lockService.doWithLock(pullRequest.getToRef().getRepository(), (Operation)new UncheckedOperation<PullRequest>(){

            public PullRequest perform() {
                return PullRequestServiceImpl.this.internalDecline(pullRequest, version);
            }
        });
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Internal interface method")
    public PullRequest decline(long globalPullRequestId, int version) {
        return this.internalDecline(this.getPullRequestOrFail(globalPullRequestId), version);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public boolean deleteComment(int repositoryId, long pullRequestId, long commentId, int commentVersion) {
        return this.commentHelper.delete((InternalCommentable)this.getPullRequestOrFail(repositoryId, pullRequestId), commentId, commentVersion);
    }

    @Unsecured(value="Internal interface method")
    public void ensureUpToDate(@Nonnull PullRequest pullRequest) {
        this.scmService.getPullRequestCommandFactory(pullRequest).effectiveDiff().call();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission(#user, 'LICENSED_USER')")
    public Page<PullRequest> findByParticipant(@Nonnull StashUser user, PullRequestRole role, Boolean approved, PullRequestState state, PullRequestOrder order, @Nonnull PageRequest pageRequest) {
        PullRequestSearchCriteria criteria = new PullRequestSearchCriteria();
        criteria.setUserId(((StashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId().intValue());
        criteria.setParticipantRole(role);
        criteria.setApproved(approved);
        criteria.setState(state);
        criteria.setOrder(order);
        return this.search(criteria, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Iterable<DiffCommentAnchor> findCommentAnchors(int repositoryId, long pullRequestId, @Nonnull String path) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)path, (Object)"path")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A file path to find anchors for is required.");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.maybeUpdate(pullRequest);
        return this.commentHelper.findDiffAnchors(pullRequest, path);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<? extends PullRequestActivity> getActivities(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        final InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.maybeUpdate(pullRequest);
        return PageUtils.filterPages((PageProvider)new PageProvider<PullRequestActivity>(){

            public Page<PullRequestActivity> get(PageRequest request) {
                Page page = PullRequestServiceImpl.this.activityDao.findByPullRequest(pullRequest.getGlobalId().longValue(), request);
                PullRequestServiceImpl.this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page);
                return page;
            }
        }, INTERESTING_ACTIVITIES, (PageRequest)pageRequest.buildRestrictedPageRequest(this.maxActivities));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public PullRequestActivityPage<? extends PullRequestActivity> getActivitiesStartingAt(int repositoryId, long pullRequestId, @Nonnull PullRequestEntityType fromType, long fromId, @Nonnull PageRequest pageRequest) {
        InternalPullRequestActivity activity;
        Preconditions.checkNotNull((Object)fromType, (Object)"fromType");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.maybeUpdate(pullRequest);
        switch (fromType) {
            case ACTIVITY: {
                activity = this.getActivityOrFail(pullRequest, fromId);
                break;
            }
            case COMMENT: {
                InternalComment comment = this.commentHelper.getById((InternalCommentable)pullRequest, fromId).getRoot();
                activity = this.activityDao.findByComment(comment.getId().longValue());
                if (activity != null) break;
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("stash.service.pullrequest.activities.noneforcomment", new Object[]{fromId}));
            }
            default: {
                throw new IllegalArgumentException("Unexpected entity type " + fromType);
            }
        }
        PullRequestActivityPage page = this.activityDao.findPageStartingAt(pullRequest.getGlobalId().longValue(), activity.getId().longValue(), pageRequest.buildRestrictedPageRequest(this.maxActivities));
        this.enrichActivities(pullRequest, (Page<InternalPullRequestActivity>)page);
        return page;
    }

    @PostAuthorize(value="hasRepositoryPermission(returnObject?.scopeRepository, 'REPO_READ')")
    public InternalPullRequest getById(int repositoryId, long pullRequestId) {
        return this.pullRequestDao.findByRepositoryScopedId(repositoryId, pullRequestId);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<Changeset> getChangesets(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxCommits);
        ChangesetsBetweenRequest request = this.buildChangesetsBetweenRequest(repositoryId, pullRequestId);
        Page commits = (Page)this.scmService.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), pageRequest).call();
        return this.commitEnricher.enrich(request.getRepository(), commits, null);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Comment getComment(int repositoryId, long pullRequestId, long commentId) {
        return this.commentHelper.getById((InternalCommentable)this.getPullRequestOrFail(repositoryId, pullRequestId), commentId);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public Page<? extends PullRequestParticipant> getParticipants(int repositoryId, long pullRequestId, @Nonnull PageRequest pageRequest) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return this.participantDao.findByPullRequest(pullRequest.getGlobalId().longValue(), pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_WRITE')")
    @Transactional
    public PullRequest merge(int repositoryId, long pullRequestId, int version) {
        StashUser author = this.authenticationContext.getCurrentUser();
        if (author == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.pullrequest.merge.anonymous", new Object[0]));
        }
        if (StringUtils.isBlank((String)author.getEmailAddress())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("stash.service.pullrequest.merge.author.email", new Object[]{author.getName()}));
        }
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId, version);
        this.checkPullRequestVersion(version, pullRequest);
        InternalPullRequestRef fromRef = pullRequest.getFromRef();
        InternalPullRequestRef toRef = pullRequest.getToRef();
        InternalRepository repository = toRef.getRepository();
        if (!StringUtils.equals((String)repository.getHierarchyId(), (String)fromRef.getRepository().getHierarchyId())) {
            throw new UnsupportedOperationException(this.i18nService.getMessage("stash.service.pullrequest.merge.unsupported", new Object[0]));
        }
        PullRequestMergeability mergeability = this.canMerge(pullRequest);
        if (!mergeability.canMerge()) {
            throw new PullRequestMergeVetoedException(this.buildMergeabilityMessage(mergeability), mergeability.getVetos(), mergeability.isConflicted());
        }
        Date now = new Date();
        MergeAndUpdatePullRequestOperation mergeOperation = new MergeAndUpdatePullRequestOperation(pullRequest, author, now);
        this.lockService.doWithLock(repository, (Operation)mergeOperation, Propagation.REQUIRES_NEW);
        this.pullRequestDao.refresh((Object)pullRequest);
        String mergeHash = mergeOperation.getMergeHash();
        this.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.logMergeActivity(pullRequest, now, mergeHash);
        this.eventPublisher.publish((Object)new PullRequestMergedEvent((Object)this, (PullRequest)pullRequest, (MinimalChangeset)(mergeHash == null ? null : new InternalMinimalChangeset(mergeHash))));
        return pullRequest;
    }

    @EventListener
    public void onRepositoryDeleteRequested(RepositoryDeletionRequestedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Repository repository = event.getRepository();
        try {
            this.cleanup(repository.getId());
        }
        catch (RuntimeException e) {
            log.error("Pull requests for " + repository.getProject().getKey() + "/" + repository.getSlug() + " could not be cleaned up", (Throwable)e);
            event.cancel(this.i18nService.createKeyedMessage("stash.service.pullrequest.cleanupfailed", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequest reopen(int repositoryId, long pullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        if (pullRequest.getState() == PullRequestState.OPEN) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.reopen.opened", new Object[0]));
        }
        if (pullRequest.getState() == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.reopen.merged", new Object[0]));
        }
        this.checkPullRequestVersion(version, pullRequest);
        this.checkUniquePullRequest(pullRequest.getFromRef(), pullRequest.getToRef());
        Ref resolvedFromRef = this.checkRefExistsForReopen(pullRequest.getFromRef());
        Ref resolvedToRef = this.checkRefExistsForReopen(pullRequest.getToRef());
        InternalPullRequestRef originalFromRef = pullRequest.getFromRef();
        String originalFromHash = originalFromRef.getLatestChangeset();
        InternalPullRequestRef originalToRef = pullRequest.getToRef();
        String originalToHash = originalToRef.getLatestChangeset();
        pullRequest = this.rescopeOnReopen(pullRequest, resolvedFromRef, resolvedToRef);
        Date now = new Date();
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.OPEN).updatedDate(now).build());
        this.logActivity(pullRequest, PullRequestAction.REOPENED, now);
        this.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.eventPublisher.publish((Object)new PullRequestReopenedEvent((Object)this, (PullRequest)pullRequest, originalFromHash, originalToHash));
        return pullRequest;
    }

    @Nonnull
    @Secured(value="Secured internally by a predicate")
    public Page<PullRequest> search(@Nonnull PullRequestSearchRequest request, @Nonnull PageRequest pageRequest) {
        return this.search(new PullRequestSearchCriteria(request), pageRequest);
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamChanges(@Nonnull PullRequestChangesRequest request, @Nonnull ChangeCallback callback) {
        Map countsByLocation;
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.maybeUpdate(pullRequest);
        if (request.isWithComments() && !(countsByLocation = this.commentHelper.countsByLocation((InternalCommentable)pullRequest)).isEmpty()) {
            callback = new CountAttributeChangeCallback(callback, countsByLocation);
        }
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).changes(((PullRequestChangeCommandParameters.Builder)new PullRequestChangeCommandParameters.Builder().maxChanges(this.maxChanges)).build(), callback).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public void streamChangesets(int repositoryId, long pullRequestId, @Nonnull ChangesetCallback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        this.scmService.getPullRequestCommandFactory((PullRequest)this.getPullRequestOrFail(repositoryId, pullRequestId)).commits(callback).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#request.repositoryId, 'REPO_READ')")
    public void streamDiff(@Nonnull PullRequestDiffRequest request, @Nonnull DiffContentCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId());
        this.maybeUpdate(pullRequest);
        if (request.isWithComments()) {
            try {
                callback.offerAnchors(this.commentHelper.findDiffAnchors(pullRequest, request.getPath()));
            }
            catch (IOException exc) {
                log.error("Error while callback.offerAnchors", (Throwable)exc);
            }
        }
        this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).diff(((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)((PullRequestDiffCommandParameters.Builder)new PullRequestDiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths(request.getPath(), new String[]{request.getSrcPath()})).whitespace(request.getWhitespace())).build(), callback).call();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_WRITE')")
    @Transactional
    public void unassignRole(int repositoryId, long pullRequestId, @Nonnull String username) {
        StashUser user = this.getUserOrFail(username);
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId().longValue(), user.getId().intValue());
        if (participant != null && participant.getRole().isExplicit()) {
            if (participant.getRole() == PullRequestRole.AUTHOR) {
                throw new UnmodifiablePullRequestRoleException(this.i18nService.createKeyedMessage("stash.service.pullrequest.role.unassign.unmodifiable", new Object[0]));
            }
            this.participantDao.update((Object)new InternalPullRequestParticipant.Builder(participant).role(PullRequestRole.PARTICIPANT).build());
            this.fireReviewerRemoved(user, pullRequest);
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public boolean unwatch(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return this.watcherService.removeCurrentUserAsWatcher((InternalWatchable)pullRequest);
    }

    @Nonnull
    @Secured(value="Permissions checks done internally")
    @Transactional
    public PullRequest update(@Nonnull PullRequestUpdateRequest request) {
        boolean changingToRef;
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalPullRequest pullRequest = this.getPullRequestOrFail(request.getRepositoryId(), request.getPullRequestId(), request.getVersion());
        if (!this.currentUserCanEdit(pullRequest)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("stash.service.pullrequest.update.permissions.insufficient", new Object[0]));
        }
        InternalPullRequestRef toPullRef = pullRequest.getToRef();
        boolean bl = changingToRef = request.getToBranchId() != null && !request.getToBranchId().equals(pullRequest.getToRef().getId());
        if (changingToRef) {
            InternalPullRequestRef fromPullRef = pullRequest.getFromRef();
            InternalRepository toRepository = pullRequest.getToRef().getRepository();
            this.checkNotSameBranches((Repository)fromPullRef.getRepository(), fromPullRef.getId(), (Repository)toRepository, request.getToBranchId());
            toPullRef = this.createPullRequestRef((Repository)toRepository, this.resolveBranchOrFail((Repository)toRepository, request.getToBranchId()));
            this.checkUniquePullRequest(fromPullRef, toPullRef);
            this.checkHasChangesets((PullRequestRef)fromPullRef, (PullRequestRef)toPullRef);
        }
        String previousDescription = pullRequest.getDescription();
        String previousTitle = pullRequest.getTitle();
        InternalPullRequestRef previousToBranch = new InternalPullRequestRef.Builder(pullRequest.getToRef()).build();
        Date now = new Date();
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).description(this.trimRightToNull(request.getDescription())).title(request.getTitle()).toRef(toPullRef).updatedDate(now).build());
        this.logActivity(pullRequest, PullRequestAction.UPDATED, now);
        this.eventPublisher.publish((Object)new PullRequestUpdatedEvent((Object)this, (PullRequest)pullRequest, previousTitle, previousDescription, (Ref)(changingToRef ? previousToBranch : null)));
        this.setReviewers(request.getReviewers(), pullRequest);
        if (changingToRef) {
            String previousFromHash = pullRequest.getFromRef().getLatestChangeset();
            String previousToHash = previousToBranch.getLatestChangeset();
            this.logRescopeActivity(pullRequest, now, previousFromHash, previousToHash);
            this.commentHelper.updateComments(pullRequest, previousFromHash, previousToHash);
            this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)pullRequest, previousFromHash, previousToHash));
        }
        return pullRequest;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Comment updateComment(int repositoryId, long pullRequestId, long commentId, int commentVersion, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        return this.commentHelper.update((InternalCommentable)this.getPullRequestOrFail(repositoryId, pullRequestId), commentId, commentVersion, commentText);
    }

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Unsecured(value="Internal interface method")
    public PullRequest updateScope(long globalId, int version, @Nonnull String newFromHash, @Nonnull String newToHash) {
        InternalPullRequest current = this.getPullRequestOrFail(globalId, version);
        InternalPullRequestRef currentFromRef = current.getFromRef();
        InternalPullRequestRef currentToRef = current.getToRef();
        String previousFromHash = currentFromRef.getLatestChangeset();
        String previousToHash = currentToRef.getLatestChangeset();
        Date now = new Date();
        InternalPullRequest.Builder builder = new InternalPullRequest.Builder(current).fromRef(new InternalPullRequestRef.Builder(currentFromRef).hash(newFromHash).build()).toRef(new InternalPullRequestRef.Builder(currentToRef).hash(newToHash).build());
        if (!StringUtils.equals((String)previousFromHash, (String)newFromHash)) {
            this.makeCurrentUserParticipantAndWatcher(current);
            builder.updatedDate(now);
        }
        InternalPullRequest updated = (InternalPullRequest)this.pullRequestDao.update((Object)builder.build());
        this.logRescopeActivity(updated, now, previousFromHash, previousToHash);
        this.commentHelper.updateComments(updated, previousFromHash, previousToHash);
        this.eventPublisher.publish((Object)new PullRequestRescopedEvent((Object)this, (PullRequest)updated, previousFromHash, previousToHash));
        return updated;
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public Watcher watch(int repositoryId, long pullRequestId) {
        return this.watcherService.addCurrentUserAsWatcher((InternalWatchable)this.getPullRequestOrFail(repositoryId, pullRequestId));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated() and hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    @Transactional
    public PullRequestParticipant withdrawApproval(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        if (pullRequest.getState() == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.approve.remove.declined", new Object[0]));
        }
        if (pullRequest.getState() == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.approve.remove.merged", new Object[0]));
        }
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId().longValue(), currentUser.getId().intValue());
        if (participant == null) {
            throw new NoSuchParticipantException(this.i18nService.createKeyedMessage("stash.service.pullrequest.approve.remove.nosuchparticipant", new Object[]{currentUser.getName()}));
        }
        return this.updateParticipantWithApproval(pullRequest, false);
    }

    private ChangesetsBetweenRequest buildChangesetsBetweenRequest(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        return new ChangesetsBetweenRequest.Builder((PullRequest)pullRequest).build();
    }

    private KeyedMessage buildMergeabilityMessage(PullRequestMergeability mergeability) {
        Preconditions.checkArgument((!mergeability.canMerge() && (mergeability.isConflicted() || !mergeability.getVetos().isEmpty()) ? 1 : 0) != 0);
        if (mergeability.isConflicted()) {
            if (mergeability.getVetos().isEmpty()) {
                return this.i18nService.createKeyedMessage("stash.service.pullrequest.merge.conflicted", new Object[0]);
            }
            return this.i18nService.createKeyedMessage("stash.service.pullrequest.merge.vetoedandconflicted", new Object[0]);
        }
        return this.i18nService.createKeyedMessage("stash.service.pullrequest.merge.vetoed", new Object[0]);
    }

    private PullRequestMergeability canMerge(InternalPullRequest pullRequest) {
        this.checkIsOpen(pullRequest);
        boolean conflicted = this.isConflicted(pullRequest);
        Collection vetoes = this.mergeRequestCheckService.check((PullRequest)pullRequest);
        return new SimplePullRequestMergeability(!conflicted && vetoes.isEmpty(), conflicted, vetoes);
    }

    private void checkHasChangesets(PullRequestRef fromRef, PullRequestRef toRef) {
        Repository fromRepository = fromRef.getRepository();
        Repository toRepository = toRef.getRepository();
        if (this.isMerged(fromRepository, fromRef.getLatestChangeset(), toRepository, toRef.getLatestChangeset())) {
            KeyedMessage message = ObjectUtils.equals((Object)fromRepository.getId(), (Object)toRepository.getId()) ? this.i18nService.createKeyedMessage("stash.service.pullrequest.create.empty.samerepository", new Object[]{toRef.getDisplayId(), fromRef.getDisplayId(), toRepository.getSlug()}) : (ObjectUtils.equals((Object)fromRepository.getProject().getId(), (Object)toRepository.getProject().getId()) ? this.i18nService.createKeyedMessage("stash.service.pullrequest.create.empty.sameproject", new Object[]{toRef.getDisplayId(), toRepository.getSlug(), fromRef.getDisplayId(), fromRepository.getSlug()}) : this.i18nService.createKeyedMessage("stash.service.pullrequest.create.empty", new Object[]{toRef.getDisplayId(), toRepository.getProject().getName(), toRepository.getSlug(), fromRef.getDisplayId(), fromRepository.getProject().getName(), fromRepository.getSlug()}));
            throw new EmptyPullRequestException(fromRef, toRef, message);
        }
    }

    private void checkIsOpen(InternalPullRequest pullRequest) {
        PullRequestState state = pullRequest.getState();
        if (state == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.merge.declined", new Object[0]));
        }
        if (state == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.merge.merged", new Object[0]));
        }
    }

    private void checkNotSameBranches(Repository fromRepository, String fromBranch, Repository toRepository, String toBranch) {
        if (ObjectUtils.equals((Object)fromRepository.getId(), (Object)toRepository.getId()) && StringUtils.equals((String)fromBranch, (String)toBranch)) {
            throw new InvalidPullRequestTargetException(this.i18nService.createKeyedMessage("stash.service.pullrequest.create.samebranch", new Object[0]));
        }
    }

    private void checkPullRequestVersion(int version, InternalPullRequest pullRequest) {
        if (pullRequest.getVersion() != version) {
            throw new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.outofdate", new Object[0]), (PullRequest)pullRequest, version);
        }
    }

    private Ref checkRefExistsForReopen(InternalPullRequestRef ref) {
        Ref resolvedRef = this.metadataService.resolveRef((Repository)ref.getRepository(), ref.getId());
        if (resolvedRef == null) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.refdeleted", new Object[]{ref.getDisplayId()}));
        }
        return resolvedRef;
    }

    private void checkSameHierarchies(Repository fromRepository, Repository toRepository) {
        if (!StringUtils.equals((String)fromRepository.getHierarchyId(), (String)toRepository.getHierarchyId())) {
            throw new InvalidPullRequestTargetException(this.i18nService.createKeyedMessage("stash.service.pullrequest.create.notsamehierarchy", new Object[0]));
        }
    }

    private void checkUniquePullRequest(InternalPullRequestRef fromRef, InternalPullRequestRef toRef) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByRefs(fromRef, toRef);
        if (pullRequest != null) {
            throw new DuplicatePullRequestException((PullRequest)pullRequest, this.i18nService.createKeyedMessage("stash.service.pullrequest.create.duplicate", new Object[0]));
        }
    }

    private void cleanup(final int repositoryId) {
        int count = this.pullRequestDao.deleteByToRepository(repositoryId);
        log.debug("Deleted {} pull request(s) TO repository {}", (Object)count, (Object)repositoryId);
        PagedIterable unmerged = new PagedIterable((PageProvider)new PageProvider<InternalPullRequest>(){

            public Page<InternalPullRequest> get(PageRequest request) {
                return PullRequestServiceImpl.this.pullRequestDao.findUnmergedByFromRepository(repositoryId, request);
            }
        }, PageUtils.newRequest((int)0, (int)50));
        for (InternalPullRequest pullRequest : unmerged) {
            this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest).effectiveDiff().call();
            log.debug("Resolved up-to-date diff for {}/{}", (Object)pullRequest.getScopeRepository().getId(), (Object)pullRequest.getScopedId());
        }
        count = this.pullRequestDao.declineByFromRepository(repositoryId);
        log.debug("Declined {} open pull request(s) FROM repository {}", (Object)count, (Object)repositoryId);
        count = this.pullRequestDao.overwriteFromRepository(repositoryId);
        log.debug("Updated {} pull request(s) FROM repository {} to be intra-repository", (Object)count, (Object)repositoryId);
    }

    private InternalPullRequestRef createPullRequestRef(Repository fromRepository, Ref fromRef) {
        return (InternalPullRequestRef)ValidationUtils.validate((Validator)this.validator, (Object)new InternalPullRequestRef.Builder().repository(InternalConverter.convertToInternalRepository((Repository)fromRepository)).ref(fromRef).build(), (Class[])new Class[0]);
    }

    private boolean currentUserCanEdit(InternalPullRequest pullRequest) {
        InternalRepository repository = pullRequest.getScopeRepository();
        return this.isCurrentUser(pullRequest.getAuthor().getUser()) && this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_READ) || this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_WRITE);
    }

    private void enrichActivities(InternalPullRequest pullRequest, Page<InternalPullRequestActivity> page) {
        if (page.getSize() > 0) {
            for (PullRequestActivityEnricher enricher : this.activityEnrichers) {
                enricher.enrich(pullRequest, page);
            }
        }
    }

    private void fireOpenRequested(PullRequest pullRequest, Set<StashUser> reviewers) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new PullRequestOpenRequestedEvent((Object)this, pullRequest, reviewers, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.pullrequest.creationcanceled", new Object[0]);
            throw new PullRequestOpenCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireParticipantEvents(InternalPullRequest pullRequest, Set<StashUser> removedReviewers, Set<StashUser> removedReviewersNoLongerParticipating, Set<StashUser> addedReviewers, Set<StashUser> addedReviewersNewlyParticipating) {
        if (!addedReviewers.isEmpty() || !removedReviewers.isEmpty()) {
            this.eventPublisher.publish((Object)new PullRequestRolesUpdatedEvent((Object)this, (PullRequest)pullRequest, addedReviewers, removedReviewers));
        }
        if (!addedReviewersNewlyParticipating.isEmpty() || !removedReviewersNoLongerParticipating.isEmpty()) {
            this.eventPublisher.publish((Object)new PullRequestParticipantsUpdatedEvent((Object)this, (PullRequest)pullRequest, addedReviewersNewlyParticipating, removedReviewersNoLongerParticipating));
        }
    }

    private void fireParticipantAdded(InternalPullRequest pullRequest, StashUser user) {
        this.eventPublisher.publish((Object)new PullRequestParticipantsUpdatedEvent((Object)this, (PullRequest)pullRequest, Collections.singleton(user), Collections.emptySet()));
    }

    private void fireReviewerAdded(InternalPullRequest pullRequest, StashUser user, boolean newParticipant) {
        this.eventPublisher.publish((Object)new PullRequestRolesUpdatedEvent((Object)this, (PullRequest)pullRequest, Collections.singleton(user), Collections.emptySet()));
        if (newParticipant) {
            this.fireParticipantAdded(pullRequest, user);
        }
    }

    private void fireReviewerRemoved(StashUser user, InternalPullRequest pullRequest) {
        this.eventPublisher.publish((Object)new PullRequestRolesUpdatedEvent((Object)this, (PullRequest)pullRequest, Collections.emptySet(), Collections.singleton(user)));
    }

    private InternalStashUser getCurrentUser() {
        return InternalConverter.convertToInternalUser((StashUser)this.authenticationContext.getCurrentUser());
    }

    private InternalPullRequestActivity getActivityOrFail(InternalPullRequest pullRequest, long activityId) {
        InternalPullRequestActivity activity = (InternalPullRequestActivity)this.activityDao.getById((Object)activityId);
        if (activity == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("stash.service.pullrequest.activity.nosuchactivity", new Object[]{activityId}));
        }
        if (!activity.getPullRequest().equals(pullRequest)) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("stash.service.pullrequest.activity.nosuchactivityforrequest", new Object[]{activityId}));
        }
        return activity;
    }

    private InternalPullRequest getPullRequestOrFail(int repositoryId, long pullRequestId) {
        InternalPullRequest pullRequest = this.pullRequestDao.findByRepositoryScopedId(repositoryId, pullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("stash.service.pullrequest.repository.nosuchrequest", new Object[]{pullRequestId, repositoryId}));
        }
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(int repositoryId, long pullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(repositoryId, pullRequestId);
        this.checkPullRequestVersion(version, pullRequest);
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(long globalPullRequestId) {
        InternalPullRequest pullRequest = (InternalPullRequest)this.pullRequestDao.getById((Object)globalPullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("stash.service.pullrequest.global.nosuchrequest", new Object[]{globalPullRequestId}));
        }
        return pullRequest;
    }

    private InternalPullRequest getPullRequestOrFail(long globalPullRequestId, int version) {
        InternalPullRequest pullRequest = this.getPullRequestOrFail(globalPullRequestId);
        this.checkPullRequestVersion(version, pullRequest);
        return pullRequest;
    }

    private StashUser getUserAndEnsureHasReadPerms(String username, int repositoryId, PullRequestRole role) {
        StashUser user = this.getUserOrFail(username);
        if (!this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER)) {
            throw new InvalidPullRequestParticipantException(this.i18nService.createKeyedMessage("stash.service.pullrequest.participant.license", new Object[]{username}), role);
        }
        if (!this.permissionService.hasRepositoryPermission(user, repositoryId, Permission.REPO_READ)) {
            throw new InvalidPullRequestParticipantException(this.i18nService.createKeyedMessage("stash.service.pullrequest.participant.perms", new Object[]{username}), role);
        }
        return user;
    }

    private StashUser getUserOrFail(String username) {
        StashUser user = this.userService.getUserByName(username);
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("stash.service.pullrequest.nosuchuser", new Object[]{username}), username);
        }
        return user;
    }

    private boolean isConflicted(InternalPullRequest pullRequest) {
        ScmPullRequestCommandFactory commandFactory = this.scmService.getPullRequestCommandFactory((PullRequest)pullRequest);
        Boolean canMerge = (Boolean)commandFactory.canMerge().call();
        return canMerge != null && canMerge == false;
    }

    private PullRequest internalDecline(InternalPullRequest pullRequest, int version) {
        if (pullRequest.getState() == PullRequestState.DECLINED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.decline.declined", new Object[0]));
        }
        if (pullRequest.getState() == PullRequestState.MERGED) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.decline.merged", new Object[0]));
        }
        this.checkPullRequestVersion(version, pullRequest);
        Date now = new Date();
        pullRequest = (InternalPullRequest)this.pullRequestDao.update((Object)new InternalPullRequest.Builder(pullRequest).state(PullRequestState.DECLINED).updatedDate(now).build());
        this.logActivity(pullRequest, PullRequestAction.DECLINED, now);
        this.makeCurrentUserParticipantAndWatcher(pullRequest);
        this.eventPublisher.publish((Object)new PullRequestDeclinedEvent((Object)this, (PullRequest)pullRequest));
        return pullRequest;
    }

    private boolean isCurrentUser(StashUser user) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        return StringUtils.equals((String)user.getName(), (String)(currentUser == null ? null : currentUser.getName()));
    }

    private boolean isMerged(Repository fromRepository, String fromHash, Repository toRepository, String toHash) {
        IsEmptyChangesetCallback callback = new IsEmptyChangesetCallback();
        this.scmService.getCommandFactory(toRepository).commits(new CommitsCommandParameters.Builder().include(fromHash, new String[0]).exclude(toHash, new String[0]).secondaryRepository(fromRepository).build(), (ChangesetCallback)callback).call();
        return callback.isEmpty();
    }

    private void logActivity(InternalPullRequest pullRequest, PullRequestAction action) {
        this.logActivity(pullRequest, action, new Date());
    }

    private void logActivity(InternalPullRequest pullRequest, PullRequestAction action, Date when) {
        this.activityDao.create((Object)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(pullRequest).action(action)).createdDate(when)).user(this.getCurrentUser())).build());
    }

    private void logApprovalActivity(InternalPullRequest pullRequest, Date when, boolean isApproved) {
        this.activityDao.create((Object)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(pullRequest).action(isApproved ? PullRequestAction.APPROVED : PullRequestAction.UNAPPROVED)).createdDate(when)).user(this.getCurrentUser())).build());
    }

    private void logMergeActivity(InternalPullRequest pullRequest, Date when, String hash) {
        this.activityDao.create((Object)((InternalPullRequestMergeActivity.Builder)((InternalPullRequestMergeActivity.Builder)new InternalPullRequestMergeActivity.Builder(pullRequest).createdDate(when)).hash(hash).user(this.getCurrentUser())).build());
    }

    private void logRescopeActivity(InternalPullRequest pullRequest, Date when, String previousFromHash, String previousToHash) {
        InternalPullRequestRescopeActivity activity = ((InternalPullRequestRescopeActivity.Builder)((InternalPullRequestRescopeActivity.Builder)new InternalPullRequestRescopeActivity.Builder(pullRequest).createdDate(when)).fromHash(pullRequest.getFromRef().getLatestChangeset()).previousFromHash(previousFromHash).previousToHash(previousToHash).toHash(pullRequest.getToRef().getLatestChangeset()).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        this.rescopeProcessor.queue(activity);
    }

    @Nonnull
    private InternalPullRequestParticipant makeCurrentUserParticipantAndWatcher(InternalPullRequest pullRequest) {
        return this.makeParticipant(pullRequest, this.authenticationContext.getCurrentUser(), true);
    }

    @Nonnull
    private InternalPullRequestParticipant makeParticipant(InternalPullRequest pullRequest, StashUser user, boolean addWatchIfNewParticipant) {
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId().longValue(), user.getId().intValue());
        if (participant == null) {
            participant = (InternalPullRequestParticipant)this.participantDao.create((Object)((InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
            this.fireParticipantAdded(pullRequest, user);
            if (addWatchIfNewParticipant) {
                this.watcherService.addUserAsWatcher((InternalWatchable)pullRequest, user);
            }
        }
        return participant;
    }

    private void maybeUpdate(InternalPullRequest pullRequest) {
        this.commentHelper.maybeUpdateComments(pullRequest);
    }

    private InternalPullRequest rescopeOnReopen(InternalPullRequest pullRequest, @Nonnull Ref resolvedFromRef, @Nonnull Ref resolvedToRef) {
        InternalPullRequestRef originalFromRef = pullRequest.getFromRef();
        InternalPullRequestRef originalToRef = pullRequest.getToRef();
        String latestFromHash = resolvedFromRef.getLatestChangeset();
        String latestToHash = resolvedToRef.getLatestChangeset();
        if (originalFromRef.getLatestChangeset().equals(latestFromHash) && originalToRef.getLatestChangeset().equals(latestToHash)) {
            return pullRequest;
        }
        if (this.isMerged(originalFromRef.getRepository(), latestFromHash, originalToRef.getRepository(), latestToHash)) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("stash.service.pullrequest.reopen.empty", new Object[0]));
        }
        this.updateScope(pullRequest.getGlobalId(), pullRequest.getVersion(), latestFromHash, latestToHash);
        return pullRequest;
    }

    private Ref resolveBranchOrFail(Repository repo, String branch) {
        Ref ref = this.metadataService.resolveRef(repo, branch);
        if (ref == null) {
            throw new NoSuchChangesetException(this.i18nService.createKeyedMessage("stash.service.pullrequest.nosuchref", new Object[]{repo.getSlug(), repo.getProject().getKey(), branch}), branch);
        }
        return ref;
    }

    private Map<String, StashUser> resolveCurrentAndNewAllParticipants(Set<String> newReviewers, InternalPullRequest pullRequest) {
        HashSet existingUsers = Sets.newHashSet();
        HashSet existingUserNames = Sets.newHashSet();
        for (PullRequestParticipant participant : pullRequest.getAllParticipants()) {
            existingUsers.add(participant.getUser());
            existingUserNames.add(participant.getUser().getName());
        }
        HashMap usersByUsername = Maps.newHashMap();
        for (StashUser user : this.resolveReviewersOrFail(newReviewers, existingUserNames, (Repository)pullRequest.getScopeRepository(), false)) {
            usersByUsername.put(user.getName(), user);
        }
        for (StashUser user : existingUsers) {
            usersByUsername.put(user.getName(), user);
        }
        return usersByUsername;
    }

    private Set<StashUser> resolveReviewersOrFail(Set<String> reviewers, Set<String> existingReviewers, Repository toRepository, boolean forCreation) {
        HashMap participantErrors = Maps.newHashMap();
        HashSet resolvedReviewers = Sets.newHashSet();
        for (String reviewer : reviewers) {
            boolean isExistingReviewer;
            StashUser resolvedReviewer = this.userService.getUserByName(reviewer, isExistingReviewer = existingReviewers.contains(reviewer));
            if (resolvedReviewer == null) {
                participantErrors.put(reviewer, this.i18nService.createKeyedMessage("stash.service.pullrequest.create.invalidparticipant", new Object[]{reviewer}));
                continue;
            }
            boolean isLicensed = this.permissionService.hasGlobalPermission(resolvedReviewer, Permission.LICENSED_USER);
            if (isLicensed && !isExistingReviewer && !this.permissionService.hasRepositoryPermission(resolvedReviewer, toRepository, Permission.REPO_READ)) {
                participantErrors.put(reviewer, this.i18nService.createKeyedMessage("stash.service.pullrequest.create.unauthorisedparticipant", new Object[]{resolvedReviewer.getDisplayName()}));
                continue;
            }
            if (!isExistingReviewer && !isLicensed) {
                participantErrors.put(reviewer, this.i18nService.createKeyedMessage("stash.service.pullrequest.participant.license", new Object[]{resolvedReviewer.getDisplayName()}));
                continue;
            }
            if (forCreation && reviewer.equals(this.getCurrentUser().getUsername())) continue;
            resolvedReviewers.add(resolvedReviewer);
        }
        if (!participantErrors.isEmpty()) {
            throw new InvalidPullRequestReviewersException(this.i18nService.createKeyedMessage("stash.service.pullrequest.create.invalidparticipants", new Object[0]), (Map)participantErrors, (Set)resolvedReviewers);
        }
        return resolvedReviewers;
    }

    private Page<PullRequest> search(PullRequestSearchCriteria criteria, PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        Page page = this.pullRequestDao.search(criteria, pageRequest.buildRestrictedPageRequest(this.maxPullRequests), this.predicateFactory.createPullRequestPermissionPredicate(Permission.REPO_READ));
        if (page.getSize() > 0) {
            Set pullRequestIds = Chainable.chain((Iterable)page.getValues()).transform(InternalPullRequest.TO_GLOBAL_ID).toSet();
            final Map commentsByPullRequest = this.activityDao.countCommentsByPullRequest(pullRequestIds);
            page = page.transform((Function)new Function<InternalPullRequest, InternalPullRequest>(){

                public InternalPullRequest apply(InternalPullRequest pullRequest) {
                    Long comments = (Long)commentsByPullRequest.get(pullRequest.getGlobalId());
                    if (comments != null) {
                        pullRequest.setAttributes(new AttributeMap.Builder().add("commentCount", new String[]{comments.toString()}).build());
                    }
                    return pullRequest;
                }
            });
        }
        return PageUtils.asPageOf(PullRequest.class, (Page)page);
    }

    private void setReviewers(Set<String> newReviewerNames, InternalPullRequest pullRequest) {
        final Map<String, StashUser> usersByUsername = this.resolveCurrentAndNewAllParticipants(newReviewerNames, pullRequest);
        Function<String, StashUser> lookupUserByUsername = new Function<String, StashUser>(){

            public StashUser apply(String username) {
                return (StashUser)usersByUsername.get(username);
            }
        };
        StashUser author = pullRequest.getAuthor().getUser();
        HashSet currentReviewers = Sets.newHashSet((Iterable)Collections2.transform((Collection)pullRequest.getReviewers(), TO_USER));
        HashSet currentParticipants = Sets.newHashSet((Iterable)Collections2.transform((Collection)pullRequest.getParticipants(), TO_USER));
        Sets.SetView currentNonAuthors = Sets.union((Set)currentReviewers, (Set)currentParticipants);
        HashSet newReviewers = Sets.newHashSet((Iterable)Collections2.transform(newReviewerNames, (Function)lookupUserByUsername));
        Sets.SetView removedReviewers = Sets.difference((Set)currentReviewers, (Set)newReviewers);
        Sets.SetView addedReviewers = Sets.difference((Set)newReviewers, (Set)currentReviewers);
        Sets.SetView addedReviewersNewlyParticipating = Sets.difference((Set)addedReviewers, (Set)currentNonAuthors);
        Set usersWithActivities = this.activityDao.findUsersWithActivities(pullRequest.getGlobalId().longValue(), Collections.emptySet(), Collections.singleton(PullRequestAction.RESCOPED));
        Sets.SetView removedReviewersNoLongerParticipating = Sets.difference((Set)removedReviewers, (Set)usersWithActivities);
        this.updateAndCreateParticipants(pullRequest, author, (Set<StashUser>)removedReviewers, (Set<StashUser>)removedReviewersNoLongerParticipating, (Set<StashUser>)addedReviewers, (Set<StashUser>)addedReviewersNewlyParticipating);
        this.fireParticipantEvents(pullRequest, (Set<StashUser>)removedReviewers, (Set<StashUser>)removedReviewersNoLongerParticipating, (Set<StashUser>)addedReviewers, (Set<StashUser>)addedReviewersNewlyParticipating);
    }

    private String trimRightToNull(String description) {
        return StringUtils.defaultIfEmpty((String)StringUtils.stripEnd((String)description, null), null);
    }

    private void updateAndCreateParticipants(InternalPullRequest pullRequest, StashUser author, Set<StashUser> removedReviewers, Set<StashUser> removedReviewersNoLongerParticipating, Set<StashUser> addedReviewers, Set<StashUser> addedReviewersNewlyParticipating) {
        if (addedReviewers.contains(author)) {
            throw new UnmodifiablePullRequestRoleException(this.i18nService.createKeyedMessage("stash.service.pullrequest.role.assign.unmodifiable", new Object[0]));
        }
        for (PullRequestParticipant pullRequestParticipant : ImmutableSet.copyOf((Collection)pullRequest.getAllParticipants())) {
            StashUser user = pullRequestParticipant.getUser();
            if (removedReviewersNoLongerParticipating.contains(user)) {
                this.participantDao.delete((Object)InternalConverter.convertToInternalParticipant((PullRequestParticipant)pullRequestParticipant));
                this.watcherService.removeUserAsWatcher((InternalWatchable)pullRequest, user);
                continue;
            }
            if (removedReviewers.contains(user)) {
                if (pullRequestParticipant.getRole() == PullRequestRole.PARTICIPANT) continue;
                this.participantDao.update((Object)new InternalPullRequestParticipant.Builder(InternalConverter.convertToInternalParticipant((PullRequestParticipant)pullRequestParticipant)).role(PullRequestRole.PARTICIPANT).build());
                continue;
            }
            if (!addedReviewers.contains(user) || pullRequestParticipant.getRole() == PullRequestRole.REVIEWER) continue;
            this.participantDao.update((Object)new InternalPullRequestParticipant.Builder(InternalConverter.convertToInternalParticipant((PullRequestParticipant)pullRequestParticipant)).role(PullRequestRole.REVIEWER).build());
        }
        for (StashUser stashUser : addedReviewersNewlyParticipating) {
            this.participantDao.create((Object)((InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).role(PullRequestRole.REVIEWER).user(InternalConverter.convertToInternalUser((StashUser)stashUser))).build());
            this.watcherService.addUserAsWatcher((InternalWatchable)pullRequest, stashUser);
        }
    }

    private PullRequestParticipant updateParticipantWithApproval(InternalPullRequest pullRequest, boolean approval) {
        InternalPullRequestParticipant participant = this.makeCurrentUserParticipantAndWatcher(pullRequest);
        if (participant.isApproved() != approval) {
            participant = (InternalPullRequestParticipant)this.participantDao.update((Object)new InternalPullRequestParticipant.Builder(participant).approved(approval).build());
            if (approval) {
                this.eventPublisher.publish((Object)new PullRequestApprovedEvent((Object)this, (PullRequestParticipant)participant, (PullRequest)pullRequest));
            } else {
                this.eventPublisher.publish((Object)new PullRequestUnapprovedEvent((Object)this, (PullRequestParticipant)participant, (PullRequest)pullRequest));
            }
            this.logApprovalActivity(pullRequest, new Date(), approval);
        }
        return participant;
    }

    private class MergeAndUpdatePullRequestOperation
    implements UncheckedOperation<InternalPullRequest> {
        private final StashUser author;
        private final Date date;
        private final InternalPullRequest pullRequest;
        private final InternalPullRequestRef fromRef;
        private final InternalPullRequestRef toRef;
        private String mergeHash;

        private MergeAndUpdatePullRequestOperation(InternalPullRequest pullRequest, StashUser author, Date date) {
            this.author = author;
            this.date = date;
            this.pullRequest = pullRequest;
            this.fromRef = pullRequest.getFromRef();
            this.toRef = pullRequest.getToRef();
        }

        public String getMergeHash() {
            return this.mergeHash;
        }

        public InternalPullRequest perform() throws RuntimeException {
            InternalRepository repository = this.pullRequest.getScopeRepository();
            Branch branch = (Branch)PullRequestServiceImpl.this.scmService.getPullRequestCommandFactory((PullRequest)this.pullRequest).merge(((PullRequestMergeCommandParameters.Builder)((PullRequestMergeCommandParameters.Builder)new PullRequestMergeCommandParameters.Builder().author(this.author)).message(this.buildMergeMessage())).build()).call();
            String string = this.mergeHash = branch == null ? null : branch.getLatestChangeset();
            if (this.mergeHash == null) {
                log.error("Merge of pull request {} in repository {} of project {} succeeded but no merge hash was available", new Object[]{this.pullRequest.getId(), repository.getSlug(), repository.getProject().getKey()});
            }
            return (InternalPullRequest)PullRequestServiceImpl.this.pullRequestDao.update((Object)new InternalPullRequest.Builder(this.pullRequest).state(PullRequestState.MERGED).updatedDate(this.date).fromRef(new InternalPullRequestRef.Builder(this.fromRef).build()).toRef(new InternalPullRequestRef.Builder(this.toRef).build()).build());
        }

        private String buildMergeMessage() {
            String format = "Merge pull request #%1$d in %2$s/%3$s from ";
            format = this.pullRequest.isCrossRepository() ? format + "%5$s/%6$s:%7$s to %4$s" : format + "%7$s to %4$s";
            return String.format(format, this.pullRequest.getId(), this.toRef.getRepository().getProject().getKey(), this.toRef.getRepository().getSlug(), this.toRef.getDisplayId(), this.fromRef.getRepository().getProject().getKey(), this.fromRef.getRepository().getSlug(), this.fromRef.getDisplayId());
        }
    }

    private static class IsEmptyChangesetCallback
    extends AbstractChangesetCallback {
        private boolean empty = true;

        private IsEmptyChangesetCallback() {
        }

        public boolean onChangeset(@Nonnull Changeset changeset) throws IOException {
            this.empty = false;
            return false;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    private static class ChangesetCountingCallback
    extends AbstractChangesetCallback {
        private int count;

        private ChangesetCountingCallback() {
        }

        public boolean onChangeset(@Nonnull Changeset changeset) throws IOException {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }
}

