/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.commit.CommitService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestActivityVisitor;
import com.atlassian.stash.pull.PullRequestMergeActivity;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.Page;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MergePullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private final PullRequestActivityVisitor mergeVisitor;

    @Autowired
    public MergePullRequestActivityEnricher(CommitService commitService) {
        this.mergeVisitor = new MergeActivityVisitor(commitService);
    }

    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Page<InternalPullRequestActivity> activities) {
        for (InternalPullRequestActivity activity : activities.getValues()) {
            activity.accept(this.mergeVisitor);
        }
    }

    private static class MergeActivityVisitor
    extends AbstractPullRequestActivityVisitor {
        private final CommitService commitService;

        private MergeActivityVisitor(CommitService commitService) {
            this.commitService = commitService;
        }

        public void visit(@Nonnull PullRequestMergeActivity activity) {
            InternalPullRequestMergeActivity mergeActivity = (InternalPullRequestMergeActivity)activity;
            String mergeHash = mergeActivity.getHash();
            if (mergeHash != null && mergeActivity.getChangeset() == null) {
                mergeActivity.setChangeset(this.commitService.getChangeset((Repository)mergeActivity.getPullRequest().getScopeRepository(), mergeHash));
            }
        }
    }
}

