/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.commit;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.commit.CommitDiscussionCommentAddedEvent;
import com.atlassian.stash.event.commit.CommitDiscussionCommentRepliedEvent;
import com.atlassian.stash.internal.notification.NotificationManager;
import com.atlassian.stash.notification.Notification;
import com.atlassian.stash.notification.commit.CommitDiscussionCommentAddedNotification;
import com.atlassian.stash.notification.commit.CommitDiscussionCommentRepliedNotification;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommitDiscussionNotificationProducer {
    private final NotificationManager notificationManager;

    @Autowired
    public CommitDiscussionNotificationProducer(@Nonnull NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @EventListener
    public void onCommitDiscussionCommentAdded(CommitDiscussionCommentAddedEvent event) {
        CommitDiscussionCommentAddedNotification notification = new CommitDiscussionCommentAddedNotification(event.getUser(), event.getDate(), event.getDiscussion(), event.getComment(), event.getAnchor());
        this.notificationManager.dispatch((Notification)notification);
    }

    @EventListener
    public void onCommitDiscussionCommentReplied(CommitDiscussionCommentRepliedEvent event) {
        CommitDiscussionCommentRepliedNotification notification = new CommitDiscussionCommentRepliedNotification(event.getUser(), event.getDate(), event.getDiscussion(), event.getComment(), event.getParent());
        this.notificationManager.dispatch((Notification)notification);
    }
}

